/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.snapshot;

import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.errorhandling.ForeignException;
import org.apache.hadoop.hbase.errorhandling.TimeoutExceptionInjector;
import org.apache.hadoop.hbase.master.MasterServices;
import org.apache.hadoop.hbase.master.snapshot.TakeSnapshotHandler;
import org.apache.hadoop.hbase.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.snapshot.CopyRecoveredEditsTask;
import org.apache.hadoop.hbase.snapshot.ReferenceRegionHFilesTask;
import org.apache.hadoop.hbase.snapshot.SnapshotDescriptionUtils;
import org.apache.hadoop.hbase.snapshot.TableInfoCopyTask;
import org.apache.hadoop.hbase.snapshot.TakeSnapshotUtils;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.zookeeper.KeeperException;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class DisabledTableSnapshotHandler
extends TakeSnapshotHandler {
    private static final Log LOG = LogFactory.getLog(DisabledTableSnapshotHandler.class);
    private final TimeoutExceptionInjector timeoutInjector;

    public DisabledTableSnapshotHandler(HBaseProtos.SnapshotDescription snapshot, MasterServices masterServices) throws IOException {
        super(snapshot, masterServices);
        this.timeoutInjector = TakeSnapshotUtils.getMasterTimerAndBindToMonitor(snapshot, this.conf, this.monitor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void snapshotRegions(List<Pair<HRegionInfo, ServerName>> regionsAndLocations) throws IOException, KeeperException {
        try {
            this.timeoutInjector.start();
            HashSet<String> serverNames = new HashSet<String>();
            HashSet<HRegionInfo> regions = new HashSet<HRegionInfo>();
            for (Pair<HRegionInfo, ServerName> p : regionsAndLocations) {
                regions.add(p.getFirst());
                serverNames.add(p.getSecond().toString());
            }
            LOG.info((Object)("Starting to write region info and WALs for regions for offline snapshot:" + SnapshotDescriptionUtils.toString(this.snapshot)));
            for (HRegionInfo regionInfo : regions) {
                Path snapshotRegionDir = TakeSnapshotUtils.getRegionSnapshotDirectory(this.snapshot, this.rootDir, regionInfo.getEncodedName());
                HRegion.writeRegioninfoOnFilesystem(regionInfo, snapshotRegionDir, this.fs, this.conf);
                this.monitor.rethrowException();
                Path regionDir = HRegion.getRegionDir(this.rootDir, regionInfo);
                new CopyRecoveredEditsTask(this.snapshot, this.monitor, this.fs, regionDir, snapshotRegionDir).call();
                this.monitor.rethrowException();
                new ReferenceRegionHFilesTask(this.snapshot, this.monitor, regionDir, this.fs, snapshotRegionDir).call();
                this.monitor.rethrowException();
            }
            LOG.info((Object)("Starting to copy tableinfo for offline snapshot: " + SnapshotDescriptionUtils.toString(this.snapshot)));
            TableInfoCopyTask tableInfoCopyTask = new TableInfoCopyTask(this.monitor, this.snapshot, this.fs, FSUtils.getRootDir(this.conf));
            tableInfoCopyTask.call();
            this.monitor.rethrowException();
        }
        catch (Exception e) {
            String reason = "Failed snapshot " + SnapshotDescriptionUtils.toString(this.snapshot) + " due to exception:" + e.getMessage();
            ForeignException ee = new ForeignException(reason, e);
            this.monitor.receive(ee);
        }
        finally {
            LOG.debug((Object)("Marking snapshot" + SnapshotDescriptionUtils.toString(this.snapshot) + " as finished."));
            this.timeoutInjector.complete();
        }
    }
}

