/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.snapshot;

import java.io.IOException;
import java.util.Collection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.master.cleaner.BaseLogCleanerDelegate;
import org.apache.hadoop.hbase.master.snapshot.SnapshotFileCache;
import org.apache.hadoop.hbase.snapshot.SnapshotReferenceUtil;
import org.apache.hadoop.hbase.util.FSUtils;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class SnapshotLogCleaner
extends BaseLogCleanerDelegate {
    private static final Log LOG = LogFactory.getLog(SnapshotLogCleaner.class);
    static final String HLOG_CACHE_REFRESH_PERIOD_CONF_KEY = "hbase.master.hlogcleaner.plugins.snapshot.period";
    private static final long DEFAULT_HLOG_CACHE_REFRESH_PERIOD = 300000L;
    private SnapshotFileCache cache;

    @Override
    public synchronized boolean isLogDeletable(Path filePath) {
        try {
            if (null == this.cache) {
                return false;
            }
            return !this.cache.contains(filePath.getName());
        }
        catch (IOException e) {
            LOG.error((Object)("Exception while checking if:" + filePath + " was valid, keeping it just in case."), (Throwable)e);
            return false;
        }
    }

    @Override
    public void setConf(Configuration conf) {
        super.setConf(conf);
        try {
            long cacheRefreshPeriod = conf.getLong(HLOG_CACHE_REFRESH_PERIOD_CONF_KEY, 300000L);
            final FileSystem fs = FSUtils.getCurrentFileSystem(conf);
            Path rootDir = FSUtils.getRootDir(conf);
            this.cache = new SnapshotFileCache(fs, rootDir, cacheRefreshPeriod, cacheRefreshPeriod, "snapshot-log-cleaner-cache-refresher", new SnapshotFileCache.SnapshotFileInspector(){

                @Override
                public Collection<String> filesUnderSnapshot(Path snapshotDir) throws IOException {
                    return SnapshotReferenceUtil.getHLogNames(fs, snapshotDir);
                }
            });
        }
        catch (IOException e) {
            LOG.error((Object)"Failed to create snapshot log cleaner", (Throwable)e);
        }
    }

    @Override
    public void stop(String why) {
        this.cache.stop(why);
    }

    @Override
    public boolean isStopped() {
        return this.cache.isStopped();
    }
}

