/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.snapshot;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.CancellationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.catalog.MetaReader;
import org.apache.hadoop.hbase.errorhandling.ForeignException;
import org.apache.hadoop.hbase.errorhandling.ForeignExceptionDispatcher;
import org.apache.hadoop.hbase.errorhandling.ForeignExceptionSnare;
import org.apache.hadoop.hbase.executor.EventHandler;
import org.apache.hadoop.hbase.master.MasterServices;
import org.apache.hadoop.hbase.master.SnapshotSentinel;
import org.apache.hadoop.hbase.master.snapshot.MasterSnapshotVerifier;
import org.apache.hadoop.hbase.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.snapshot.SnapshotCreationException;
import org.apache.hadoop.hbase.snapshot.SnapshotDescriptionUtils;
import org.apache.hadoop.hbase.snapshot.TableInfoCopyTask;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.zookeeper.KeeperException;

@InterfaceAudience.Private
public abstract class TakeSnapshotHandler
extends EventHandler
implements SnapshotSentinel,
ForeignExceptionSnare {
    private static final Log LOG = LogFactory.getLog(TakeSnapshotHandler.class);
    private volatile boolean finished;
    protected final MasterServices master;
    protected final HBaseProtos.SnapshotDescription snapshot;
    protected final Configuration conf;
    protected final FileSystem fs;
    protected final Path rootDir;
    private final Path snapshotDir;
    protected final Path workingDir;
    private final MasterSnapshotVerifier verifier;
    protected final ForeignExceptionDispatcher monitor;

    public TakeSnapshotHandler(HBaseProtos.SnapshotDescription snapshot, MasterServices masterServices) throws IOException {
        super(masterServices, EventHandler.EventType.C_M_SNAPSHOT_TABLE);
        assert (snapshot != null) : "SnapshotDescription must not be nul1";
        assert (masterServices != null) : "MasterServices must not be nul1";
        this.master = masterServices;
        this.snapshot = snapshot;
        this.conf = this.master.getConfiguration();
        this.fs = this.master.getMasterFileSystem().getFileSystem();
        this.rootDir = this.master.getMasterFileSystem().getRootDir();
        this.snapshotDir = SnapshotDescriptionUtils.getCompletedSnapshotDir(snapshot, this.rootDir);
        this.workingDir = SnapshotDescriptionUtils.getWorkingSnapshotDir(snapshot, this.rootDir);
        this.monitor = new ForeignExceptionDispatcher();
        this.loadTableDescriptor();
        this.verifier = new MasterSnapshotVerifier(masterServices, snapshot, this.rootDir);
    }

    private HTableDescriptor loadTableDescriptor() throws FileNotFoundException, IOException {
        String name = this.snapshot.getTable();
        HTableDescriptor htd = this.master.getTableDescriptors().get(name);
        if (htd == null) {
            throw new IOException("HTableDescriptor missing for " + name);
        }
        return htd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process() {
        LOG.info((Object)("Running table snapshot operation " + (Object)((Object)this.eventType) + " on table " + this.snapshot.getTable()));
        try {
            SnapshotDescriptionUtils.writeSnapshotInfo(this.snapshot, this.workingDir, this.fs);
            new TableInfoCopyTask(this.monitor, this.snapshot, this.fs, this.rootDir).call();
            this.monitor.rethrowException();
            List<Pair<HRegionInfo, ServerName>> regionsAndLocations = MetaReader.getTableRegionsAndLocations(this.server.getCatalogTracker(), Bytes.toBytes(this.snapshot.getTable()), true);
            this.snapshotRegions(regionsAndLocations);
            HashSet<String> serverNames = new HashSet<String>();
            for (Pair<HRegionInfo, ServerName> p : regionsAndLocations) {
                serverNames.add(p.getSecond().toString());
            }
            this.verifier.verifySnapshot(this.workingDir, serverNames);
            this.completeSnapshot(this.snapshotDir, this.workingDir, this.fs);
        }
        catch (Exception e) {
            String reason = "Failed taking snapshot " + SnapshotDescriptionUtils.toString(this.snapshot) + " due to exception:" + e.getMessage();
            LOG.error((Object)reason, (Throwable)e);
            ForeignException ee = new ForeignException(reason, e);
            this.monitor.receive(ee);
            this.cancel("Failed to take snapshot '" + SnapshotDescriptionUtils.toString(this.snapshot) + "' due to exception");
        }
        finally {
            LOG.debug((Object)("Launching cleanup of working dir:" + this.workingDir));
            try {
                if (this.fs.exists(this.workingDir) && !this.fs.delete(this.workingDir, true)) {
                    LOG.error((Object)("Couldn't delete snapshot working directory:" + this.workingDir));
                }
            }
            catch (IOException e) {
                LOG.error((Object)("Couldn't delete snapshot working directory:" + this.workingDir));
            }
        }
    }

    public void completeSnapshot(Path snapshotDir, Path workingDir, FileSystem fs) throws SnapshotCreationException, IOException {
        LOG.debug((Object)("Sentinel is done, just moving the snapshot from " + workingDir + " to " + snapshotDir));
        if (!fs.rename(workingDir, snapshotDir)) {
            throw new SnapshotCreationException("Failed to move working directory(" + workingDir + ") to completed directory(" + snapshotDir + ").");
        }
        this.finished = true;
    }

    protected abstract void snapshotRegions(List<Pair<HRegionInfo, ServerName>> var1) throws IOException, KeeperException;

    @Override
    public void cancel(String why) {
        if (this.finished) {
            return;
        }
        this.finished = true;
        LOG.info((Object)("Stop taking snapshot=" + SnapshotDescriptionUtils.toString(this.snapshot) + " because: " + why));
        CancellationException ce = new CancellationException(why);
        this.monitor.receive(new ForeignException(this.master.getServerName().toString(), ce));
    }

    @Override
    public boolean isFinished() {
        return this.finished;
    }

    @Override
    public HBaseProtos.SnapshotDescription getSnapshot() {
        return this.snapshot;
    }

    @Override
    public ForeignException getExceptionIfFailed() {
        return this.monitor.getException();
    }

    @Override
    public void rethrowException() throws ForeignException {
        this.monitor.rethrowException();
    }

    @Override
    public boolean hasException() {
        return this.monitor.hasException();
    }

    @Override
    public ForeignException getException() {
        return this.monitor.getException();
    }
}

