/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.procedure;

import com.google.protobuf.InvalidProtocolBufferException;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.hbase.errorhandling.ForeignException;
import org.apache.hadoop.hbase.procedure.ProcedureMember;
import org.apache.hadoop.hbase.procedure.ProcedureMemberRpcs;
import org.apache.hadoop.hbase.procedure.Subprocedure;
import org.apache.hadoop.hbase.procedure.ZKProcedureUtil;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.apache.zookeeper.KeeperException;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class ZKProcedureMemberRpcs
implements ProcedureMemberRpcs {
    private static final Log LOG = LogFactory.getLog(ZKProcedureMemberRpcs.class);
    private final String memberName;
    protected ProcedureMember member;
    private ZKProcedureUtil zkController;

    public ZKProcedureMemberRpcs(ZooKeeperWatcher watcher, String procType, String memberName) throws KeeperException {
        this.zkController = new ZKProcedureUtil(watcher, procType, memberName){

            @Override
            public void nodeCreated(String path) {
                if (!this.isInProcedurePath(path)) {
                    return;
                }
                LOG.info((Object)("Received created event:" + path));
                if (this.isAcquiredNode(path)) {
                    ZKProcedureMemberRpcs.this.waitForNewProcedures();
                    return;
                }
                if (this.isAbortNode(path)) {
                    ZKProcedureMemberRpcs.this.watchForAbortedProcedures();
                    return;
                }
                String parent = ZKUtil.getParent(path);
                if (this.isReachedNode(parent)) {
                    ZKProcedureMemberRpcs.this.receivedReachedGlobalBarrier(path);
                    return;
                }
                if (this.isAbortNode(parent)) {
                    ZKProcedureMemberRpcs.this.abort(path);
                    return;
                }
                if (this.isAcquiredNode(parent)) {
                    ZKProcedureMemberRpcs.this.startNewSubprocedure(path);
                } else {
                    LOG.debug((Object)("Ignoring created notification for node:" + path));
                }
            }

            @Override
            public void nodeChildrenChanged(String path) {
                if (path.equals(this.acquiredZnode)) {
                    LOG.info((Object)("Received procedure start children changed event: " + path));
                    ZKProcedureMemberRpcs.this.waitForNewProcedures();
                } else if (path.equals(this.abortZnode)) {
                    LOG.info((Object)("Received procedure abort children changed event: " + path));
                    ZKProcedureMemberRpcs.this.watchForAbortedProcedures();
                }
            }
        };
        this.memberName = memberName;
    }

    public ZKProcedureUtil getZkController() {
        return this.zkController;
    }

    @Override
    public String getMemberName() {
        return this.memberName;
    }

    private void receivedReachedGlobalBarrier(String path) {
        LOG.debug((Object)("Recieved reached global barrier:" + path));
        String procName = ZKUtil.getNodeName(path);
        this.member.receivedReachedGlobalBarrier(procName);
    }

    private void watchForAbortedProcedures() {
        LOG.debug((Object)("Checking for aborted procedures on node: '" + this.zkController.getAbortZnode() + "'"));
        try {
            for (String node : ZKUtil.listChildrenAndWatchForNewChildren(this.zkController.getWatcher(), this.zkController.getAbortZnode())) {
                String abortNode = ZKUtil.joinZNode(this.zkController.getAbortZnode(), node);
                this.abort(abortNode);
            }
        }
        catch (KeeperException e) {
            this.member.controllerConnectionFailure("Failed to list children for abort node:" + this.zkController.getAbortZnode(), new IOException(e));
        }
    }

    private void waitForNewProcedures() {
        LOG.debug((Object)("Looking for new procedures under znode:'" + this.zkController.getAcquiredBarrier() + "'"));
        List<String> runningProcedures = null;
        try {
            runningProcedures = ZKUtil.listChildrenAndWatchForNewChildren(this.zkController.getWatcher(), this.zkController.getAcquiredBarrier());
            if (runningProcedures == null) {
                LOG.debug((Object)"No running procedures.");
                return;
            }
        }
        catch (KeeperException e) {
            this.member.controllerConnectionFailure("General failure when watching for new procedures", new IOException(e));
        }
        if (runningProcedures == null) {
            LOG.debug((Object)"No running procedures.");
            return;
        }
        for (String procName : runningProcedures) {
            String path = ZKUtil.joinZNode(this.zkController.getAcquiredBarrier(), procName);
            this.startNewSubprocedure(path);
        }
    }

    private synchronized void startNewSubprocedure(String path) {
        LOG.debug((Object)("Found procedure znode: " + path));
        String opName = ZKUtil.getNodeName(path);
        String abortZNode = this.zkController.getAbortZNode(opName);
        try {
            if (ZKUtil.watchAndCheckExists(this.zkController.getWatcher(), abortZNode)) {
                LOG.debug((Object)("Not starting:" + opName + " because we already have an abort notification."));
                return;
            }
        }
        catch (KeeperException e) {
            this.member.controllerConnectionFailure("Failed to get the abort znode (" + abortZNode + ") for procedure :" + opName, new IOException(e));
            return;
        }
        Subprocedure subproc = null;
        try {
            byte[] data = ZKUtil.getData(this.zkController.getWatcher(), path);
            LOG.debug((Object)("start proc data length is " + data.length));
            if (!ProtobufUtil.isPBMagicPrefix(data)) {
                String msg = "Data in for starting procuedure " + opName + " is illegally formatted. " + "Killing the procedure.";
                LOG.error((Object)msg);
                throw new IllegalArgumentException(msg);
            }
            data = Arrays.copyOfRange(data, ProtobufUtil.lengthOfPBMagic(), data.length);
            LOG.debug((Object)("Found data for znode:" + path));
            subproc = this.member.createSubprocedure(opName, data);
            this.member.submitSubprocedure(subproc);
        }
        catch (IllegalArgumentException iae) {
            LOG.error((Object)"Illegal argument exception", (Throwable)iae);
            this.sendMemberAborted(subproc, new ForeignException(this.getMemberName(), iae));
        }
        catch (IllegalStateException ise) {
            LOG.error((Object)"Illegal state exception ", (Throwable)ise);
            this.sendMemberAborted(subproc, new ForeignException(this.getMemberName(), ise));
        }
        catch (KeeperException e) {
            this.member.controllerConnectionFailure("Failed to get data for new procedure:" + opName, new IOException(e));
        }
    }

    @Override
    public void sendMemberAcquired(Subprocedure sub) throws IOException {
        String procName = sub.getName();
        try {
            LOG.debug((Object)("Member: '" + this.memberName + "' joining acquired barrier for procedure (" + procName + ") in zk"));
            String acquiredZNode = ZKUtil.joinZNode(ZKProcedureUtil.getAcquireBarrierNode(this.zkController, procName), this.memberName);
            ZKUtil.createAndFailSilent(this.zkController.getWatcher(), acquiredZNode);
            String reachedBarrier = this.zkController.getReachedBarrierNode(procName);
            LOG.debug((Object)("Watch for global barrier reached:" + reachedBarrier));
            if (ZKUtil.watchAndCheckExists(this.zkController.getWatcher(), reachedBarrier)) {
                this.receivedReachedGlobalBarrier(reachedBarrier);
            }
        }
        catch (KeeperException e) {
            this.member.controllerConnectionFailure("Failed to acquire barrier for procedure: " + procName + " and member: " + this.memberName, new IOException(e));
        }
    }

    @Override
    public void sendMemberCompleted(Subprocedure sub) throws IOException {
        String procName = sub.getName();
        LOG.debug((Object)("Marking procedure  '" + procName + "' completed for member '" + this.memberName + "' in zk"));
        String joinPath = ZKUtil.joinZNode(this.zkController.getReachedBarrierNode(procName), this.memberName);
        try {
            ZKUtil.createAndFailSilent(this.zkController.getWatcher(), joinPath);
        }
        catch (KeeperException e) {
            this.member.controllerConnectionFailure("Failed to post zk node:" + joinPath + " to join procedure barrier.", new IOException(e));
        }
    }

    @Override
    public void sendMemberAborted(Subprocedure sub, ForeignException ee) {
        if (sub == null) {
            LOG.error((Object)"Failed due to null subprocedure", (Throwable)ee);
            return;
        }
        String procName = sub.getName();
        LOG.debug((Object)("Aborting procedure (" + procName + ") in zk"));
        String procAbortZNode = this.zkController.getAbortZNode(procName);
        try {
            String source = ee.getSource() == null ? this.memberName : ee.getSource();
            byte[] errorInfo = ProtobufUtil.prependPBMagic(ForeignException.serialize(source, ee));
            ZKUtil.createAndFailSilent(this.zkController.getWatcher(), procAbortZNode, errorInfo);
            LOG.debug((Object)("Finished creating abort znode:" + procAbortZNode));
        }
        catch (KeeperException e) {
            this.zkController.logZKTree(this.zkController.getBaseZnode());
            this.member.controllerConnectionFailure("Failed to post zk node:" + procAbortZNode + " to abort procedure", new IOException(e));
        }
    }

    protected void abort(String abortZNode) {
        LOG.debug((Object)("Aborting procedure member for znode " + abortZNode));
        String opName = ZKUtil.getNodeName(abortZNode);
        try {
            ForeignException ee;
            byte[] data = ZKUtil.getData(this.zkController.getWatcher(), abortZNode);
            try {
                if (!ProtobufUtil.isPBMagicPrefix(data)) {
                    String msg = "Illegally formatted data in abort node for proc " + opName + ".  Killing the procedure.";
                    LOG.error((Object)msg);
                    ee = new ForeignException(this.getMemberName(), new IllegalArgumentException(msg));
                } else {
                    data = Arrays.copyOfRange(data, ProtobufUtil.lengthOfPBMagic(), data.length);
                    ee = ForeignException.deserialize(data);
                }
            }
            catch (InvalidProtocolBufferException e) {
                LOG.warn((Object)("Got an error notification for op:" + opName + " but we can't read the information. Killing the procedure."));
                ee = new ForeignException(this.getMemberName(), e);
            }
            this.member.receiveAbortProcedure(opName, ee);
        }
        catch (KeeperException e) {
            this.member.controllerConnectionFailure("Failed to get data for abort znode:" + abortZNode + this.zkController.getAbortZnode(), new IOException(e));
        }
    }

    @Override
    public void start(ProcedureMember listener) {
        LOG.debug((Object)("Starting procedure member '" + this.memberName + "'"));
        this.member = listener;
        this.watchForAbortedProcedures();
        this.waitForNewProcedures();
    }

    @Override
    public void close() throws IOException {
        this.zkController.close();
    }
}

