/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HDFSBlocksDistribution;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.mapreduce.TableMapReduceUtil;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.Store;
import org.apache.hadoop.hbase.regionserver.StoreFile;
import org.apache.hadoop.hbase.regionserver.compactions.CompactionRequest;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.FSTableDescriptors;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;
import org.apache.hadoop.mapreduce.lib.input.TextInputFormat;
import org.apache.hadoop.mapreduce.lib.output.NullOutputFormat;
import org.apache.hadoop.util.LineReader;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;

@InterfaceAudience.Public
public class CompactionTool
extends Configured
implements Tool {
    private static final Log LOG = LogFactory.getLog(CompactionTool.class);
    private static final String CONF_TMP_DIR = "hbase.tmp.dir";
    private static final String CONF_COMPACT_ONCE = "hbase.compactiontool.compact.once";
    private static final String CONF_DELETE_COMPACTED = "hbase.compactiontool.delete";
    private static final String CONF_COMPLETE_COMPACTION = "hbase.hstore.compaction.complete";

    private static boolean isRegionDir(FileSystem fs, Path path) throws IOException {
        Path regionInfo = new Path(path, ".regioninfo");
        return fs.exists(regionInfo);
    }

    private static boolean isTableDir(FileSystem fs, Path path) throws IOException {
        return FSTableDescriptors.getTableInfoPath(fs, path) != null;
    }

    private static boolean isFamilyDir(FileSystem fs, Path path) throws IOException {
        return CompactionTool.isRegionDir(fs, path.getParent());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int doMapReduce(FileSystem fs, Set<Path> toCompactDirs, boolean compactOnce) throws Exception {
        Configuration conf = this.getConf();
        conf.setBoolean(CONF_COMPACT_ONCE, compactOnce);
        Job job = new Job(conf);
        job.setJobName("CompactionTool");
        job.setJarByClass(CompactionTool.class);
        job.setMapperClass(CompactionMapper.class);
        job.setInputFormatClass(CompactionInputFormat.class);
        job.setOutputFormatClass(NullOutputFormat.class);
        job.setMapSpeculativeExecution(false);
        job.setNumReduceTasks(0);
        String stagingName = "compact-" + EnvironmentEdgeManager.currentTimeMillis();
        Path stagingDir = new Path(conf.get(CONF_TMP_DIR), stagingName);
        fs.mkdirs(stagingDir);
        try {
            Path inputPath = new Path(stagingDir, stagingName);
            CompactionInputFormat.createInputFile(fs, inputPath, toCompactDirs);
            CompactionInputFormat.addInputPath((Job)job, (Path)inputPath);
            TableMapReduceUtil.initCredentials(job);
            int n = job.waitForCompletion(true) ? 0 : 1;
            return n;
        }
        finally {
            fs.delete(stagingDir, true);
        }
    }

    private int doClient(FileSystem fs, Set<Path> toCompactDirs, boolean compactOnce) throws IOException {
        CompactionWorker worker = new CompactionWorker(fs, this.getConf());
        for (Path path : toCompactDirs) {
            worker.compact(path, compactOnce);
        }
        return 0;
    }

    public int run(String[] args) throws Exception {
        HashSet<Path> toCompactDirs = new HashSet<Path>();
        boolean compactOnce = false;
        boolean mapred = false;
        Configuration conf = this.getConf();
        FileSystem fs = FileSystem.get((Configuration)conf);
        try {
            for (int i = 0; i < args.length; ++i) {
                String opt = args[i];
                if (opt.equals("-compactOnce")) {
                    compactOnce = true;
                    continue;
                }
                if (opt.equals("-mapred")) {
                    mapred = true;
                    continue;
                }
                if (!opt.startsWith("-")) {
                    Path path = new Path(opt);
                    FileStatus status = fs.getFileStatus(path);
                    if (!status.isDir()) {
                        this.printUsage("Specified path is not a directory. path=" + path);
                        return 1;
                    }
                    toCompactDirs.add(path);
                    continue;
                }
                this.printUsage();
            }
        }
        catch (Exception e) {
            this.printUsage(e.getMessage());
            return 1;
        }
        if (toCompactDirs.size() == 0) {
            this.printUsage("No directories to compact specified.");
            return 1;
        }
        if (mapred) {
            return this.doMapReduce(fs, toCompactDirs, compactOnce);
        }
        return this.doClient(fs, toCompactDirs, compactOnce);
    }

    private void printUsage() {
        this.printUsage(null);
    }

    private void printUsage(String message) {
        if (message != null && message.length() > 0) {
            System.err.println(message);
        }
        System.err.println("Usage: java " + ((Object)((Object)this)).getClass().getName() + " \\");
        System.err.println("  [-compactOnce] [-mapred] [-D<property=value>]* files...");
        System.err.println();
        System.err.println("Options:");
        System.err.println(" mapred         Use MapReduce to run compaction.");
        System.err.println(" compactOnce    Execute just one compaction step. (default: while needed)");
        System.err.println();
        System.err.println("Note: -D properties will be applied to the conf used. ");
        System.err.println("For example: ");
        System.err.println(" To preserve input files, pass -Dhbase.hstore.compaction.complete=false");
        System.err.println(" To stop delete of compacted file, pass -Dhbase.compactiontool.delete=false");
        System.err.println(" To set tmp dir, pass -Dhbase.tmp.dir=ALTERNATE_DIR");
        System.err.println();
        System.err.println("Examples:");
        System.err.println(" To compact the full 'TestTable' using MapReduce:");
        System.err.println(" $ bin/hbase " + ((Object)((Object)this)).getClass().getName() + " -mapred hdfs:///hbase/TestTable");
        System.err.println();
        System.err.println(" To compact column family 'x' of the table 'TestTable' region 'abc':");
        System.err.println(" $ bin/hbase " + ((Object)((Object)this)).getClass().getName() + " hdfs:///hbase/TestTable/abc/x");
    }

    public static void main(String[] args) throws Exception {
        System.exit(ToolRunner.run((Configuration)HBaseConfiguration.create(), (Tool)new CompactionTool(), (String[])args));
    }

    private static class CompactionInputFormat
    extends TextInputFormat {
        private CompactionInputFormat() {
        }

        protected boolean isSplitable(JobContext context, Path file) {
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public List<InputSplit> getSplits(JobContext job) throws IOException {
            ArrayList<InputSplit> splits = new ArrayList<InputSplit>();
            List files = this.listStatus(job);
            Text key = new Text();
            for (FileStatus file : files) {
                Path path = file.getPath();
                FileSystem fs = path.getFileSystem(job.getConfiguration());
                LineReader reader = new LineReader((InputStream)fs.open(path));
                long pos = 0L;
                try {
                    int n;
                    while ((n = reader.readLine(key)) > 0) {
                        String[] hosts = CompactionInputFormat.getStoreDirHosts(fs, path);
                        splits.add((InputSplit)new FileSplit(path, pos, (long)n, hosts));
                        pos += (long)n;
                    }
                }
                finally {
                    reader.close();
                }
            }
            return splits;
        }

        private static String[] getStoreDirHosts(FileSystem fs, Path path) throws IOException {
            FileStatus[] files = FSUtils.listStatus(fs, path, null);
            if (files == null) {
                return new String[0];
            }
            HDFSBlocksDistribution hdfsBlocksDistribution = new HDFSBlocksDistribution();
            for (FileStatus hfileStatus : files) {
                HDFSBlocksDistribution storeFileBlocksDistribution = FSUtils.computeHDFSBlocksDistribution(fs, hfileStatus, 0L, hfileStatus.getLen());
                hdfsBlocksDistribution.add(storeFileBlocksDistribution);
            }
            List<String> hosts = hdfsBlocksDistribution.getTopHosts();
            return hosts.toArray(new String[hosts.size()]);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static void createInputFile(FileSystem fs, Path path, Set<Path> toCompactDirs) throws IOException {
            LinkedList<Path> storeDirs = new LinkedList<Path>();
            for (Path compactDir : toCompactDirs) {
                if (CompactionTool.isFamilyDir(fs, compactDir)) {
                    storeDirs.add(compactDir);
                    continue;
                }
                if (CompactionTool.isRegionDir(fs, compactDir)) {
                    for (Path familyDir : FSUtils.getFamilyDirs(fs, compactDir)) {
                        storeDirs.add(familyDir);
                    }
                    continue;
                }
                if (CompactionTool.isTableDir(fs, compactDir)) {
                    for (Path regionDir : FSUtils.getRegionDirs(fs, compactDir)) {
                        for (Path familyDir : FSUtils.getFamilyDirs(fs, regionDir)) {
                            storeDirs.add(familyDir);
                        }
                    }
                    continue;
                }
                throw new IOException("Specified path is not a table, region or family directory. path=" + compactDir);
            }
            FSDataOutputStream stream = fs.create(path);
            LOG.info((Object)("Create input file=" + path + " with " + storeDirs.size() + " dirs to compact."));
            try {
                byte[] newLine = Bytes.toBytes("\n");
                for (Path storeDir : storeDirs) {
                    stream.write(Bytes.toBytes(storeDir.toString()));
                    stream.write(newLine);
                }
            }
            finally {
                stream.close();
            }
        }
    }

    private static class CompactionMapper
    extends Mapper<LongWritable, Text, NullWritable, NullWritable> {
        private CompactionWorker compactor = null;
        private boolean compactOnce = false;

        private CompactionMapper() {
        }

        public void setup(Mapper.Context context) {
            Configuration conf = context.getConfiguration();
            this.compactOnce = conf.getBoolean(CompactionTool.CONF_COMPACT_ONCE, false);
            try {
                FileSystem fs = FileSystem.get((Configuration)conf);
                this.compactor = new CompactionWorker(fs, conf);
            }
            catch (IOException e) {
                throw new RuntimeException("Could not get the input FileSystem", e);
            }
        }

        public void map(LongWritable key, Text value, Mapper.Context context) throws InterruptedException, IOException {
            Path path = new Path(value.toString());
            this.compactor.compact(path, this.compactOnce);
        }
    }

    private static class CompactionWorker {
        private final boolean keepCompactedFiles;
        private final boolean deleteCompacted;
        private final Configuration conf;
        private final FileSystem fs;
        private final Path tmpDir;

        public CompactionWorker(FileSystem fs, Configuration conf) {
            this.conf = conf;
            this.keepCompactedFiles = !conf.getBoolean(CompactionTool.CONF_COMPLETE_COMPACTION, true);
            this.deleteCompacted = conf.getBoolean(CompactionTool.CONF_DELETE_COMPACTED, false);
            this.tmpDir = new Path(conf.get(CompactionTool.CONF_TMP_DIR));
            this.fs = fs;
        }

        public void compact(Path path, boolean compactOnce) throws IOException {
            if (CompactionTool.isFamilyDir(this.fs, path)) {
                Path regionDir = path.getParent();
                Path tableDir = regionDir.getParent();
                HTableDescriptor htd = FSTableDescriptors.getTableDescriptor(this.fs, tableDir);
                HRegion region = CompactionWorker.loadRegion(this.fs, this.conf, htd, regionDir);
                this.compactStoreFiles(region, path, compactOnce);
            } else if (CompactionTool.isRegionDir(this.fs, path)) {
                Path tableDir = path.getParent();
                HTableDescriptor htd = FSTableDescriptors.getTableDescriptor(this.fs, tableDir);
                this.compactRegion(htd, path, compactOnce);
            } else if (CompactionTool.isTableDir(this.fs, path)) {
                this.compactTable(path, compactOnce);
            } else {
                throw new IOException("Specified path is not a table, region or family directory. path=" + path);
            }
        }

        private void compactTable(Path tableDir, boolean compactOnce) throws IOException {
            HTableDescriptor htd = FSTableDescriptors.getTableDescriptor(this.fs, tableDir);
            LOG.info((Object)("Compact table=" + htd.getNameAsString()));
            for (Path regionDir : FSUtils.getRegionDirs(this.fs, tableDir)) {
                this.compactRegion(htd, regionDir, compactOnce);
            }
        }

        private void compactRegion(HTableDescriptor htd, Path regionDir, boolean compactOnce) throws IOException {
            HRegion region = CompactionWorker.loadRegion(this.fs, this.conf, htd, regionDir);
            LOG.info((Object)("Compact table=" + htd.getNameAsString() + " region=" + region.getRegionNameAsString()));
            for (Path familyDir : FSUtils.getFamilyDirs(this.fs, regionDir)) {
                this.compactStoreFiles(region, familyDir, compactOnce);
            }
        }

        private void compactStoreFiles(HRegion region, Path familyDir, boolean compactOnce) throws IOException {
            LOG.info((Object)("Compact table=" + region.getTableDesc().getNameAsString() + " region=" + region.getRegionNameAsString() + " family=" + familyDir.getName()));
            Store store = this.getStore(region, familyDir);
            do {
                CompactionRequest cr;
                StoreFile storeFile;
                if ((storeFile = store.compact(cr = store.requestCompaction())) == null || !this.keepCompactedFiles || !this.deleteCompacted) continue;
                this.fs.delete(storeFile.getPath(), false);
            } while (store.needsCompaction() && !compactOnce);
        }

        private Store getStore(HRegion region, final Path storeDir) throws IOException {
            byte[] familyName = Bytes.toBytes(storeDir.getName());
            HColumnDescriptor hcd = region.getTableDesc().getFamily(familyName);
            return new Store(this.tmpDir, region, hcd, this.fs, this.conf){

                @Override
                public FileStatus[] getStoreFiles() throws IOException {
                    return this.fs.listStatus(this.getHomedir());
                }

                @Override
                Path createStoreHomeDir(FileSystem fs, Path homedir) throws IOException {
                    return storeDir;
                }
            };
        }

        private static HRegion loadRegion(FileSystem fs, Configuration conf, HTableDescriptor htd, Path regionDir) throws IOException {
            Path rootDir = regionDir.getParent().getParent();
            HRegionInfo hri = HRegion.loadDotRegionInfoFileContent(fs, regionDir);
            return HRegion.createHRegion(hri, rootDir, conf, htd, null, false, true);
        }
    }
}

