/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.regionserver.ConstantSizeRegionSplitPolicy;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.RegionServerServices;
import org.apache.hadoop.hbase.regionserver.Store;
import org.apache.hadoop.hbase.util.Bytes;

public class IncreasingToUpperBoundRegionSplitPolicy
extends ConstantSizeRegionSplitPolicy {
    static final Log LOG = LogFactory.getLog(IncreasingToUpperBoundRegionSplitPolicy.class);
    private long flushSize;

    @Override
    protected void configureForRegion(HRegion region) {
        super.configureForRegion(region);
        Configuration conf = this.getConf();
        HTableDescriptor desc = region.getTableDesc();
        if (desc != null) {
            this.flushSize = desc.getMemStoreFlushSize();
        }
        if (this.flushSize <= 0L) {
            this.flushSize = conf.getLong("hbase.hregion.memstore.flush.size", 0x8000000L);
        }
    }

    @Override
    protected boolean shouldSplit() {
        if (this.region.shouldForceSplit()) {
            return true;
        }
        boolean foundABigStore = false;
        int tableRegionsCount = this.getCountOfCommonTableRegions();
        long sizeToCheck = this.getSizeToCheck(tableRegionsCount);
        for (Store store : this.region.getStores().values()) {
            if (!store.canSplit()) {
                return false;
            }
            long size = store.getSize();
            if (size <= sizeToCheck) continue;
            LOG.debug((Object)("ShouldSplit because " + store.getColumnFamilyName() + " size=" + size + ", sizeToCheck=" + sizeToCheck + ", regionsWithCommonTable=" + tableRegionsCount));
            foundABigStore = true;
            break;
        }
        return foundABigStore;
    }

    long getSizeToCheck(int tableRegionsCount) {
        return tableRegionsCount == 0 ? this.getDesiredMaxFileSize() : Math.min(this.getDesiredMaxFileSize(), this.flushSize * (long)(tableRegionsCount * tableRegionsCount));
    }

    private int getCountOfCommonTableRegions() {
        RegionServerServices rss = this.region.getRegionServerServices();
        if (rss == null) {
            return 0;
        }
        byte[] tablename = this.region.getTableDesc().getName();
        int tableRegionsCount = 0;
        try {
            List<HRegion> hri = rss.getOnlineRegions(tablename);
            tableRegionsCount = hri == null || hri.isEmpty() ? 0 : hri.size();
        }
        catch (IOException e) {
            LOG.debug((Object)("Failed getOnlineRegions " + Bytes.toString(tablename)), (Throwable)e);
        }
        return tableRegionsCount;
    }
}

