/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Ordering;
import java.io.DataInput;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.SortedSet;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HDFSBlocksDistribution;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.fs.HFileSystem;
import org.apache.hadoop.hbase.io.HFileLink;
import org.apache.hadoop.hbase.io.HalfStoreFileReader;
import org.apache.hadoop.hbase.io.Reference;
import org.apache.hadoop.hbase.io.encoding.DataBlockEncoding;
import org.apache.hadoop.hbase.io.hfile.BlockType;
import org.apache.hadoop.hbase.io.hfile.CacheConfig;
import org.apache.hadoop.hbase.io.hfile.Compression;
import org.apache.hadoop.hbase.io.hfile.HFile;
import org.apache.hadoop.hbase.io.hfile.HFileDataBlockEncoder;
import org.apache.hadoop.hbase.io.hfile.HFileScanner;
import org.apache.hadoop.hbase.io.hfile.HFileWriterV2;
import org.apache.hadoop.hbase.io.hfile.NoOpDataBlockEncoder;
import org.apache.hadoop.hbase.regionserver.StoreFileScanner;
import org.apache.hadoop.hbase.regionserver.TimeRangeTracker;
import org.apache.hadoop.hbase.regionserver.metrics.SchemaConfigured;
import org.apache.hadoop.hbase.regionserver.metrics.SchemaMetrics;
import org.apache.hadoop.hbase.util.BloomFilter;
import org.apache.hadoop.hbase.util.BloomFilterFactory;
import org.apache.hadoop.hbase.util.BloomFilterWriter;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.ChecksumType;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.hbase.util.Writables;
import org.apache.hadoop.io.RawComparator;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableUtils;

public class StoreFile
extends SchemaConfigured {
    static final Log LOG = LogFactory.getLog((String)StoreFile.class.getName());
    public static final byte[] MAX_SEQ_ID_KEY = Bytes.toBytes("MAX_SEQ_ID_KEY");
    public static final byte[] MAJOR_COMPACTION_KEY = Bytes.toBytes("MAJOR_COMPACTION_KEY");
    public static final byte[] EXCLUDE_FROM_MINOR_COMPACTION_KEY = Bytes.toBytes("EXCLUDE_FROM_MINOR_COMPACTION");
    static final byte[] BLOOM_FILTER_TYPE_KEY = Bytes.toBytes("BLOOM_FILTER_TYPE");
    public static final byte[] DELETE_FAMILY_COUNT = Bytes.toBytes("DELETE_FAMILY_COUNT");
    private static final byte[] LAST_BLOOM_KEY = Bytes.toBytes("LAST_BLOOM_KEY");
    public static final byte[] TIMERANGE_KEY = Bytes.toBytes("TIMERANGE");
    public static final byte[] EARLIEST_PUT_TS = Bytes.toBytes("EARLIEST_PUT_TS");
    public static final int DEFAULT_BLOCKSIZE_SMALL = 8192;
    private final FileSystem fs;
    private final Path path;
    private Reference reference;
    private Path referencePath;
    private HFileLink link;
    private final CacheConfig cacheConf;
    private final HFileDataBlockEncoder dataBlockEncoder;
    private HDFSBlocksDistribution hdfsBlocksDistribution;
    private long sequenceid = -1L;
    private long maxMemstoreTS = -1L;
    private AtomicBoolean majorCompaction = null;
    private boolean excludeFromMinorCompaction = false;
    public static final byte[] BULKLOAD_TASK_KEY = Bytes.toBytes("BULKLOAD_SOURCE_TASK");
    public static final byte[] BULKLOAD_TIME_KEY = Bytes.toBytes("BULKLOAD_TIMESTAMP");
    private Map<byte[], byte[]> metadataMap;
    public static final String HFILE_NAME_REGEX = "[0-9a-f]+(?:_SeqId_[0-9]+_)?";
    private static final Pattern HFILE_NAME_PATTERN = Pattern.compile("^([0-9a-f]+(?:_SeqId_[0-9]+_)?)");
    private static final Pattern REF_NAME_PATTERN = Pattern.compile(String.format("^(%s|%s)\\.(.+)$", "[0-9a-f]+(?:_SeqId_[0-9]+_)?", HFileLink.LINK_NAME_REGEX));
    private volatile Reader reader;
    private final BloomType cfBloomType;
    private long modificationTimeStamp = 0L;

    public long getMaxMemstoreTS() {
        return this.maxMemstoreTS;
    }

    public void setMaxMemstoreTS(long maxMemstoreTS) {
        this.maxMemstoreTS = maxMemstoreTS;
    }

    public StoreFile(FileSystem fs, Path p, Configuration conf, CacheConfig cacheConf, BloomType cfBloomType, HFileDataBlockEncoder dataBlockEncoder) throws IOException {
        this.fs = fs;
        this.path = p;
        this.cacheConf = cacheConf;
        HFileDataBlockEncoder hFileDataBlockEncoder = this.dataBlockEncoder = dataBlockEncoder == null ? NoOpDataBlockEncoder.INSTANCE : dataBlockEncoder;
        if (HFileLink.isHFileLink(p)) {
            this.link = new HFileLink(conf, p);
            LOG.debug((Object)("Store file " + p + " is a link"));
        } else if (StoreFile.isReference(p)) {
            this.reference = Reference.read(fs, p);
            this.referencePath = StoreFile.getReferredToFile(this.path);
            if (HFileLink.isHFileLink(this.referencePath)) {
                this.link = new HFileLink(conf, this.referencePath);
            }
            LOG.debug((Object)("Store file " + p + " is a " + (Object)((Object)this.reference.getFileRegion()) + " reference to " + this.referencePath));
        } else if (!StoreFile.isHFile(p)) {
            throw new IOException("path=" + this.path + " doesn't look like a valid StoreFile");
        }
        if (BloomFilterFactory.isGeneralBloomEnabled(conf)) {
            this.cfBloomType = cfBloomType;
        } else {
            LOG.info((Object)("Ignoring bloom filter check for file " + this.path + ": " + "cfBloomType=" + (Object)((Object)cfBloomType) + " (disabled in config)"));
            this.cfBloomType = BloomType.NONE;
        }
        FileStatus[] stats = FSUtils.listStatus(fs, p, null);
        this.modificationTimeStamp = stats != null && stats.length == 1 ? stats[0].getModificationTime() : 0L;
        SchemaMetrics.configureGlobally(conf);
    }

    public Path getPath() {
        return this.path;
    }

    byte[] getFamily() {
        return Bytes.toBytes(this.path.getParent().getName());
    }

    boolean isReference() {
        return this.reference != null;
    }

    boolean isLink() {
        return this.link != null && this.reference == null;
    }

    private static boolean isHFile(Path path) {
        Matcher m = HFILE_NAME_PATTERN.matcher(path.getName());
        return m.matches() && m.groupCount() > 0;
    }

    public static boolean isReference(Path p) {
        return StoreFile.isReference(p.getName());
    }

    public static boolean isReference(String name) {
        Matcher m = REF_NAME_PATTERN.matcher(name);
        return m.matches() && m.groupCount() > 1;
    }

    public static Path getReferredToFile(Path p) {
        Matcher m = REF_NAME_PATTERN.matcher(p.getName());
        if (m == null || !m.matches()) {
            LOG.warn((Object)("Failed match of store file name " + p.toString()));
            throw new IllegalArgumentException("Failed match of store file name " + p.toString());
        }
        String otherRegion = m.group(2);
        Path tableDir = p.getParent().getParent().getParent();
        String nameStrippedOfSuffix = m.group(1);
        LOG.debug((Object)("reference '" + p + "' to region=" + otherRegion + " hfile=" + nameStrippedOfSuffix));
        return new Path(new Path(new Path(tableDir, otherRegion), p.getParent().getName()), nameStrippedOfSuffix);
    }

    boolean isMajorCompaction() {
        if (this.majorCompaction == null) {
            throw new NullPointerException("This has not been set yet");
        }
        return this.majorCompaction.get();
    }

    boolean excludeFromMinorCompaction() {
        return this.excludeFromMinorCompaction;
    }

    public long getMaxSequenceId() {
        return this.sequenceid;
    }

    public long getModificationTimeStamp() {
        return this.modificationTimeStamp;
    }

    public static long getMaxMemstoreTSInList(Collection<StoreFile> sfs) {
        long max = 0L;
        for (StoreFile sf : sfs) {
            if (sf.isBulkLoadResult()) continue;
            max = Math.max(max, sf.getMaxMemstoreTS());
        }
        return max;
    }

    public static long getMaxSequenceIdInList(Collection<StoreFile> sfs) {
        long max = 0L;
        for (StoreFile sf : sfs) {
            if (sf.isBulkLoadResult()) continue;
            max = Math.max(max, sf.getMaxSequenceId());
        }
        return max;
    }

    boolean isBulkLoadResult() {
        return this.metadataMap.containsKey(BULKLOAD_TIME_KEY);
    }

    public long getBulkLoadTimestamp() {
        return Bytes.toLong(this.metadataMap.get(BULKLOAD_TIME_KEY));
    }

    public HDFSBlocksDistribution getHDFSBlockDistribution() {
        return this.hdfsBlocksDistribution;
    }

    private static HDFSBlocksDistribution computeRefFileHDFSBlockDistribution(FileSystem fs, Reference reference, FileStatus status) throws IOException {
        if (status == null) {
            return null;
        }
        long start = 0L;
        long length = 0L;
        if (Reference.isTopFileRegion(reference.getFileRegion())) {
            start = status.getLen() / 2L;
            length = status.getLen() - status.getLen() / 2L;
        } else {
            start = 0L;
            length = status.getLen() / 2L;
        }
        return FSUtils.computeHDFSBlocksDistribution(fs, status, start, length);
    }

    private void computeHDFSBlockDistribution() throws IOException {
        if (this.isReference()) {
            FileStatus status = this.link != null ? this.link.getFileStatus(this.fs) : this.fs.getFileStatus(this.referencePath);
            this.hdfsBlocksDistribution = StoreFile.computeRefFileHDFSBlockDistribution(this.fs, this.reference, status);
        } else {
            FileStatus status = this.isLink() ? this.link.getFileStatus(this.fs) : this.fs.getFileStatus(this.path);
            long length = status.getLen();
            this.hdfsBlocksDistribution = FSUtils.computeHDFSBlocksDistribution(this.fs, status, 0L, length);
        }
    }

    private Reader open() throws IOException {
        if (this.reader != null) {
            throw new IllegalAccessError("Already open");
        }
        if (this.isReference()) {
            this.reader = this.link != null ? new HalfStoreFileReader(this.fs, this.referencePath, this.link, this.cacheConf, this.reference, this.dataBlockEncoder.getEncodingInCache()) : new HalfStoreFileReader(this.fs, this.referencePath, this.cacheConf, this.reference, this.dataBlockEncoder.getEncodingInCache());
        } else if (this.isLink()) {
            long size = this.link.getFileStatus(this.fs).getLen();
            this.reader = new Reader(this.fs, this.path, this.link, size, this.cacheConf, this.dataBlockEncoder.getEncodingInCache(), true);
        } else {
            this.reader = new Reader(this.fs, this.path, this.cacheConf, this.dataBlockEncoder.getEncodingInCache());
        }
        if (this.isSchemaConfigured()) {
            SchemaConfigured.resetSchemaMetricsConf(this.reader);
            this.passSchemaMetricsTo(this.reader);
        }
        this.computeHDFSBlockDistribution();
        this.metadataMap = Collections.unmodifiableMap(this.reader.loadFileInfo());
        byte[] b = this.metadataMap.get(MAX_SEQ_ID_KEY);
        if (b != null) {
            this.sequenceid = Bytes.toLong(b);
            if (this.isReference() && Reference.isTopFileRegion(this.reference.getFileRegion())) {
                ++this.sequenceid;
            }
        }
        this.reader.setSequenceID(this.sequenceid);
        b = this.metadataMap.get(HFileWriterV2.MAX_MEMSTORE_TS_KEY);
        if (b != null) {
            this.maxMemstoreTS = Bytes.toLong(b);
        }
        if ((b = this.metadataMap.get(MAJOR_COMPACTION_KEY)) != null) {
            boolean mc = Bytes.toBoolean(b);
            if (this.majorCompaction == null) {
                this.majorCompaction = new AtomicBoolean(mc);
            } else {
                this.majorCompaction.set(mc);
            }
        } else {
            this.majorCompaction = new AtomicBoolean(false);
        }
        b = this.metadataMap.get(EXCLUDE_FROM_MINOR_COMPACTION_KEY);
        this.excludeFromMinorCompaction = b != null && Bytes.toBoolean(b);
        BloomType hfileBloomType = this.reader.getBloomFilterType();
        if (this.cfBloomType != BloomType.NONE) {
            this.reader.loadBloomfilter(BlockType.GENERAL_BLOOM_META);
            if (hfileBloomType != this.cfBloomType) {
                LOG.info((Object)("HFile Bloom filter type for " + this.reader.getHFileReader().getName() + ": " + (Object)((Object)hfileBloomType) + ", but " + (Object)((Object)this.cfBloomType) + " specified in column family " + "configuration"));
            }
        } else if (hfileBloomType != BloomType.NONE) {
            LOG.info((Object)("Bloom filter turned off by CF config for " + this.reader.getHFileReader().getName()));
        }
        this.reader.loadBloomfilter(BlockType.DELETE_FAMILY_BLOOM_META);
        try {
            byte[] timerangeBytes = this.metadataMap.get(TIMERANGE_KEY);
            if (timerangeBytes != null) {
                this.reader.timeRangeTracker = new TimeRangeTracker();
                Writables.copyWritable(timerangeBytes, (Writable)this.reader.timeRangeTracker);
            }
        }
        catch (IllegalArgumentException e) {
            LOG.error((Object)"Error reading timestamp range data from meta -- proceeding without", (Throwable)e);
            this.reader.timeRangeTracker = null;
        }
        return this.reader;
    }

    public Reader createReader() throws IOException {
        if (this.reader == null) {
            try {
                this.reader = this.open();
            }
            catch (IOException e) {
                try {
                    this.closeReader(true);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw e;
            }
        }
        return this.reader;
    }

    public Reader getReader() {
        return this.reader;
    }

    public synchronized void closeReader(boolean evictOnClose) throws IOException {
        if (this.reader != null) {
            this.reader.close(evictOnClose);
            this.reader = null;
        }
    }

    public void deleteReader() throws IOException {
        this.closeReader(true);
        this.fs.delete(this.getPath(), true);
    }

    public String toString() {
        return this.path.toString() + (this.isReference() ? "-" + this.referencePath + "-" + this.reference.toString() : "");
    }

    public String toStringDetailed() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.path.toString());
        sb.append(", isReference=").append(this.isReference());
        sb.append(", isBulkLoadResult=").append(this.isBulkLoadResult());
        if (this.isBulkLoadResult()) {
            sb.append(", bulkLoadTS=").append(this.getBulkLoadTimestamp());
        } else {
            sb.append(", seqid=").append(this.getMaxSequenceId());
        }
        sb.append(", majorCompaction=").append(this.isMajorCompaction());
        return sb.toString();
    }

    public static Path rename(FileSystem fs, Path src, Path tgt) throws IOException {
        if (!fs.exists(src)) {
            throw new FileNotFoundException(src.toString());
        }
        if (!fs.rename(src, tgt)) {
            throw new IOException("Failed rename of " + src + " to " + tgt);
        }
        return tgt;
    }

    public static Path getUniqueFile(FileSystem fs, Path dir) throws IOException {
        if (!fs.getFileStatus(dir).isDir()) {
            throw new IOException("Expecting " + dir.toString() + " to be a directory");
        }
        return StoreFile.getRandomFilename(fs, dir);
    }

    static Path getRandomFilename(FileSystem fs, Path dir) throws IOException {
        return StoreFile.getRandomFilename(fs, dir, null);
    }

    static Path getRandomFilename(FileSystem fs, Path dir, String suffix) throws IOException {
        return new Path(dir, UUID.randomUUID().toString().replaceAll("-", "") + (suffix == null ? "" : suffix));
    }

    public static boolean validateStoreFileName(String fileName) {
        if (HFileLink.isHFileLink(fileName)) {
            return true;
        }
        if (StoreFile.isReference(fileName)) {
            return true;
        }
        return !fileName.contains("-");
    }

    static Path split(FileSystem fs, Path splitDir, StoreFile f, byte[] splitRow, Reference.Range range) throws IOException {
        Reference r = new Reference(splitRow, range);
        String parentRegionName = f.getPath().getParent().getParent().getName();
        Path p = new Path(splitDir, f.getPath().getName() + "." + parentRegionName);
        return r.write(fs, p);
    }

    static abstract class Comparators {
        static final Comparator<StoreFile> FLUSH_TIME = Ordering.compound((Iterable)ImmutableList.of((Object)Ordering.natural().onResultOf((Function)new GetBulkTime()), (Object)Ordering.natural().onResultOf((Function)new GetSeqId()), (Object)Ordering.natural().onResultOf((Function)new GetPathName())));
        static final Comparator<StoreFile> FILE_SIZE = Ordering.natural().reverse().onResultOf((Function)new Function<StoreFile, Long>(){

            public Long apply(StoreFile sf) {
                return sf.getReader().length();
            }
        });

        Comparators() {
        }

        private static class GetPathName
        implements Function<StoreFile, String> {
            private GetPathName() {
            }

            public String apply(StoreFile sf) {
                return sf.getPath().getName();
            }
        }

        private static class GetSeqId
        implements Function<StoreFile, Long> {
            private GetSeqId() {
            }

            public Long apply(StoreFile sf) {
                if (sf.isBulkLoadResult()) {
                    return -1L;
                }
                return sf.getMaxSequenceId();
            }
        }

        private static class GetBulkTime
        implements Function<StoreFile, Long> {
            private GetBulkTime() {
            }

            public Long apply(StoreFile sf) {
                if (!sf.isBulkLoadResult()) {
                    return Long.MAX_VALUE;
                }
                return sf.getBulkLoadTimestamp();
            }
        }
    }

    public static class Reader
    extends SchemaConfigured {
        static final Log LOG = LogFactory.getLog((String)Reader.class.getName());
        protected BloomFilter generalBloomFilter = null;
        protected BloomFilter deleteFamilyBloomFilter = null;
        protected BloomType bloomFilterType;
        private final HFile.Reader reader;
        protected TimeRangeTracker timeRangeTracker = null;
        protected long sequenceID = -1L;
        private byte[] lastBloomKey;
        private long deleteFamilyCnt = -1L;

        public Reader(FileSystem fs, Path path, CacheConfig cacheConf, DataBlockEncoding preferredEncodingInCache) throws IOException {
            super(path);
            this.reader = HFile.createReaderWithEncoding(fs, path, cacheConf, preferredEncodingInCache);
            this.bloomFilterType = BloomType.NONE;
        }

        public Reader(FileSystem fs, Path path, HFileLink hfileLink, long size, CacheConfig cacheConf, DataBlockEncoding preferredEncodingInCache, boolean closeIStream) throws IOException {
            super(path);
            FSDataInputStream in;
            FSDataInputStream inNoChecksum = in = hfileLink.open(fs);
            if (fs instanceof HFileSystem) {
                FileSystem noChecksumFs = ((HFileSystem)fs).getNoChecksumFs();
                inNoChecksum = hfileLink.open(noChecksumFs);
            }
            this.reader = HFile.createReaderWithEncoding(fs, path, in, inNoChecksum, size, cacheConf, preferredEncodingInCache, closeIStream);
            this.bloomFilterType = BloomType.NONE;
        }

        Reader() {
            this.reader = null;
        }

        public RawComparator<byte[]> getComparator() {
            return this.reader.getComparator();
        }

        public StoreFileScanner getStoreFileScanner(boolean cacheBlocks, boolean pread) {
            return this.getStoreFileScanner(cacheBlocks, pread, false);
        }

        public StoreFileScanner getStoreFileScanner(boolean cacheBlocks, boolean pread, boolean isCompaction) {
            return new StoreFileScanner(this, this.getScanner(cacheBlocks, pread, isCompaction), !isCompaction);
        }

        @Deprecated
        public HFileScanner getScanner(boolean cacheBlocks, boolean pread) {
            return this.getScanner(cacheBlocks, pread, false);
        }

        @Deprecated
        public HFileScanner getScanner(boolean cacheBlocks, boolean pread, boolean isCompaction) {
            return this.reader.getScanner(cacheBlocks, pread, isCompaction);
        }

        public void close(boolean evictOnClose) throws IOException {
            this.reader.close(evictOnClose);
        }

        boolean passesTimerangeFilter(Scan scan, long oldestUnexpiredTS) {
            if (this.timeRangeTracker == null) {
                return true;
            }
            return this.timeRangeTracker.includesTimeRange(scan.getTimeRange()) && this.timeRangeTracker.getMaximumTimestamp() >= oldestUnexpiredTS;
        }

        boolean passesBloomFilter(Scan scan, SortedSet<byte[]> columns) {
            if (!scan.isGetScan()) {
                return true;
            }
            byte[] row = scan.getStartRow();
            switch (this.bloomFilterType) {
                case ROW: {
                    return this.passesGeneralBloomFilter(row, 0, row.length, null, 0, 0);
                }
                case ROWCOL: {
                    if (columns != null && columns.size() == 1) {
                        byte[] column = columns.first();
                        return this.passesGeneralBloomFilter(row, 0, row.length, column, 0, column.length);
                    }
                    return true;
                }
            }
            return true;
        }

        public boolean passesDeleteFamilyBloomFilter(byte[] row, int rowOffset, int rowLen) {
            BloomFilter bloomFilter = this.deleteFamilyBloomFilter;
            if (this.reader.getTrailer().getEntryCount() == 0L || this.deleteFamilyCnt == 0L) {
                return false;
            }
            if (bloomFilter == null) {
                return true;
            }
            try {
                if (!bloomFilter.supportsAutoLoading()) {
                    return true;
                }
                return bloomFilter.contains(row, rowOffset, rowLen, null);
            }
            catch (IllegalArgumentException e) {
                LOG.error((Object)"Bad Delete Family bloom filter data -- proceeding without", (Throwable)e);
                this.setDeleteFamilyBloomFilterFaulty();
                return true;
            }
        }

        public boolean passesGeneralBloomFilter(byte[] row, int rowOffset, int rowLen, byte[] col, int colOffset, int colLen) {
            byte[] key;
            if (this.generalBloomFilter == null) {
                return true;
            }
            switch (this.bloomFilterType) {
                case ROW: {
                    if (col != null) {
                        throw new RuntimeException("Row-only Bloom filter called with column specified");
                    }
                    if (rowOffset != 0 || rowLen != row.length) {
                        throw new AssertionError((Object)"For row-only Bloom filters the row must occupy the whole array");
                    }
                    key = row;
                    break;
                }
                case ROWCOL: {
                    key = this.generalBloomFilter.createBloomKey(row, rowOffset, rowLen, col, colOffset, colLen);
                    break;
                }
                default: {
                    return true;
                }
            }
            BloomFilter bloomFilter = this.generalBloomFilter;
            if (bloomFilter == null) {
                return true;
            }
            if (this.reader.getTrailer().getEntryCount() == 0L) {
                return false;
            }
            try {
                boolean shouldCheckBloom;
                ByteBuffer bloom;
                if (bloomFilter.supportsAutoLoading()) {
                    bloom = null;
                    shouldCheckBloom = true;
                } else {
                    bloom = this.reader.getMetaBlock("BLOOM_FILTER_DATA", true);
                    boolean bl = shouldCheckBloom = bloom != null;
                }
                if (shouldCheckBloom) {
                    boolean exists2;
                    boolean keyIsAfterLast;
                    boolean bl = keyIsAfterLast = this.lastBloomKey != null && bloomFilter.getComparator().compare((Object)key, (Object)this.lastBloomKey) > 0;
                    if (this.bloomFilterType == BloomType.ROWCOL) {
                        byte[] rowBloomKey = bloomFilter.createBloomKey(row, 0, row.length, null, 0, 0);
                        exists2 = keyIsAfterLast && bloomFilter.getComparator().compare((Object)rowBloomKey, (Object)this.lastBloomKey) > 0 ? false : bloomFilter.contains(key, 0, key.length, bloom) || bloomFilter.contains(rowBloomKey, 0, rowBloomKey.length, bloom);
                    } else {
                        exists2 = !keyIsAfterLast && bloomFilter.contains(key, 0, key.length, bloom);
                    }
                    this.getSchemaMetrics().updateBloomMetrics(exists2);
                    return exists2;
                }
            }
            catch (IOException e) {
                LOG.error((Object)"Error reading bloom filter data -- proceeding without", (Throwable)e);
                this.setGeneralBloomFilterFaulty();
            }
            catch (IllegalArgumentException e) {
                LOG.error((Object)"Bad bloom filter data -- proceeding without", (Throwable)e);
                this.setGeneralBloomFilterFaulty();
            }
            return true;
        }

        public Map<byte[], byte[]> loadFileInfo() throws IOException {
            Map<byte[], byte[]> fi = this.reader.loadFileInfo();
            byte[] b = fi.get(BLOOM_FILTER_TYPE_KEY);
            if (b != null) {
                this.bloomFilterType = BloomType.valueOf(Bytes.toString(b));
            }
            this.lastBloomKey = fi.get(LAST_BLOOM_KEY);
            byte[] cnt = fi.get(DELETE_FAMILY_COUNT);
            if (cnt != null) {
                this.deleteFamilyCnt = Bytes.toLong(cnt);
            }
            return fi;
        }

        public void loadBloomfilter() {
            this.loadBloomfilter(BlockType.GENERAL_BLOOM_META);
            this.loadBloomfilter(BlockType.DELETE_FAMILY_BLOOM_META);
        }

        private void loadBloomfilter(BlockType blockType) {
            block10: {
                try {
                    if (blockType == BlockType.GENERAL_BLOOM_META) {
                        if (this.generalBloomFilter != null) {
                            return;
                        }
                        DataInput bloomMeta = this.reader.getGeneralBloomFilterMetadata();
                        if (bloomMeta != null) {
                            if (this.bloomFilterType == BloomType.NONE) {
                                throw new IOException("valid bloom filter type not found in FileInfo");
                            }
                            this.generalBloomFilter = BloomFilterFactory.createFromMeta(bloomMeta, this.reader);
                            LOG.info((Object)("Loaded " + this.bloomFilterType.toString() + " (" + this.generalBloomFilter.getClass().getSimpleName() + ") metadata for " + this.reader.getName()));
                        }
                        break block10;
                    }
                    if (blockType == BlockType.DELETE_FAMILY_BLOOM_META) {
                        if (this.deleteFamilyBloomFilter != null) {
                            return;
                        }
                        DataInput bloomMeta = this.reader.getDeleteBloomFilterMetadata();
                        if (bloomMeta != null) {
                            this.deleteFamilyBloomFilter = BloomFilterFactory.createFromMeta(bloomMeta, this.reader);
                            LOG.info((Object)("Loaded Delete Family Bloom (" + this.deleteFamilyBloomFilter.getClass().getSimpleName() + ") metadata for " + this.reader.getName()));
                        }
                        break block10;
                    }
                    throw new RuntimeException("Block Type: " + blockType.toString() + "is not supported for Bloom filter");
                }
                catch (IOException e) {
                    LOG.error((Object)("Error reading bloom filter meta for " + (Object)((Object)blockType) + " -- proceeding without"), (Throwable)e);
                    this.setBloomFilterFaulty(blockType);
                }
                catch (IllegalArgumentException e) {
                    LOG.error((Object)("Bad bloom filter meta " + (Object)((Object)blockType) + " -- proceeding without"), (Throwable)e);
                    this.setBloomFilterFaulty(blockType);
                }
            }
        }

        private void setBloomFilterFaulty(BlockType blockType) {
            if (blockType == BlockType.GENERAL_BLOOM_META) {
                this.setGeneralBloomFilterFaulty();
            } else if (blockType == BlockType.DELETE_FAMILY_BLOOM_META) {
                this.setDeleteFamilyBloomFilterFaulty();
            }
        }

        public long getFilterEntries() {
            return this.generalBloomFilter != null ? this.generalBloomFilter.getKeyCount() : this.reader.getEntries();
        }

        public void setGeneralBloomFilterFaulty() {
            this.generalBloomFilter = null;
        }

        public void setDeleteFamilyBloomFilterFaulty() {
            this.deleteFamilyBloomFilter = null;
        }

        public byte[] getLastKey() {
            return this.reader.getLastKey();
        }

        public byte[] midkey() throws IOException {
            return this.reader.midkey();
        }

        public long length() {
            return this.reader.length();
        }

        public long getTotalUncompressedBytes() {
            return this.reader.getTrailer().getTotalUncompressedBytes();
        }

        public long getEntries() {
            return this.reader.getEntries();
        }

        public long getDeleteFamilyCnt() {
            return this.deleteFamilyCnt;
        }

        public byte[] getFirstKey() {
            return this.reader.getFirstKey();
        }

        public long indexSize() {
            return this.reader.indexSize();
        }

        @Override
        public String getColumnFamilyName() {
            return this.reader.getColumnFamilyName();
        }

        public BloomType getBloomFilterType() {
            return this.bloomFilterType;
        }

        public long getSequenceID() {
            return this.sequenceID;
        }

        public void setSequenceID(long sequenceID) {
            this.sequenceID = sequenceID;
        }

        BloomFilter getGeneralBloomFilter() {
            return this.generalBloomFilter;
        }

        long getUncompressedDataIndexSize() {
            return this.reader.getTrailer().getUncompressedDataIndexSize();
        }

        public long getTotalBloomSize() {
            if (this.generalBloomFilter == null) {
                return 0L;
            }
            return this.generalBloomFilter.getByteSize();
        }

        public int getHFileVersion() {
            return this.reader.getTrailer().getMajorVersion();
        }

        HFile.Reader getHFileReader() {
            return this.reader;
        }

        void disableBloomFilterForTesting() {
            this.generalBloomFilter = null;
            this.deleteFamilyBloomFilter = null;
        }

        public long getMaxTimestamp() {
            return this.timeRangeTracker == null ? Long.MAX_VALUE : this.timeRangeTracker.maximumTimestamp;
        }

        @Override
        public void schemaConfigurationChanged() {
            this.passSchemaMetricsTo((SchemaConfigured)((Object)this.reader));
        }
    }

    public static class Writer {
        private final BloomFilterWriter generalBloomFilterWriter;
        private final BloomFilterWriter deleteFamilyBloomFilterWriter;
        private final BloomType bloomType;
        private byte[] lastBloomKey;
        private int lastBloomKeyOffset;
        private int lastBloomKeyLen;
        private KeyValue.KVComparator kvComparator;
        private KeyValue lastKv = null;
        private long earliestPutTs = Long.MAX_VALUE;
        private KeyValue lastDeleteFamilyKV = null;
        private long deleteFamilyCnt = 0L;
        protected HFileDataBlockEncoder dataBlockEncoder;
        protected ChecksumType checksumType;
        protected int bytesPerChecksum;
        TimeRangeTracker timeRangeTracker = new TimeRangeTracker();
        boolean isTimeRangeTrackerSet = false;
        protected HFile.Writer writer;

        private Writer(FileSystem fs, Path path, int blocksize, Compression.Algorithm compress, HFileDataBlockEncoder dataBlockEncoder, Configuration conf, CacheConfig cacheConf, KeyValue.KVComparator comparator, BloomType bloomType, long maxKeys, ChecksumType checksumType, int bytesPerChecksum) throws IOException {
            this.dataBlockEncoder = dataBlockEncoder != null ? dataBlockEncoder : NoOpDataBlockEncoder.INSTANCE;
            this.writer = HFile.getWriterFactory(conf, cacheConf).withPath(fs, path).withBlockSize(blocksize).withCompression(compress).withDataBlockEncoder(dataBlockEncoder).withComparator(comparator.getRawComparator()).withChecksumType(checksumType).withBytesPerChecksum(bytesPerChecksum).create();
            this.kvComparator = comparator;
            this.generalBloomFilterWriter = BloomFilterFactory.createGeneralBloomAtWrite(conf, cacheConf, bloomType, (int)Math.min(maxKeys, Integer.MAX_VALUE), this.writer);
            if (this.generalBloomFilterWriter != null) {
                this.bloomType = bloomType;
                LOG.info((Object)("Bloom filter type for " + path + ": " + (Object)((Object)this.bloomType) + ", " + this.generalBloomFilterWriter.getClass().getSimpleName()));
            } else {
                this.bloomType = BloomType.NONE;
            }
            this.deleteFamilyBloomFilterWriter = this.bloomType != BloomType.ROWCOL ? BloomFilterFactory.createDeleteBloomAtWrite(conf, cacheConf, (int)Math.min(maxKeys, Integer.MAX_VALUE), this.writer) : null;
            if (this.deleteFamilyBloomFilterWriter != null) {
                LOG.info((Object)("Delete Family Bloom filter type for " + path + ": " + this.deleteFamilyBloomFilterWriter.getClass().getSimpleName()));
            }
            this.checksumType = checksumType;
            this.bytesPerChecksum = bytesPerChecksum;
        }

        public void appendMetadata(long maxSequenceId, boolean majorCompaction) throws IOException {
            this.writer.appendFileInfo(MAX_SEQ_ID_KEY, Bytes.toBytes(maxSequenceId));
            this.writer.appendFileInfo(MAJOR_COMPACTION_KEY, Bytes.toBytes(majorCompaction));
            this.appendTrackedTimestampsToMetadata();
        }

        public void appendTrackedTimestampsToMetadata() throws IOException {
            this.appendFileInfo(TIMERANGE_KEY, WritableUtils.toByteArray((Writable[])new Writable[]{this.timeRangeTracker}));
            this.appendFileInfo(EARLIEST_PUT_TS, Bytes.toBytes(this.earliestPutTs));
        }

        public void setTimeRangeTracker(TimeRangeTracker trt) {
            this.timeRangeTracker = trt;
            this.isTimeRangeTrackerSet = true;
        }

        public void trackTimestamps(KeyValue kv) {
            if (KeyValue.Type.Put.getCode() == kv.getType()) {
                this.earliestPutTs = Math.min(this.earliestPutTs, kv.getTimestamp());
            }
            if (!this.isTimeRangeTrackerSet) {
                this.timeRangeTracker.includeTimestamp(kv);
            }
        }

        private void appendGeneralBloomfilter(KeyValue kv) throws IOException {
            if (this.generalBloomFilterWriter != null) {
                boolean newKey = true;
                if (this.lastKv != null) {
                    switch (this.bloomType) {
                        case ROW: {
                            newKey = !this.kvComparator.matchingRows(kv, this.lastKv);
                            break;
                        }
                        case ROWCOL: {
                            newKey = !this.kvComparator.matchingRowColumn(kv, this.lastKv);
                            break;
                        }
                        case NONE: {
                            newKey = false;
                            break;
                        }
                        default: {
                            throw new IOException("Invalid Bloom filter type: " + (Object)((Object)this.bloomType) + " (ROW or ROWCOL expected)");
                        }
                    }
                }
                if (newKey) {
                    int bloomKeyLen;
                    int bloomKeyOffset;
                    byte[] bloomKey;
                    switch (this.bloomType) {
                        case ROW: {
                            bloomKey = kv.getBuffer();
                            bloomKeyOffset = kv.getRowOffset();
                            bloomKeyLen = kv.getRowLength();
                            break;
                        }
                        case ROWCOL: {
                            bloomKey = this.generalBloomFilterWriter.createBloomKey(kv.getBuffer(), kv.getRowOffset(), kv.getRowLength(), kv.getBuffer(), kv.getQualifierOffset(), kv.getQualifierLength());
                            bloomKeyOffset = 0;
                            bloomKeyLen = bloomKey.length;
                            break;
                        }
                        default: {
                            throw new IOException("Invalid Bloom filter type: " + (Object)((Object)this.bloomType) + " (ROW or ROWCOL expected)");
                        }
                    }
                    this.generalBloomFilterWriter.add(bloomKey, bloomKeyOffset, bloomKeyLen);
                    if (this.lastBloomKey != null && this.generalBloomFilterWriter.getComparator().compare(bloomKey, bloomKeyOffset, bloomKeyLen, this.lastBloomKey, this.lastBloomKeyOffset, this.lastBloomKeyLen) <= 0) {
                        throw new IOException("Non-increasing Bloom keys: " + Bytes.toStringBinary(bloomKey, bloomKeyOffset, bloomKeyLen) + " after " + Bytes.toStringBinary(this.lastBloomKey, this.lastBloomKeyOffset, this.lastBloomKeyLen));
                    }
                    this.lastBloomKey = bloomKey;
                    this.lastBloomKeyOffset = bloomKeyOffset;
                    this.lastBloomKeyLen = bloomKeyLen;
                    this.lastKv = kv;
                }
            }
        }

        private void appendDeleteFamilyBloomFilter(KeyValue kv) throws IOException {
            if (!kv.isDeleteFamily()) {
                return;
            }
            ++this.deleteFamilyCnt;
            if (null != this.deleteFamilyBloomFilterWriter) {
                boolean newKey = true;
                if (this.lastDeleteFamilyKV != null) {
                    boolean bl = newKey = !this.kvComparator.matchingRows(kv, this.lastDeleteFamilyKV);
                }
                if (newKey) {
                    this.deleteFamilyBloomFilterWriter.add(kv.getBuffer(), kv.getRowOffset(), kv.getRowLength());
                    this.lastDeleteFamilyKV = kv;
                }
            }
        }

        public void append(KeyValue kv) throws IOException {
            this.appendGeneralBloomfilter(kv);
            this.appendDeleteFamilyBloomFilter(kv);
            this.writer.append(kv);
            this.trackTimestamps(kv);
        }

        public Path getPath() {
            return this.writer.getPath();
        }

        boolean hasGeneralBloom() {
            return this.generalBloomFilterWriter != null;
        }

        BloomFilterWriter getGeneralBloomWriter() {
            return this.generalBloomFilterWriter;
        }

        private boolean closeBloomFilter(BloomFilterWriter bfw) throws IOException {
            boolean haveBloom;
            boolean bl = haveBloom = bfw != null && bfw.getKeyCount() > 0L;
            if (haveBloom) {
                bfw.compactBloom();
            }
            return haveBloom;
        }

        private boolean closeGeneralBloomFilter() throws IOException {
            boolean hasGeneralBloom = this.closeBloomFilter(this.generalBloomFilterWriter);
            if (hasGeneralBloom) {
                this.writer.addGeneralBloomFilter(this.generalBloomFilterWriter);
                this.writer.appendFileInfo(BLOOM_FILTER_TYPE_KEY, Bytes.toBytes(this.bloomType.toString()));
                if (this.lastBloomKey != null) {
                    this.writer.appendFileInfo(LAST_BLOOM_KEY, Arrays.copyOfRange(this.lastBloomKey, this.lastBloomKeyOffset, this.lastBloomKeyOffset + this.lastBloomKeyLen));
                }
            }
            return hasGeneralBloom;
        }

        private boolean closeDeleteFamilyBloomFilter() throws IOException {
            boolean hasDeleteFamilyBloom = this.closeBloomFilter(this.deleteFamilyBloomFilterWriter);
            if (hasDeleteFamilyBloom) {
                this.writer.addDeleteFamilyBloomFilter(this.deleteFamilyBloomFilterWriter);
            }
            this.writer.appendFileInfo(DELETE_FAMILY_COUNT, Bytes.toBytes(this.deleteFamilyCnt));
            return hasDeleteFamilyBloom;
        }

        public void close() throws IOException {
            boolean hasGeneralBloom = this.closeGeneralBloomFilter();
            boolean hasDeleteFamilyBloom = this.closeDeleteFamilyBloomFilter();
            this.writer.close();
            LOG.info((Object)((hasGeneralBloom ? "" : "NO ") + "General Bloom and " + (hasDeleteFamilyBloom ? "" : "NO ") + "DeleteFamily" + " was added to HFile (" + this.getPath() + ") "));
        }

        public void appendFileInfo(byte[] key, byte[] value) throws IOException {
            this.writer.appendFileInfo(key, value);
        }

        HFile.Writer getHFileWriter() {
            return this.writer;
        }
    }

    public static class WriterBuilder {
        private final Configuration conf;
        private final CacheConfig cacheConf;
        private final FileSystem fs;
        private final int blockSize;
        private Compression.Algorithm compressAlgo = HFile.DEFAULT_COMPRESSION_ALGORITHM;
        private HFileDataBlockEncoder dataBlockEncoder = NoOpDataBlockEncoder.INSTANCE;
        private KeyValue.KVComparator comparator = KeyValue.COMPARATOR;
        private BloomType bloomType = BloomType.NONE;
        private long maxKeyCount = 0L;
        private Path dir;
        private Path filePath;
        private ChecksumType checksumType = HFile.DEFAULT_CHECKSUM_TYPE;
        private int bytesPerChecksum = 16384;

        public WriterBuilder(Configuration conf, CacheConfig cacheConf, FileSystem fs, int blockSize) {
            this.conf = conf;
            this.cacheConf = cacheConf;
            this.fs = fs;
            this.blockSize = blockSize;
        }

        public WriterBuilder withOutputDir(Path dir) {
            Preconditions.checkNotNull((Object)dir);
            this.dir = dir;
            return this;
        }

        public WriterBuilder withFilePath(Path filePath) {
            Preconditions.checkNotNull((Object)filePath);
            this.filePath = filePath;
            return this;
        }

        public WriterBuilder withCompression(Compression.Algorithm compressAlgo) {
            Preconditions.checkNotNull((Object)((Object)compressAlgo));
            this.compressAlgo = compressAlgo;
            return this;
        }

        public WriterBuilder withDataBlockEncoder(HFileDataBlockEncoder encoder) {
            Preconditions.checkNotNull((Object)encoder);
            this.dataBlockEncoder = encoder;
            return this;
        }

        public WriterBuilder withComparator(KeyValue.KVComparator comparator) {
            Preconditions.checkNotNull((Object)comparator);
            this.comparator = comparator;
            return this;
        }

        public WriterBuilder withBloomType(BloomType bloomType) {
            Preconditions.checkNotNull((Object)((Object)bloomType));
            this.bloomType = bloomType;
            return this;
        }

        public WriterBuilder withMaxKeyCount(long maxKeyCount) {
            this.maxKeyCount = maxKeyCount;
            return this;
        }

        public WriterBuilder withChecksumType(ChecksumType checksumType) {
            this.checksumType = checksumType;
            return this;
        }

        public WriterBuilder withBytesPerChecksum(int bytesPerChecksum) {
            this.bytesPerChecksum = bytesPerChecksum;
            return this;
        }

        public Writer build() throws IOException {
            if ((this.dir == null ? 0 : 1) + (this.filePath == null ? 0 : 1) != 1) {
                throw new IllegalArgumentException("Either specify parent directory or file path");
            }
            if (this.dir == null) {
                this.dir = this.filePath.getParent();
            }
            if (!this.fs.exists(this.dir)) {
                this.fs.mkdirs(this.dir);
            }
            if (this.filePath == null) {
                this.filePath = StoreFile.getUniqueFile(this.fs, this.dir);
                if (!BloomFilterFactory.isGeneralBloomEnabled(this.conf)) {
                    this.bloomType = BloomType.NONE;
                }
            }
            if (this.compressAlgo == null) {
                this.compressAlgo = HFile.DEFAULT_COMPRESSION_ALGORITHM;
            }
            if (this.comparator == null) {
                this.comparator = KeyValue.COMPARATOR;
            }
            return new Writer(this.fs, this.filePath, this.blockSize, this.compressAlgo, this.dataBlockEncoder, this.conf, this.cacheConf, this.comparator, this.bloomType, this.maxKeyCount, this.checksumType, this.bytesPerChecksum);
        }
    }

    public static enum BloomType {
        NONE,
        ROW,
        ROWCOL;

    }
}

