/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.wal;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.regionserver.wal.CompressionContext;
import org.apache.hadoop.hbase.regionserver.wal.Compressor;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.io.WritableUtils;

class KeyValueCompression {
    KeyValueCompression() {
    }

    public static KeyValue readKV(DataInput in, CompressionContext readContext) throws IOException {
        int keylength = WritableUtils.readVInt((DataInput)in);
        int vlength = WritableUtils.readVInt((DataInput)in);
        int length = 8 + keylength + vlength;
        byte[] backingArray = new byte[length];
        int pos = 0;
        pos = Bytes.putInt(backingArray, pos, keylength);
        pos = Bytes.putInt(backingArray, pos, vlength);
        int elemLen = Compressor.uncompressIntoArray(backingArray, pos + 2, in, readContext.rowDict);
        KeyValueCompression.checkLength(elemLen, Short.MAX_VALUE);
        pos = Bytes.putShort(backingArray, pos, (short)elemLen);
        pos += elemLen;
        elemLen = Compressor.uncompressIntoArray(backingArray, pos + 1, in, readContext.familyDict);
        KeyValueCompression.checkLength(elemLen, 127);
        pos = Bytes.putByte(backingArray, pos, (byte)elemLen);
        pos += elemLen;
        elemLen = Compressor.uncompressIntoArray(backingArray, pos, in, readContext.qualifierDict);
        in.readFully(backingArray, pos += elemLen, length - pos);
        return new KeyValue(backingArray);
    }

    private static void checkLength(int len, int max) throws IOException {
        if (len < 0 || len > max) {
            throw new IOException("Invalid length for compresesed portion of keyvalue: " + len);
        }
    }

    public static void writeKV(DataOutput out, KeyValue keyVal, CompressionContext writeContext) throws IOException {
        byte[] backingArray = keyVal.getBuffer();
        int offset = keyVal.getOffset();
        WritableUtils.writeVInt((DataOutput)out, (int)keyVal.getKeyLength());
        WritableUtils.writeVInt((DataOutput)out, (int)keyVal.getValueLength());
        Compressor.writeCompressed(keyVal.getBuffer(), keyVal.getRowOffset(), keyVal.getRowLength(), out, writeContext.rowDict);
        Compressor.writeCompressed(keyVal.getBuffer(), keyVal.getFamilyOffset(), keyVal.getFamilyLength(), out, writeContext.familyDict);
        Compressor.writeCompressed(keyVal.getBuffer(), keyVal.getQualifierOffset(), keyVal.getQualifierLength(), out, writeContext.qualifierDict);
        int pos = keyVal.getTimestampOffset();
        int remainingLength = keyVal.getLength() + offset - pos;
        out.write(backingArray, pos, remainingLength);
    }
}

