/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.rest;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.TableNotFoundException;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.HTableInterface;
import org.apache.hadoop.hbase.client.HTablePool;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.rest.ResourceBase;
import org.apache.hadoop.hbase.rest.ResultGenerator;
import org.apache.hadoop.hbase.rest.RowSpec;
import org.apache.hadoop.hbase.rest.TableResource;
import org.apache.hadoop.hbase.rest.model.CellModel;
import org.apache.hadoop.hbase.rest.model.CellSetModel;
import org.apache.hadoop.hbase.rest.model.RowModel;
import org.apache.hadoop.hbase.util.Bytes;

public class RowResource
extends ResourceBase {
    private static final Log LOG = LogFactory.getLog(RowResource.class);
    static final String CHECK_PUT = "put";
    static final String CHECK_DELETE = "delete";
    TableResource tableResource;
    RowSpec rowspec;
    private String check = null;

    public RowResource(TableResource tableResource, String rowspec, String versions, String check) throws IOException {
        this.tableResource = tableResource;
        this.rowspec = new RowSpec(rowspec);
        if (versions != null) {
            this.rowspec.setMaxVersions(Integer.valueOf(versions));
        }
        this.check = check;
    }

    @GET
    @Produces(value={"text/xml", "application/json", "application/x-protobuf", "application/protobuf"})
    public Response get(@Context UriInfo uriInfo) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("GET " + uriInfo.getAbsolutePath()));
        }
        this.servlet.getMetrics().incrementRequests(1);
        try {
            ResultGenerator generator = ResultGenerator.fromRowSpec(this.tableResource.getName(), this.rowspec, null);
            if (!generator.hasNext()) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).type("text/plain").entity((Object)"Not found\r\n").build();
            }
            int count = 0;
            CellSetModel model = new CellSetModel();
            KeyValue value = (KeyValue)generator.next();
            byte[] rowKey = value.getRow();
            RowModel rowModel = new RowModel(rowKey);
            do {
                if (!Bytes.equals(value.getRow(), rowKey)) {
                    model.addRow(rowModel);
                    rowKey = value.getRow();
                    rowModel = new RowModel(rowKey);
                }
                rowModel.addCell(new CellModel(value.getFamily(), value.getQualifier(), value.getTimestamp(), value.getValue()));
            } while (++count <= this.rowspec.getMaxValues() && (value = (KeyValue)generator.next()) != null);
            model.addRow(rowModel);
            this.servlet.getMetrics().incrementSucessfulGetRequests(1);
            return Response.ok((Object)model).build();
        }
        catch (RuntimeException e) {
            this.servlet.getMetrics().incrementFailedPutRequests(1);
            if (e.getCause() instanceof TableNotFoundException) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).type("text/plain").entity((Object)"Not found\r\n").build();
            }
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).type("text/plain").entity((Object)"Bad request\r\n").build();
        }
        catch (Exception e) {
            this.servlet.getMetrics().incrementFailedPutRequests(1);
            return Response.status((Response.Status)Response.Status.SERVICE_UNAVAILABLE).type("text/plain").entity((Object)"Unavailable\r\n").build();
        }
    }

    @GET
    @Produces(value={"application/octet-stream"})
    public Response getBinary(@Context UriInfo uriInfo) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("GET " + uriInfo.getAbsolutePath() + " as " + "application/octet-stream"));
        }
        this.servlet.getMetrics().incrementRequests(1);
        if (!this.rowspec.hasColumns() || this.rowspec.getColumns().length > 1) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).type("text/plain").entity((Object)"Bad request\r\n").build();
        }
        try {
            ResultGenerator generator = ResultGenerator.fromRowSpec(this.tableResource.getName(), this.rowspec, null);
            if (!generator.hasNext()) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).type("text/plain").entity((Object)"Not found\r\n").build();
            }
            KeyValue value = (KeyValue)generator.next();
            Response.ResponseBuilder response = Response.ok((Object)value.getValue());
            response.header("X-Timestamp", (Object)value.getTimestamp());
            this.servlet.getMetrics().incrementSucessfulGetRequests(1);
            return response.build();
        }
        catch (IOException e) {
            this.servlet.getMetrics().incrementFailedGetRequests(1);
            return Response.status((Response.Status)Response.Status.SERVICE_UNAVAILABLE).type("text/plain").entity((Object)"Unavailable\r\n").build();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Response update(CellSetModel model, boolean replace) {
        this.servlet.getMetrics().incrementRequests(1);
        if (this.servlet.isReadOnly()) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).type("text/plain").entity((Object)"Forbidden\r\n").build();
        }
        if (CHECK_PUT.equalsIgnoreCase(this.check)) {
            return this.checkAndPut(model);
        }
        if (CHECK_DELETE.equalsIgnoreCase(this.check)) {
            return this.checkAndDelete(model);
        }
        if (this.check != null && this.check.length() > 0) {
            LOG.warn((Object)("Unknown check value: " + this.check + ", ignored"));
        }
        HTablePool pool = this.servlet.getTablePool();
        HTableInterface table = null;
        try {
            List<RowModel> rows = model.getRows();
            ArrayList<Put> puts = new ArrayList<Put>();
            for (RowModel row : rows) {
                byte[] key = row.getKey();
                if (key == null) {
                    key = this.rowspec.getRow();
                }
                if (key == null) {
                    Response response = Response.status((Response.Status)Response.Status.BAD_REQUEST).type("text/plain").entity((Object)"Bad request\r\n").build();
                    return response;
                }
                Put put2 = new Put(key);
                int i = 0;
                for (CellModel cell : row.getCells()) {
                    byte[] col = cell.getColumn();
                    if (col == null) {
                        try {
                            col = this.rowspec.getColumns()[i++];
                        }
                        catch (ArrayIndexOutOfBoundsException e) {
                            col = null;
                        }
                    }
                    if (col == null) {
                        Response e = Response.status((Response.Status)Response.Status.BAD_REQUEST).type("text/plain").entity((Object)"Bad request\r\n").build();
                        return e;
                    }
                    byte[][] parts = KeyValue.parseColumn(col);
                    if (parts.length == 2 && parts[1].length > 0) {
                        put2.add(parts[0], parts[1], cell.getTimestamp(), cell.getValue());
                        continue;
                    }
                    put2.add(parts[0], null, cell.getTimestamp(), cell.getValue());
                }
                puts.add(put2);
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug((Object)("PUT " + put2.toString()));
            }
            table = pool.getTable(this.tableResource.getName());
            table.put(puts);
            table.flushCommits();
            Response.ResponseBuilder response = Response.ok();
            this.servlet.getMetrics().incrementSucessfulPutRequests(1);
            Response response2 = response.build();
            return response2;
        }
        catch (IOException e) {
            this.servlet.getMetrics().incrementFailedPutRequests(1);
            Response response = Response.status((Response.Status)Response.Status.SERVICE_UNAVAILABLE).type("text/plain").entity((Object)"Unavailable\r\n").build();
            return response;
        }
        finally {
            if (table != null) {
                try {
                    table.close();
                }
                catch (IOException ioe) {
                    LOG.debug((Object)"Exception received while closing the table", (Throwable)ioe);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Response updateBinary(byte[] message, HttpHeaders headers, boolean replace) {
        Response response;
        this.servlet.getMetrics().incrementRequests(1);
        if (this.servlet.isReadOnly()) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).type("text/plain").entity((Object)"Forbidden\r\n").build();
        }
        HTablePool pool = this.servlet.getTablePool();
        HTableInterface table = null;
        try {
            byte[] row = this.rowspec.getRow();
            byte[][] columns = this.rowspec.getColumns();
            byte[] column = null;
            if (columns != null) {
                column = columns[0];
            }
            long timestamp = Long.MAX_VALUE;
            List vals = headers.getRequestHeader("X-Row");
            if (vals != null && !vals.isEmpty()) {
                row = Bytes.toBytes((String)vals.get(0));
            }
            if ((vals = headers.getRequestHeader("X-Column")) != null && !vals.isEmpty()) {
                column = Bytes.toBytes((String)vals.get(0));
            }
            if ((vals = headers.getRequestHeader("X-Timestamp")) != null && !vals.isEmpty()) {
                timestamp = Long.valueOf((String)vals.get(0));
            }
            if (column == null) {
                Response response2 = Response.status((Response.Status)Response.Status.BAD_REQUEST).type("text/plain").entity((Object)"Bad request\r\n").build();
                return response2;
            }
            Put put2 = new Put(row);
            byte[][] parts = KeyValue.parseColumn(column);
            if (parts.length == 2 && parts[1].length > 0) {
                put2.add(parts[0], parts[1], timestamp, message);
            } else {
                put2.add(parts[0], null, timestamp, message);
            }
            table = pool.getTable(this.tableResource.getName());
            table.put(put2);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("PUT " + put2.toString()));
            }
            this.servlet.getMetrics().incrementSucessfulPutRequests(1);
            response = Response.ok().build();
        }
        catch (IOException e) {
            this.servlet.getMetrics().incrementFailedPutRequests(1);
            Response response3 = Response.status((Response.Status)Response.Status.SERVICE_UNAVAILABLE).type("text/plain").entity((Object)"Unavailable\r\n").build();
            return response3;
        }
        finally {
            if (table != null) {
                try {
                    table.close();
                }
                catch (IOException ioe) {}
            }
        }
        return response;
    }

    @PUT
    @Consumes(value={"text/xml", "application/json", "application/x-protobuf", "application/protobuf"})
    public Response put(CellSetModel model, @Context UriInfo uriInfo) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("PUT " + uriInfo.getAbsolutePath() + " " + uriInfo.getQueryParameters()));
        }
        return this.update(model, true);
    }

    @PUT
    @Consumes(value={"application/octet-stream"})
    public Response putBinary(byte[] message, @Context UriInfo uriInfo, @Context HttpHeaders headers) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("PUT " + uriInfo.getAbsolutePath() + " as " + "application/octet-stream"));
        }
        return this.updateBinary(message, headers, true);
    }

    @POST
    @Consumes(value={"text/xml", "application/json", "application/x-protobuf", "application/protobuf"})
    public Response post(CellSetModel model, @Context UriInfo uriInfo) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("POST " + uriInfo.getAbsolutePath() + " " + uriInfo.getQueryParameters()));
        }
        return this.update(model, false);
    }

    @POST
    @Consumes(value={"application/octet-stream"})
    public Response postBinary(byte[] message, @Context UriInfo uriInfo, @Context HttpHeaders headers) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("POST " + uriInfo.getAbsolutePath() + " as " + "application/octet-stream"));
        }
        return this.updateBinary(message, headers, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @DELETE
    public Response delete(@Context UriInfo uriInfo) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("DELETE " + uriInfo.getAbsolutePath()));
        }
        this.servlet.getMetrics().incrementRequests(1);
        if (this.servlet.isReadOnly()) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).type("text/plain").entity((Object)"Forbidden\r\n").build();
        }
        Delete delete = null;
        delete = this.rowspec.hasTimestamp() ? new Delete(this.rowspec.getRow(), this.rowspec.getTimestamp(), null) : new Delete(this.rowspec.getRow());
        for (byte[] column : this.rowspec.getColumns()) {
            byte[][] split = KeyValue.parseColumn(column);
            if (this.rowspec.hasTimestamp()) {
                if (split.length == 2 && split[1].length != 0) {
                    delete.deleteColumns(split[0], split[1], this.rowspec.getTimestamp());
                    continue;
                }
                delete.deleteFamily(split[0], this.rowspec.getTimestamp());
                continue;
            }
            if (split.length == 2 && split[1].length != 0) {
                delete.deleteColumns(split[0], split[1]);
                continue;
            }
            delete.deleteFamily(split[0]);
        }
        HTablePool pool = this.servlet.getTablePool();
        HTableInterface table = null;
        try {
            table = pool.getTable(this.tableResource.getName());
            table.delete(delete);
            this.servlet.getMetrics().incrementSucessfulDeleteRequests(1);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("DELETE " + delete.toString()));
            }
        }
        catch (IOException e) {
            this.servlet.getMetrics().incrementFailedDeleteRequests(1);
            Response response = Response.status((Response.Status)Response.Status.SERVICE_UNAVAILABLE).type("text/plain").entity((Object)"Unavailable\r\n").build();
            return response;
        }
        finally {
            if (table != null) {
                try {
                    table.close();
                }
                catch (IOException ioe) {}
            }
        }
        return Response.ok().build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    Response checkAndPut(CellSetModel model) {
        int n;
        CellModel valueToPutCell2;
        byte[][] valueToPutParts;
        CellModel valueToCheckCell;
        Put put2;
        List<CellModel> cellModels;
        byte[] key;
        HTablePool pool = this.servlet.getTablePool();
        HTableInterface table = null;
        try {
            if (model.getRows().size() != 1) {
                Response response = Response.status((Response.Status)Response.Status.BAD_REQUEST).type("text/plain").entity((Object)"Bad request\r\n").build();
                return response;
            }
            RowModel rowModel = model.getRows().get(0);
            key = rowModel.getKey();
            if (key == null) {
                key = this.rowspec.getRow();
            }
            cellModels = rowModel.getCells();
            int cellModelCount = cellModels.size();
            if (key == null || cellModelCount <= 1) {
                Response response = Response.status((Response.Status)Response.Status.BAD_REQUEST).type("text/plain").entity((Object)"Bad request\r\n").build();
                return response;
            }
            put2 = new Put(key);
            valueToCheckCell = cellModels.get(cellModelCount - 1);
            byte[] valueToCheckColumn = valueToCheckCell.getColumn();
            valueToPutParts = KeyValue.parseColumn(valueToCheckColumn);
            if (valueToPutParts.length != 2 || valueToPutParts[1].length <= 0) {
                Response valueToPutCell2 = Response.status((Response.Status)Response.Status.BAD_REQUEST).type("text/plain").entity((Object)"Bad request\r\n").build();
                return valueToPutCell2;
            }
            valueToPutCell2 = null;
            n = cellModelCount - 1;
        }
        catch (IOException e) {
            Response response = Response.status((Response.Status)Response.Status.SERVICE_UNAVAILABLE).type("text/plain").entity((Object)"Unavailable\r\n").build();
            return response;
        }
        for (int i = 0; i < n; ++i) {
            if (!Bytes.equals(cellModels.get(i).getColumn(), valueToCheckCell.getColumn())) continue;
            valueToPutCell2 = cellModels.get(i);
            break;
        }
        if (valueToPutCell2 == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).type("text/plain").entity((Object)"Bad request\r\n").build();
        }
        put2.add(valueToPutParts[0], valueToPutParts[1], valueToPutCell2.getTimestamp(), valueToPutCell2.getValue());
        table = pool.getTable(this.tableResource.getName());
        boolean retValue = table.checkAndPut(key, valueToPutParts[0], valueToPutParts[1], valueToCheckCell.getValue(), put2);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("CHECK-AND-PUT " + put2.toString() + ", returns " + retValue));
        }
        table.flushCommits();
        Response.ResponseBuilder response = Response.ok();
        if (retValue) return response.build();
        response = Response.status((int)304);
        return response.build();
        finally {
            if (table != null) {
                try {
                    table.close();
                }
                catch (IOException ioe) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Response checkAndDelete(CellSetModel model) {
        HTablePool pool = this.servlet.getTablePool();
        HTableInterface table = null;
        Delete delete = null;
        try {
            byte[][] parts;
            if (model.getRows().size() != 1) {
                Response response = Response.status((Response.Status)Response.Status.BAD_REQUEST).type("text/plain").entity((Object)"Bad request\r\n").build();
                return response;
            }
            RowModel rowModel = model.getRows().get(0);
            byte[] key = rowModel.getKey();
            if (key == null) {
                key = this.rowspec.getRow();
            }
            if (key == null) {
                Response response = Response.status((Response.Status)Response.Status.BAD_REQUEST).type("text/plain").entity((Object)"Bad request\r\n").build();
                return response;
            }
            delete = new Delete(key);
            CellModel valueToDeleteCell = rowModel.getCells().get(0);
            byte[] valueToDeleteColumn = valueToDeleteCell.getColumn();
            if (valueToDeleteColumn == null) {
                try {
                    valueToDeleteColumn = this.rowspec.getColumns()[0];
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    Response response = Response.status((Response.Status)Response.Status.BAD_REQUEST).type("text/plain").entity((Object)"Bad request\r\n").build();
                    if (table != null) {
                        try {
                            table.close();
                        }
                        catch (IOException ioe) {
                            LOG.debug((Object)"Exception received while closing the table", (Throwable)ioe);
                        }
                    }
                    return response;
                }
            }
            if ((parts = KeyValue.parseColumn(valueToDeleteColumn)).length != 2 || parts[1].length <= 0) {
                Response response = Response.status((Response.Status)Response.Status.BAD_REQUEST).type("text/plain").entity((Object)"Bad request\r\n").build();
                return response;
            }
            delete.deleteColumns(parts[0], parts[1]);
            table = pool.getTable(this.tableResource.getName());
            boolean retValue = table.checkAndDelete(key, parts[0], parts[1], valueToDeleteCell.getValue(), delete);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("CHECK-AND-DELETE " + delete.toString() + ", returns " + retValue));
            }
            table.flushCommits();
            Response.ResponseBuilder response = Response.ok();
            if (!retValue) {
                response = Response.status((int)304);
            }
            Response response2 = response.build();
            return response2;
        }
        catch (IOException e) {
            Response response = Response.status((Response.Status)Response.Status.SERVICE_UNAVAILABLE).type("text/plain").entity((Object)"Unavailable\r\n").build();
            return response;
        }
        finally {
            if (table != null) {
                try {
                    table.close();
                }
                catch (IOException ioe) {
                    LOG.debug((Object)"Exception received while closing the table", (Throwable)ioe);
                }
            }
        }
    }
}

