/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.thrift;

import java.lang.reflect.Method;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.metrics.MetricsContext;
import org.apache.hadoop.metrics.MetricsRecord;
import org.apache.hadoop.metrics.MetricsUtil;
import org.apache.hadoop.metrics.Updater;
import org.apache.hadoop.metrics.util.MetricsBase;
import org.apache.hadoop.metrics.util.MetricsIntValue;
import org.apache.hadoop.metrics.util.MetricsRegistry;
import org.apache.hadoop.metrics.util.MetricsTimeVaryingRate;

public class ThriftMetrics
implements Updater {
    public static final Log LOG = LogFactory.getLog(ThriftMetrics.class);
    public static final String CONTEXT_NAME = "thriftserver";
    private final MetricsContext context;
    private final MetricsRecord metricsRecord;
    private final MetricsRegistry registry = new MetricsRegistry();
    private final long slowResponseTime;
    public static final String SLOW_RESPONSE_NANO_SEC = "hbase.thrift.slow.response.nano.second";
    public static final long DEFAULT_SLOW_RESPONSE_NANO_SEC = 10000000L;
    private final MetricsIntValue callQueueLen = new MetricsIntValue("callQueueLen", this.registry);
    private final MetricsTimeVaryingRate numRowKeysInBatchGet = new MetricsTimeVaryingRate("numRowKeysInBatchGet", this.registry);
    private final MetricsTimeVaryingRate numRowKeysInBatchMutate = new MetricsTimeVaryingRate("numRowKeysInBatchMutate", this.registry);
    private final MetricsTimeVaryingRate timeInQueue = new MetricsTimeVaryingRate("timeInQueue", this.registry);
    private MetricsTimeVaryingRate thriftCall = new MetricsTimeVaryingRate("thriftCall", this.registry);
    private MetricsTimeVaryingRate slowThriftCall = new MetricsTimeVaryingRate("slowThriftCall", this.registry);

    public ThriftMetrics(int port, Configuration conf, Class<?> iface) {
        this.slowResponseTime = conf.getLong(SLOW_RESPONSE_NANO_SEC, 10000000L);
        this.context = MetricsUtil.getContext((String)CONTEXT_NAME);
        this.metricsRecord = MetricsUtil.createRecord((MetricsContext)this.context, (String)CONTEXT_NAME);
        this.metricsRecord.setTag("port", port + "");
        LOG.info((Object)("Initializing RPC Metrics with port=" + port));
        this.context.registerUpdater((Updater)this);
        this.createMetricsForMethods(iface);
    }

    public void incTimeInQueue(long time) {
        this.timeInQueue.inc(time);
    }

    public void setCallQueueLen(int len) {
        this.callQueueLen.set(len);
    }

    public void incNumRowKeysInBatchGet(int diff) {
        this.numRowKeysInBatchGet.inc((long)diff);
    }

    public void incNumRowKeysInBatchMutate(int diff) {
        this.numRowKeysInBatchMutate.inc((long)diff);
    }

    public void incMethodTime(String name, int time) {
        MetricsTimeVaryingRate methodTimeMetrc = this.getMethodTimeMetrics(name);
        if (methodTimeMetrc == null) {
            LOG.warn((Object)("Got incMethodTime() request for method that doesnt exist: " + name));
            return;
        }
        methodTimeMetrc.inc((long)time);
        this.thriftCall.inc((long)time);
        if ((long)time > this.slowResponseTime) {
            this.slowThriftCall.inc((long)time);
        }
    }

    private void createMetricsForMethods(Class<?> iface) {
        LOG.debug((Object)("Creating metrics for interface " + iface.toString()));
        for (Method m : iface.getDeclaredMethods()) {
            if (this.getMethodTimeMetrics(m.getName()) == null) {
                LOG.debug((Object)("Creating metrics for method:" + m.getName()));
            }
            this.createMethodTimeMetrics(m.getName());
        }
    }

    private MetricsTimeVaryingRate getMethodTimeMetrics(String key) {
        return (MetricsTimeVaryingRate)this.registry.get(key);
    }

    private MetricsTimeVaryingRate createMethodTimeMetrics(String key) {
        return new MetricsTimeVaryingRate(key, this.registry);
    }

    public void doUpdates(MetricsContext context) {
        for (MetricsBase m : this.registry.getMetricsList()) {
            m.pushMetric(this.metricsRecord);
        }
        this.metricsRecord.update();
    }
}

