/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hcatalog.data.schema;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hcatalog.common.HCatException;
import org.apache.hcatalog.data.schema.HCatFieldSchema;

public class HCatSchema
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final List<HCatFieldSchema> fieldSchemas;
    private final Map<String, Integer> fieldPositionMap;
    private final List<String> fieldNames;

    public HCatSchema(List<HCatFieldSchema> fieldSchemas) {
        this.fieldSchemas = new ArrayList<HCatFieldSchema>(fieldSchemas);
        int idx = 0;
        this.fieldPositionMap = new HashMap<String, Integer>();
        this.fieldNames = new ArrayList<String>();
        for (HCatFieldSchema field : fieldSchemas) {
            if (field == null) {
                throw new IllegalArgumentException("Field cannot be null");
            }
            String fieldName = field.getName();
            if (this.fieldPositionMap.containsKey(fieldName)) {
                throw new IllegalArgumentException("Field named " + fieldName + " already exists");
            }
            this.fieldPositionMap.put(fieldName, idx);
            this.fieldNames.add(fieldName);
            ++idx;
        }
    }

    public void append(HCatFieldSchema hfs) throws HCatException {
        if (hfs == null) {
            throw new HCatException("Attempt to append null HCatFieldSchema in HCatSchema.");
        }
        String fieldName = hfs.getName();
        if (this.fieldPositionMap.containsKey(fieldName)) {
            throw new HCatException("Attempt to append HCatFieldSchema with already existing name: " + fieldName + ".");
        }
        this.fieldSchemas.add(hfs);
        this.fieldNames.add(fieldName);
        this.fieldPositionMap.put(fieldName, this.size() - 1);
    }

    public List<HCatFieldSchema> getFields() {
        return Collections.unmodifiableList(this.fieldSchemas);
    }

    public Integer getPosition(String fieldName) {
        return this.fieldPositionMap.get(fieldName);
    }

    public HCatFieldSchema get(String fieldName) throws HCatException {
        return this.get(this.getPosition(fieldName));
    }

    public List<String> getFieldNames() {
        return this.fieldNames;
    }

    public HCatFieldSchema get(int position) {
        return this.fieldSchemas.get(position);
    }

    public int size() {
        return this.fieldSchemas.size();
    }

    public void remove(HCatFieldSchema hcatFieldSchema) throws HCatException {
        if (!this.fieldSchemas.contains(hcatFieldSchema)) {
            throw new HCatException("Attempt to delete a non-existent column from HCat Schema: " + hcatFieldSchema);
        }
        this.fieldSchemas.remove(hcatFieldSchema);
        this.fieldPositionMap.remove(hcatFieldSchema);
        this.fieldNames.remove(hcatFieldSchema.getName());
    }

    public String toString() {
        boolean first = true;
        StringBuilder sb = new StringBuilder();
        for (HCatFieldSchema hfs : this.fieldSchemas) {
            if (!first) {
                sb.append(",");
            } else {
                first = false;
            }
            if (hfs.getName() != null) {
                sb.append(hfs.getName());
                sb.append(":");
            }
            sb.append(hfs.toString());
        }
        return sb.toString();
    }

    public String getSchemaAsTypeString() {
        boolean first = true;
        StringBuilder sb = new StringBuilder();
        for (HCatFieldSchema hfs : this.fieldSchemas) {
            if (!first) {
                sb.append(",");
            } else {
                first = false;
            }
            if (hfs.getName() != null) {
                sb.append(hfs.getName());
                sb.append(":");
            }
            sb.append(hfs.getTypeString());
        }
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HCatSchema)) {
            return false;
        }
        HCatSchema other = (HCatSchema)obj;
        return this.getFields().equals(other.getFields());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }
}

