/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hcatalog.mapreduce;

import java.io.Serializable;
import java.util.Map;
import java.util.Properties;
import org.apache.hcatalog.data.schema.HCatSchema;
import org.apache.hcatalog.mapreduce.HCatStorageHandler;
import org.apache.hcatalog.mapreduce.HCatTableInfo;

public class PartInfo
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final HCatSchema partitionSchema;
    private final String storageHandlerClassName;
    private final String inputFormatClassName;
    private final String outputFormatClassName;
    private final String serdeClassName;
    private final Properties hcatProperties;
    private final String location;
    private Map<String, String> partitionValues;
    Map<String, String> jobProperties;
    HCatTableInfo tableInfo;

    public PartInfo(HCatSchema partitionSchema, HCatStorageHandler storageHandler, String location, Properties hcatProperties, Map<String, String> jobProperties, HCatTableInfo tableInfo) {
        this.partitionSchema = partitionSchema;
        this.location = location;
        this.hcatProperties = hcatProperties;
        this.jobProperties = jobProperties;
        this.tableInfo = tableInfo;
        this.storageHandlerClassName = storageHandler.getClass().getName();
        this.inputFormatClassName = storageHandler.getInputFormatClass().getName();
        this.serdeClassName = storageHandler.getSerDeClass().getName();
        this.outputFormatClassName = storageHandler.getOutputFormatClass().getName();
    }

    public HCatSchema getPartitionSchema() {
        return this.partitionSchema;
    }

    public String getStorageHandlerClassName() {
        return this.storageHandlerClassName;
    }

    public String getInputFormatClassName() {
        return this.inputFormatClassName;
    }

    public String getOutputFormatClassName() {
        return this.outputFormatClassName;
    }

    public String getSerdeClassName() {
        return this.serdeClassName;
    }

    public Properties getInputStorageHandlerProperties() {
        return this.hcatProperties;
    }

    public String getLocation() {
        return this.location;
    }

    public void setPartitionValues(Map<String, String> partitionValues) {
        this.partitionValues = partitionValues;
    }

    public Map<String, String> getPartitionValues() {
        return this.partitionValues;
    }

    public Map<String, String> getJobProperties() {
        return this.jobProperties;
    }

    public HCatTableInfo getTableInfo() {
        return this.tableInfo;
    }
}

