/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.hcatalog.cli.SemanticAnalysis;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.AbstractSemanticAnalyzerHook;
import org.apache.hadoop.hive.ql.parse.HiveSemanticAnalyzerHookContext;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.AlterTableDesc;
import org.apache.hadoop.hive.ql.plan.DDLWork;
import org.apache.hadoop.hive.ql.plan.DescDatabaseDesc;
import org.apache.hadoop.hive.ql.plan.DescTableDesc;
import org.apache.hadoop.hive.ql.plan.DropDatabaseDesc;
import org.apache.hadoop.hive.ql.plan.DropTableDesc;
import org.apache.hadoop.hive.ql.plan.HiveOperation;
import org.apache.hadoop.hive.ql.plan.PartitionSpec;
import org.apache.hadoop.hive.ql.plan.ShowDatabasesDesc;
import org.apache.hadoop.hive.ql.plan.ShowPartitionsDesc;
import org.apache.hadoop.hive.ql.plan.ShowTableStatusDesc;
import org.apache.hadoop.hive.ql.plan.ShowTablesDesc;
import org.apache.hadoop.hive.ql.plan.SwitchDatabaseDesc;
import org.apache.hadoop.hive.ql.security.authorization.Privilege;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hive.hcatalog.cli.SemanticAnalysis.CreateDatabaseHook;
import org.apache.hive.hcatalog.cli.SemanticAnalysis.CreateTableHook;
import org.apache.hive.hcatalog.cli.SemanticAnalysis.HCatSemanticAnalyzerBase;
import org.apache.hive.hcatalog.common.ErrorType;
import org.apache.hive.hcatalog.common.HCatException;

public class HCatSemanticAnalyzer
extends HCatSemanticAnalyzerBase {
    private AbstractSemanticAnalyzerHook hook;
    private ASTNode ast;

    public ASTNode preAnalyze(HiveSemanticAnalyzerHookContext context, ASTNode ast) throws SemanticException {
        this.ast = ast;
        switch (ast.getToken().getType()) {
            case 599: {
                this.hook = new CreateTableHook();
                return this.hook.preAnalyze(context, ast);
            }
            case 593: {
                this.hook = new CreateDatabaseHook();
                return this.hook.preAnalyze(context, ast);
            }
            case 568: {
                if (((ASTNode)ast.getChild(1)).getToken().getType() == 566) {
                    return ast;
                }
                if (((ASTNode)ast.getChild(1)).getToken().getType() == 560) {
                    throw new SemanticException("Operation not supported.");
                }
                return ast;
            }
            case 554: 
            case 555: 
            case 557: 
            case 558: 
            case 563: 
            case 564: 
            case 565: 
            case 569: 
            case 570: 
            case 571: 
            case 573: 
            case 574: 
            case 575: 
            case 577: 
            case 582: 
            case 583: 
            case 584: 
            case 595: 
            case 598: 
            case 600: 
            case 612: 
            case 613: 
            case 614: 
            case 620: 
            case 622: 
            case 624: 
            case 625: 
            case 627: 
            case 631: 
            case 642: 
            case 643: 
            case 644: 
            case 677: 
            case 732: 
            case 733: 
            case 745: 
            case 746: 
            case 747: 
            case 748: 
            case 749: 
            case 750: 
            case 752: 
            case 753: 
            case 754: 
            case 768: 
            case 815: {
                return ast;
            }
        }
        throw new SemanticException("Operation not supported.");
    }

    @Override
    public void postAnalyze(HiveSemanticAnalyzerHookContext context, List<Task<? extends Serializable>> rootTasks) throws SemanticException {
        try {
            switch (this.ast.getToken().getType()) {
                case 554: 
                case 555: 
                case 557: 
                case 558: 
                case 563: 
                case 564: 
                case 565: 
                case 568: 
                case 569: 
                case 570: 
                case 571: 
                case 573: 
                case 574: 
                case 575: 
                case 577: 
                case 582: 
                case 583: 
                case 584: 
                case 593: 
                case 595: 
                case 598: 
                case 599: 
                case 600: 
                case 612: 
                case 613: 
                case 614: 
                case 620: 
                case 622: 
                case 624: 
                case 625: 
                case 627: 
                case 631: 
                case 642: 
                case 643: 
                case 644: 
                case 677: 
                case 732: 
                case 733: 
                case 745: 
                case 746: 
                case 747: 
                case 748: 
                case 749: 
                case 750: 
                case 752: 
                case 753: 
                case 754: 
                case 768: 
                case 815: {
                    break;
                }
                default: {
                    throw new HCatException(ErrorType.ERROR_INTERNAL_EXCEPTION, "Unexpected token: " + this.ast.getToken());
                }
            }
            this.authorizeDDL(context, rootTasks);
        }
        catch (HCatException e) {
            throw new SemanticException((Throwable)e);
        }
        catch (HiveException e) {
            throw new SemanticException((Throwable)e);
        }
        if (this.hook != null) {
            this.hook.postAnalyze(context, rootTasks);
        }
    }

    private String extractTableName(String compoundName) {
        String[] words = compoundName.split("\\.");
        return words[0];
    }

    @Override
    protected void authorizeDDLWork(HiveSemanticAnalyzerHookContext cntxt, Hive hive, DDLWork work) throws HiveException {
        ShowPartitionsDesc showParts;
        DescTableDesc descTable;
        AlterTableDesc alterTable;
        DropTableDesc dropTable;
        ShowTableStatusDesc showTableStatus;
        ShowTablesDesc showTables;
        SwitchDatabaseDesc switchDb;
        DescDatabaseDesc descDb;
        DropDatabaseDesc dropDb;
        ShowDatabasesDesc showDatabases = work.getShowDatabasesDesc();
        if (showDatabases != null) {
            this.authorize(HiveOperation.SHOWDATABASES.getInputRequiredPrivileges(), HiveOperation.SHOWDATABASES.getOutputRequiredPrivileges());
        }
        if ((dropDb = work.getDropDatabaseDesc()) != null) {
            Database db = cntxt.getHive().getDatabase(dropDb.getDatabaseName());
            this.authorize(db, Privilege.DROP);
        }
        if ((descDb = work.getDescDatabaseDesc()) != null) {
            Database db = cntxt.getHive().getDatabase(descDb.getDatabaseName());
            this.authorize(db, Privilege.SELECT);
        }
        if ((switchDb = work.getSwitchDatabaseDesc()) != null) {
            Database db = cntxt.getHive().getDatabase(switchDb.getDatabaseName());
            this.authorize(db, Privilege.SELECT);
        }
        if ((showTables = work.getShowTblsDesc()) != null) {
            String dbName = showTables.getDbName() == null ? SessionState.get().getCurrentDatabase() : showTables.getDbName();
            this.authorize(cntxt.getHive().getDatabase(dbName), Privilege.SELECT);
        }
        if ((showTableStatus = work.getShowTblStatusDesc()) != null) {
            String dbName = showTableStatus.getDbName() == null ? SessionState.get().getCurrentDatabase() : showTableStatus.getDbName();
            this.authorize(cntxt.getHive().getDatabase(dbName), Privilege.SELECT);
        }
        if ((dropTable = work.getDropTblDesc()) != null && dropTable.getPartSpecs() != null) {
            for (PartitionSpec partSpec : dropTable.getPartSpecs()) {
                Table table = hive.getTable(SessionState.get().getCurrentDatabase(), dropTable.getTableName());
                List partitions = null;
                try {
                    partitions = hive.getPartitionsByFilter(table, partSpec.toString());
                }
                catch (Exception e) {
                    throw new HiveException((Throwable)e);
                }
                for (Partition part : partitions) {
                    this.authorize(part, Privilege.DROP);
                }
            }
        }
        if ((alterTable = work.getAlterTblDesc()) != null) {
            Table table = hive.getTable(SessionState.get().getCurrentDatabase(), alterTable.getOldName(), false);
            Partition part = null;
            if (alterTable.getPartSpec() != null) {
                part = hive.getPartition(table, (Map)alterTable.getPartSpec(), false);
            }
            String newLocation = alterTable.getNewLocation();
            if (alterTable.getOp() == AlterTableDesc.AlterTableTypes.ALTERLOCATION) {
                if (part != null) {
                    this.authorize(part, Privilege.ALTER_DATA);
                    part.setLocation(newLocation);
                    this.authorize(part, Privilege.ALTER_DATA);
                } else {
                    this.authorize(table, Privilege.ALTER_DATA);
                    table.getTTable().getSd().setLocation(newLocation);
                    this.authorize(table, Privilege.ALTER_DATA);
                }
            }
        }
        if ((descTable = work.getDescTblDesc()) != null) {
            String tableName = this.extractTableName(descTable.getTableName());
            this.authorizeTable(cntxt.getHive(), tableName, Privilege.SELECT);
        }
        if ((showParts = work.getShowPartsDesc()) != null) {
            String tableName = this.extractTableName(showParts.getTabName());
            this.authorizeTable(cntxt.getHive(), tableName, Privilege.SELECT);
        }
    }
}

