/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.hcatalog.common;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import java.io.IOException;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.security.auth.login.LoginException;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.HiveMetaStoreClient;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.NoSuchObjectException;
import org.apache.hadoop.hive.shims.ShimLoader;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class HiveClientCache {
    private final Cache<HiveClientCacheKey, CacheableHiveMetaStoreClient> hiveCache;
    private static final Logger LOG = LoggerFactory.getLogger(HiveClientCache.class);
    private final int timeout;
    private final Object CACHE_TEARDOWN_LOCK = new Object();
    private static final AtomicInteger nextId = new AtomicInteger(0);
    private static final ThreadLocal<Integer> threadId = new ThreadLocal<Integer>(){

        @Override
        protected Integer initialValue() {
            return nextId.getAndIncrement();
        }
    };

    private int getThreadId() {
        return threadId.get();
    }

    public HiveClientCache(int timeout) {
        this.timeout = timeout;
        RemovalListener<HiveClientCacheKey, CacheableHiveMetaStoreClient> removalListener = new RemovalListener<HiveClientCacheKey, CacheableHiveMetaStoreClient>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onRemoval(RemovalNotification<HiveClientCacheKey, CacheableHiveMetaStoreClient> notification) {
                CacheableHiveMetaStoreClient hiveMetaStoreClient = (CacheableHiveMetaStoreClient)((Object)notification.getValue());
                if (hiveMetaStoreClient != null) {
                    Object object = HiveClientCache.this.CACHE_TEARDOWN_LOCK;
                    synchronized (object) {
                        hiveMetaStoreClient.setExpiredFromCache();
                        hiveMetaStoreClient.tearDownIfUnused();
                    }
                }
            }
        };
        this.hiveCache = CacheBuilder.newBuilder().expireAfterWrite((long)timeout, TimeUnit.SECONDS).removalListener((RemovalListener)removalListener).build();
        Thread cleanupHiveClientShutdownThread = new Thread(){

            @Override
            public void run() {
                LOG.debug("Cleaning up hive client cache in ShutDown hook");
                HiveClientCache.this.closeAllClientsQuietly();
            }
        };
        Runtime.getRuntime().addShutdownHook(cleanupHiveClientShutdownThread);
    }

    void closeAllClientsQuietly() {
        try {
            ConcurrentMap elements = this.hiveCache.asMap();
            for (CacheableHiveMetaStoreClient cacheableHiveMetaStoreClient : elements.values()) {
                cacheableHiveMetaStoreClient.tearDown();
            }
        }
        catch (Exception e) {
            LOG.warn("Clean up of hive clients in the cache failed. Ignored", (Throwable)e);
        }
    }

    public void cleanup() {
        this.hiveCache.cleanUp();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HiveMetaStoreClient get(HiveConf hiveConf) throws MetaException, IOException, LoginException {
        HiveClientCacheKey cacheKey = HiveClientCacheKey.fromHiveConf(hiveConf, this.getThreadId());
        CacheableHiveMetaStoreClient hiveMetaStoreClient = null;
        Object object = this.CACHE_TEARDOWN_LOCK;
        synchronized (object) {
            hiveMetaStoreClient = this.getOrCreate(cacheKey);
            hiveMetaStoreClient.acquire();
        }
        if (!hiveMetaStoreClient.isOpen()) {
            object = this.CACHE_TEARDOWN_LOCK;
            synchronized (object) {
                this.hiveCache.invalidate((Object)cacheKey);
                hiveMetaStoreClient.close();
                hiveMetaStoreClient = this.getOrCreate(cacheKey);
                hiveMetaStoreClient.acquire();
            }
        }
        return hiveMetaStoreClient;
    }

    private CacheableHiveMetaStoreClient getOrCreate(final HiveClientCacheKey cacheKey) throws IOException, MetaException, LoginException {
        try {
            return (CacheableHiveMetaStoreClient)((Object)this.hiveCache.get((Object)cacheKey, (Callable)new Callable<CacheableHiveMetaStoreClient>(){

                @Override
                public CacheableHiveMetaStoreClient call() throws MetaException {
                    return new CacheableHiveMetaStoreClient(cacheKey.getHiveConf(), HiveClientCache.this.timeout);
                }
            }));
        }
        catch (ExecutionException e) {
            Throwable t = e.getCause();
            if (t instanceof IOException) {
                throw (IOException)t;
            }
            if (t instanceof MetaException) {
                throw (MetaException)t;
            }
            if (t instanceof LoginException) {
                throw (LoginException)t;
            }
            throw new IOException("Error creating hiveMetaStoreClient", t);
        }
    }

    public static class CacheableHiveMetaStoreClient
    extends HiveMetaStoreClient {
        private AtomicInteger users = new AtomicInteger(0);
        private volatile boolean expiredFromCache = false;
        private boolean isClosed = false;
        private final long expiryTime;
        private static final int EXPIRY_TIME_EXTENSION_IN_MILLIS = 60000;

        public CacheableHiveMetaStoreClient(HiveConf conf, int timeout) throws MetaException {
            super(conf);
            this.expiryTime = System.currentTimeMillis() + (long)(timeout * 1000) + 60000L;
        }

        private void acquire() {
            this.users.incrementAndGet();
        }

        private void release() {
            this.users.decrementAndGet();
        }

        public void setExpiredFromCache() {
            this.expiredFromCache = true;
        }

        public boolean isClosed() {
            return this.isClosed;
        }

        protected boolean isOpen() {
            try {
                this.getDatabase("NonExistentDatabaseUsedForHealthCheck");
            }
            catch (NoSuchObjectException e) {
                return true;
            }
            catch (MetaException e) {
                return false;
            }
            catch (TException e) {
                return false;
            }
            return true;
        }

        public void close() {
            this.release();
            if (System.currentTimeMillis() >= this.expiryTime) {
                this.setExpiredFromCache();
            }
            this.tearDownIfUnused();
        }

        private void tearDownIfUnused() {
            if (this.users.get() == 0 && this.expiredFromCache) {
                this.tearDown();
            }
        }

        protected synchronized void tearDown() {
            try {
                if (!this.isClosed) {
                    super.close();
                }
                this.isClosed = true;
            }
            catch (Exception e) {
                LOG.warn("Error closing hive metastore client. Ignored.", (Throwable)e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void finalize() throws Throwable {
            try {
                this.tearDown();
            }
            finally {
                super.finalize();
            }
        }
    }

    public static class HiveClientCacheKey {
        private final String metaStoreURIs;
        private final UserGroupInformation ugi;
        private final HiveConf hiveConf;
        private final int threadId;

        private HiveClientCacheKey(HiveConf hiveConf, int threadId) throws IOException, LoginException {
            this.metaStoreURIs = hiveConf.getVar(HiveConf.ConfVars.METASTOREURIS);
            this.ugi = ShimLoader.getHadoopShims().getUGIForConf((Configuration)hiveConf);
            this.hiveConf = hiveConf;
            this.threadId = threadId;
        }

        public static HiveClientCacheKey fromHiveConf(HiveConf hiveConf, int threadId) throws IOException, LoginException {
            return new HiveClientCacheKey(hiveConf, threadId);
        }

        public HiveConf getHiveConf() {
            return this.hiveConf;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            HiveClientCacheKey that = (HiveClientCacheKey)o;
            return new EqualsBuilder().append((Object)this.metaStoreURIs, (Object)that.metaStoreURIs).append((Object)this.ugi, (Object)that.ugi).append(this.threadId, that.threadId).isEquals();
        }

        public int hashCode() {
            return new HashCodeBuilder().append((Object)this.metaStoreURIs).append((Object)this.ugi).append(this.threadId).toHashCode();
        }
    }
}

