/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.hcatalog.mapreduce;

import java.io.Serializable;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.hive.hcatalog.data.schema.HCatSchema;
import org.apache.hive.hcatalog.mapreduce.HCatTableInfo;

public class OutputJobInfo
implements Serializable {
    private final String databaseName;
    private final String tableName;
    private static final long serialVersionUID = 1L;
    private HCatTableInfo tableInfo;
    private HCatSchema outputSchema;
    private String location;
    private Map<String, String> partitionValues;
    private List<Integer> posOfPartCols;
    private List<Integer> posOfDynPartCols;
    private Properties properties;
    private int maxDynamicPartitions;
    private List<String> dynamicPartitioningKeys;
    private boolean harRequested;

    public static OutputJobInfo create(String databaseName, String tableName, Map<String, String> partitionValues) {
        return new OutputJobInfo(databaseName, tableName, partitionValues);
    }

    private OutputJobInfo(String databaseName, String tableName, Map<String, String> partitionValues) {
        this.databaseName = databaseName == null ? "default" : databaseName;
        this.tableName = tableName;
        this.partitionValues = partitionValues;
        this.properties = new Properties();
    }

    protected List<Integer> getPosOfPartCols() {
        return this.posOfPartCols;
    }

    protected List<Integer> getPosOfDynPartCols() {
        return this.posOfDynPartCols;
    }

    protected void setPosOfPartCols(List<Integer> posOfPartCols) {
        Collections.sort(posOfPartCols, new Comparator<Integer>(){

            @Override
            public int compare(Integer earlier, Integer later) {
                return earlier > later ? -1 : (earlier == later ? 0 : 1);
            }
        });
        this.posOfPartCols = posOfPartCols;
    }

    protected void setPosOfDynPartCols(List<Integer> posOfDynPartCols) {
        this.posOfDynPartCols = posOfDynPartCols;
    }

    public HCatTableInfo getTableInfo() {
        return this.tableInfo;
    }

    public HCatSchema getOutputSchema() {
        return this.outputSchema;
    }

    public void setOutputSchema(HCatSchema schema) {
        this.outputSchema = schema;
    }

    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    void setPartitionValues(Map<String, String> partitionValues) {
        this.partitionValues = partitionValues;
    }

    public Map<String, String> getPartitionValues() {
        return this.partitionValues;
    }

    void setTableInfo(HCatTableInfo tableInfo) {
        this.tableInfo = tableInfo;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public void setMaximumDynamicPartitions(int maxDynamicPartitions) {
        this.maxDynamicPartitions = maxDynamicPartitions;
    }

    public int getMaxDynamicPartitions() {
        return this.maxDynamicPartitions;
    }

    public void setHarRequested(boolean harRequested) {
        this.harRequested = harRequested;
    }

    public boolean getHarRequested() {
        return this.harRequested;
    }

    public boolean isDynamicPartitioningUsed() {
        return this.dynamicPartitioningKeys != null && !this.dynamicPartitioningKeys.isEmpty();
    }

    public void setDynamicPartitioningKeys(List<String> dynamicPartitioningKeys) {
        this.dynamicPartitioningKeys = dynamicPartitioningKeys;
    }

    public List<String> getDynamicPartitioningKeys() {
        return this.dynamicPartitioningKeys;
    }
}

