/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.query.symbol;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.query.symbol.Symbol;
import org.datanucleus.query.symbol.SymbolResolver;
import org.datanucleus.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SymbolTable
implements Serializable {
    SymbolTable parentSymbolTable = null;
    Map<String, Symbol> symbols = new HashMap<String, Symbol>();
    List<Symbol> symbolsTable = new ArrayList<Symbol>();
    transient SymbolResolver resolver;

    public void setSymbolResolver(SymbolResolver resolver) {
        this.resolver = resolver;
    }

    public SymbolResolver getSymbolResolver() {
        return this.resolver;
    }

    public void setParentSymbolTable(SymbolTable tbl) {
        this.parentSymbolTable = tbl;
    }

    public SymbolTable getParentSymbolTable() {
        return this.parentSymbolTable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Symbol getSymbol(int index) {
        List<Symbol> list = this.symbolsTable;
        synchronized (list) {
            return this.symbolsTable.get(index);
        }
    }

    public Collection<String> getSymbolNames() {
        return new HashSet<String>(this.symbols.keySet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Symbol getSymbol(String name) {
        List<Symbol> list = this.symbolsTable;
        synchronized (list) {
            return this.symbols.get(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Symbol getSymbolIgnoreCase(String name) {
        List<Symbol> list = this.symbolsTable;
        synchronized (list) {
            for (String key : this.symbols.keySet()) {
                if (!key.equalsIgnoreCase(name)) continue;
                return this.symbols.get(key);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasSymbol(String name) {
        List<Symbol> list = this.symbolsTable;
        synchronized (list) {
            return this.symbols.containsKey(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int addSymbol(Symbol symbol) {
        List<Symbol> list = this.symbolsTable;
        synchronized (list) {
            if (this.symbols.containsKey(symbol.getQualifiedName())) {
                throw new NucleusException("Symbol " + symbol.getQualifiedName() + " already exists.");
            }
            this.symbols.put(symbol.getQualifiedName(), symbol);
            this.symbolsTable.add(symbol);
            return this.symbolsTable.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSymbol(Symbol symbol) {
        List<Symbol> list = this.symbolsTable;
        synchronized (list) {
            if (!this.symbols.containsKey(symbol.getQualifiedName())) {
                throw new NucleusException("Symbol " + symbol.getQualifiedName() + " doesnt exist.");
            }
            this.symbols.remove(symbol.getQualifiedName());
            this.symbolsTable.remove(symbol);
        }
    }

    public String toString() {
        return "SymbolTable : " + StringUtils.mapToString(this.symbols);
    }
}

