/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec;

import java.io.Serializable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.LimitDesc;
import org.apache.hadoop.hive.ql.plan.api.OperatorType;

public class LimitOperator
extends Operator<LimitDesc>
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected transient int limit;
    protected transient int leastRow;
    protected transient int currCount;
    protected transient boolean isMap;

    @Override
    protected void initializeOp(Configuration hconf) throws HiveException {
        super.initializeOp(hconf);
        this.limit = ((LimitDesc)this.conf).getLimit();
        this.leastRow = ((LimitDesc)this.conf).getLeastRows();
        this.currCount = 0;
        this.isMap = hconf.getBoolean("mapred.task.is.map", true);
    }

    @Override
    public void processOp(Object row, int tag) throws HiveException {
        if (this.currCount < this.limit) {
            this.forward(row, this.inputObjInspectors[tag]);
            ++this.currCount;
        } else {
            this.setDone(true);
        }
    }

    @Override
    public String getName() {
        return LimitOperator.getOperatorName();
    }

    public static String getOperatorName() {
        return "LIM";
    }

    @Override
    public OperatorType getType() {
        return OperatorType.LIMIT;
    }

    @Override
    public void closeOp(boolean abort) throws HiveException {
        if (!this.isMap && this.currCount < this.leastRow) {
            throw new HiveException("No sufficient row found");
        }
    }
}

