/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.plan;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hive.ql.exec.FunctionRegistry;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeFieldDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;

public class ExprNodeDescUtils {
    public static int indexOf(ExprNodeDesc origin, List<ExprNodeDesc> sources) {
        for (int i = 0; i < sources.size(); ++i) {
            if (!origin.isSame(sources.get(i))) continue;
            return i;
        }
        return -1;
    }

    public static ExprNodeDesc replace(ExprNodeDesc origin, List<ExprNodeDesc> sources, List<ExprNodeDesc> targets) {
        int index = ExprNodeDescUtils.indexOf(origin, sources);
        if (index >= 0) {
            return targets.get(index);
        }
        if (origin instanceof ExprNodeColumnDesc || origin instanceof ExprNodeFieldDesc) {
            return null;
        }
        if (origin instanceof ExprNodeGenericFuncDesc) {
            ExprNodeGenericFuncDesc func = (ExprNodeGenericFuncDesc)origin;
            if (!FunctionRegistry.isDeterministic(func.getGenericUDF()) || FunctionRegistry.isStateful(func.getGenericUDF())) {
                return null;
            }
            ArrayList<ExprNodeDesc> children = new ArrayList<ExprNodeDesc>();
            for (int i = 0; i < origin.getChildren().size(); ++i) {
                ExprNodeDesc child = ExprNodeDescUtils.replace(origin.getChildren().get(i), sources, targets);
                if (child == null) {
                    return null;
                }
                children.add(child);
            }
            ExprNodeGenericFuncDesc clone = (ExprNodeGenericFuncDesc)func.clone();
            clone.setChildExprs(children);
            return clone;
        }
        return origin;
    }

    public static boolean containsPredicate(ExprNodeDesc source, ExprNodeDesc predicate) {
        if (source.isSame(predicate)) {
            return true;
        }
        return FunctionRegistry.isOpAnd(source) && (ExprNodeDescUtils.containsPredicate(source.getChildren().get(0), predicate) || ExprNodeDescUtils.containsPredicate(source.getChildren().get(1), predicate));
    }

    public static ExprNodeDesc mergePredicates(ExprNodeDesc prev, ExprNodeDesc next) {
        ArrayList<ExprNodeDesc> children = new ArrayList<ExprNodeDesc>(2);
        children.add(prev);
        children.add(next);
        return new ExprNodeGenericFuncDesc(TypeInfoFactory.booleanTypeInfo, FunctionRegistry.getGenericUDFForAnd(), children);
    }

    public static ExprNodeDesc mergePredicates(List<ExprNodeDesc> exprs) {
        ExprNodeDesc prev = null;
        for (ExprNodeDesc expr : exprs) {
            if (prev == null) {
                prev = expr;
                continue;
            }
            prev = ExprNodeDescUtils.mergePredicates(prev, expr);
        }
        return prev;
    }

    public static List<ExprNodeDesc> split(ExprNodeDesc current) {
        return ExprNodeDescUtils.split(current, new ArrayList<ExprNodeDesc>());
    }

    public static List<ExprNodeDesc> split(ExprNodeDesc current, List<ExprNodeDesc> splitted) {
        if (FunctionRegistry.isOpAnd(current)) {
            for (ExprNodeDesc child : current.getChildren()) {
                ExprNodeDescUtils.split(child, splitted);
            }
            return splitted;
        }
        if (ExprNodeDescUtils.indexOf(current, splitted) < 0) {
            splitted.add(current);
        }
        return splitted;
    }

    public static String recommendInputName(ExprNodeDesc desc) {
        if (desc instanceof ExprNodeColumnDesc) {
            return ((ExprNodeColumnDesc)desc).getColumn();
        }
        List<ExprNodeDesc> children = desc.getChildren();
        if (FunctionRegistry.isOpPreserveInputName(desc) && !children.isEmpty() && children.get(0) instanceof ExprNodeColumnDesc) {
            return ((ExprNodeColumnDesc)children.get(0)).getColumn();
        }
        return null;
    }

    public static boolean isDeterministic(ExprNodeDesc desc) {
        if (desc instanceof ExprNodeGenericFuncDesc && !FunctionRegistry.isDeterministic(((ExprNodeGenericFuncDesc)desc).getGenericUDF())) {
            return false;
        }
        if (desc.getChildren() != null) {
            for (ExprNodeDesc child : desc.getChildren()) {
                if (ExprNodeDescUtils.isDeterministic(child)) continue;
                return false;
            }
        }
        return true;
    }

    public static ArrayList<ExprNodeDesc> backtrack(List<ExprNodeDesc> sources, Operator<?> current, Operator<?> terminal) throws SemanticException {
        ArrayList<ExprNodeDesc> result = new ArrayList<ExprNodeDesc>();
        for (ExprNodeDesc expr : sources) {
            result.add(ExprNodeDescUtils.backtrack(expr, current, terminal));
        }
        return result;
    }

    public static ExprNodeDesc backtrack(ExprNodeDesc source, Operator<?> current, Operator<?> terminal) throws SemanticException {
        Operator<?> parent = ExprNodeDescUtils.getSingleParent(current, terminal);
        if (parent == null) {
            return source;
        }
        if (source instanceof ExprNodeGenericFuncDesc) {
            ExprNodeGenericFuncDesc function = (ExprNodeGenericFuncDesc)source.clone();
            function.setChildExprs(ExprNodeDescUtils.backtrack(function.getChildren(), current, terminal));
            return function;
        }
        if (source instanceof ExprNodeColumnDesc) {
            ExprNodeColumnDesc column = (ExprNodeColumnDesc)source;
            return ExprNodeDescUtils.backtrack(column, parent, terminal);
        }
        if (source instanceof ExprNodeFieldDesc) {
            ExprNodeFieldDesc field = (ExprNodeFieldDesc)source.clone();
            field.setDesc(ExprNodeDescUtils.backtrack(field.getDesc(), current, terminal));
            return field;
        }
        return source;
    }

    private static ExprNodeDesc backtrack(ExprNodeColumnDesc column, Operator<?> current, Operator<?> terminal) throws SemanticException {
        Map<String, ExprNodeDesc> mapping = current.getColumnExprMap();
        if (mapping == null || !mapping.containsKey(column.getColumn())) {
            return ExprNodeDescUtils.backtrack((ExprNodeDesc)column, current, terminal);
        }
        ExprNodeDesc mapped = mapping.get(column.getColumn());
        return ExprNodeDescUtils.backtrack(mapped, current, terminal);
    }

    public static Operator<?> getSingleParent(Operator<?> current, Operator<?> terminal) throws SemanticException {
        if (current == terminal) {
            return null;
        }
        List<Operator<OperatorDesc>> parents = current.getParentOperators();
        if (parents == null || parents.isEmpty()) {
            if (terminal != null) {
                throw new SemanticException("Failed to meet terminal operator");
            }
            return null;
        }
        if (parents.size() == 1) {
            return parents.get(0);
        }
        if (terminal != null && parents.contains(terminal)) {
            return terminal;
        }
        throw new SemanticException("Met multiple parent operators");
    }
}

