/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentLengthException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentTypeException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.serde2.objectinspector.ConstantObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.BinaryObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.StringObjectInspector;
import org.apache.hadoop.io.Text;

@Description(name="decode", value="_FUNC_(bin, str) - Decode the first argument using the second argument character set", extended="Possible options for the character set are 'US_ASCII', 'ISO-8859-1',\n'UTF-8', 'UTF-16BE', 'UTF-16LE', and 'UTF-16'. If either argument\nis null, the result will also be null")
public class GenericUDFDecode
extends GenericUDF {
    private transient CharsetDecoder decoder = null;
    private transient BinaryObjectInspector bytesOI = null;
    private transient StringObjectInspector charsetOI = null;

    @Override
    public ObjectInspector initialize(ObjectInspector[] arguments) throws UDFArgumentException {
        if (arguments.length != 2) {
            throw new UDFArgumentLengthException("Encode() requires exactly two arguments");
        }
        if (arguments[0].getCategory() != ObjectInspector.Category.PRIMITIVE || ((PrimitiveObjectInspector)arguments[0]).getPrimitiveCategory() != PrimitiveObjectInspector.PrimitiveCategory.BINARY) {
            throw new UDFArgumentTypeException(0, "The first argument to Encode() must be a binary");
        }
        this.bytesOI = (BinaryObjectInspector)arguments[0];
        if (arguments[1].getCategory() != ObjectInspector.Category.PRIMITIVE || ((PrimitiveObjectInspector)arguments[1]).getPrimitiveCategory() != PrimitiveObjectInspector.PrimitiveCategory.STRING) {
            throw new UDFArgumentTypeException(1, "The second argument to Encode() must be a string");
        }
        this.charsetOI = (StringObjectInspector)arguments[1];
        StringObjectInspector charSetOI = (StringObjectInspector)arguments[1];
        if (charSetOI instanceof ConstantObjectInspector) {
            String charSetName = ((Text)((ConstantObjectInspector)((Object)charSetOI)).getWritableConstantValue()).toString();
            this.decoder = Charset.forName(charSetName).newDecoder().onMalformedInput(CodingErrorAction.REPORT).onUnmappableCharacter(CodingErrorAction.REPORT);
        }
        return PrimitiveObjectInspectorFactory.javaStringObjectInspector;
    }

    @Override
    public Object evaluate(GenericUDF.DeferredObject[] arguments) throws HiveException {
        CharBuffer decoded;
        byte[] value = this.bytesOI.getPrimitiveJavaObject(arguments[0].get());
        if (value == null) {
            return null;
        }
        ByteBuffer wrappedBytes = ByteBuffer.wrap(value);
        if (this.decoder != null) {
            try {
                decoded = this.decoder.decode(wrappedBytes);
            }
            catch (CharacterCodingException e) {
                throw new HiveException(e);
            }
        } else {
            decoded = Charset.forName(this.charsetOI.getPrimitiveJavaObject(arguments[1].get())).decode(wrappedBytes);
        }
        return decoded.toString();
    }

    @Override
    public String getDisplayString(String[] children) {
        assert (children.length == 2);
        StringBuilder sb = new StringBuilder();
        sb.append("encode(");
        sb.append(children[0]).append(",");
        sb.append(children[1]).append(")");
        return sb.toString();
    }
}

