/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDF;
import org.apache.hadoop.hive.serde2.io.DateWritable;
import org.apache.hadoop.hive.serde2.io.TimestampWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.Text;

@Description(name="month", value="_FUNC_(date) - Returns the month of date", extended="Example:\n  > SELECT _FUNC_('2009-30-07') FROM src LIMIT 1;\n  7")
public class UDFMonth
extends UDF {
    private final SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
    private final Calendar calendar = Calendar.getInstance();
    private IntWritable result = new IntWritable();

    public IntWritable evaluate(Text dateString) {
        if (dateString == null) {
            return null;
        }
        try {
            Date date = this.formatter.parse(dateString.toString());
            this.calendar.setTime(date);
            this.result.set(1 + this.calendar.get(2));
            return this.result;
        }
        catch (ParseException e) {
            return null;
        }
    }

    public IntWritable evaluate(DateWritable d) {
        if (d == null) {
            return null;
        }
        this.calendar.setTime(d.get());
        this.result.set(1 + this.calendar.get(2));
        return this.result;
    }

    public IntWritable evaluate(TimestampWritable t) {
        if (t == null) {
            return null;
        }
        this.calendar.setTime(t.getTimestamp());
        this.result.set(1 + this.calendar.get(2));
        return this.result;
    }
}

