/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import java.io.Serializable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.SettableUDF;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorConverter;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.SettableHiveVarcharObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.VarcharTypeParams;

@Description(name="varchar", value="CAST(<value> as VARCHAR(length)) - Converts the argument to a varchar value.", extended="Values will be truncated if the input value is too long to fit within the varchar length.Example:\n   > SELECT CAST(1234 AS varchar(10)) FROM src LIMIT 1;\n  '1234'")
public class GenericUDFToVarchar
extends GenericUDF
implements SettableUDF,
Serializable {
    private static final Log LOG = LogFactory.getLog((String)GenericUDFToVarchar.class.getName());
    private transient PrimitiveObjectInspector argumentOI;
    private transient PrimitiveObjectInspectorConverter.HiveVarcharConverter converter;
    private VarcharTypeParams typeParams;

    @Override
    public ObjectInspector initialize(ObjectInspector[] arguments) throws UDFArgumentException {
        if (arguments.length != 1) {
            throw new UDFArgumentException("VARCHAR cast requires a value argument");
        }
        try {
            this.argumentOI = (PrimitiveObjectInspector)arguments[0];
        }
        catch (ClassCastException e) {
            throw new UDFArgumentException("The function VARCHAR takes only primitive types");
        }
        SettableHiveVarcharObjectInspector outputOI = this.typeParams != null ? (SettableHiveVarcharObjectInspector)((Object)PrimitiveObjectInspectorFactory.getPrimitiveWritableObjectInspector(PrimitiveObjectInspectorUtils.getTypeEntryFromTypeSpecs(PrimitiveObjectInspector.PrimitiveCategory.VARCHAR, this.typeParams))) : PrimitiveObjectInspectorFactory.writableHiveVarcharObjectInspector;
        this.converter = new PrimitiveObjectInspectorConverter.HiveVarcharConverter(this.argumentOI, outputOI);
        return outputOI;
    }

    @Override
    public Object evaluate(GenericUDF.DeferredObject[] arguments) throws HiveException {
        Object o0 = arguments[0].get();
        if (o0 == null) {
            return null;
        }
        return this.converter.convert(o0);
    }

    @Override
    public String getDisplayString(String[] children) {
        assert (children.length == 1);
        StringBuilder sb = new StringBuilder();
        sb.append("CAST( ");
        sb.append(children[0]);
        sb.append(" AS VARCHAR(");
        String paramsStr = "";
        if (this.typeParams != null) {
            paramsStr = this.typeParams.toString();
        }
        sb.append(paramsStr);
        sb.append(")");
        return sb.toString();
    }

    @Override
    public void setParams(Object typeParams) throws UDFArgumentException {
        if (this.converter != null) {
            LOG.warn((Object)"Type converter already initialized, setting type params now will not be useful");
        }
        if (!(typeParams instanceof VarcharTypeParams)) {
            throw new UDFArgumentException("Was expecting VarcharTypeParams, instead got " + typeParams.getClass().getName());
        }
        this.typeParams = (VarcharTypeParams)typeParams;
    }

    @Override
    public Object getParams() {
        return this.typeParams;
    }
}

