/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.serde2.io;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.hive.common.type.HiveBaseChar;
import org.apache.hadoop.hive.common.type.HiveVarchar;
import org.apache.hadoop.hive.shims.ShimLoader;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.WritableComparable;

public class HiveVarcharWritable
implements WritableComparable<HiveVarcharWritable> {
    protected Text value = new Text();
    protected transient int characterLength = -1;

    public HiveVarcharWritable() {
    }

    public HiveVarcharWritable(HiveVarchar hc) {
        this.set(hc);
    }

    public HiveVarcharWritable(HiveVarcharWritable hcw) {
        this.set(hcw);
    }

    public void set(HiveVarchar val) {
        this.set(val.getValue());
    }

    public void set(String val) {
        this.set(val, -1);
    }

    public void set(HiveVarcharWritable val) {
        this.value.set(val.value);
        this.characterLength = val.characterLength;
    }

    public void set(HiveVarcharWritable val, int maxLength) {
        if (val.characterLength > 0 && val.characterLength >= maxLength) {
            this.set(val);
        } else {
            this.set(val.getHiveVarchar(), maxLength);
        }
    }

    public void set(HiveVarchar val, int len) {
        this.set(val.getValue(), len);
    }

    public void set(String val, int maxLength) {
        this.characterLength = -1;
        this.value.set(HiveBaseChar.enforceMaxLength(val, maxLength));
    }

    public HiveVarchar getHiveVarchar() {
        return new HiveVarchar(this.value.toString(), -1);
    }

    public int getCharacterLength() {
        if (this.characterLength < 0) {
            this.characterLength = this.getHiveVarchar().getCharacterLength();
        }
        return this.characterLength;
    }

    public void enforceMaxLength(int maxLength) {
        this.set(this.getHiveVarchar(), maxLength);
    }

    public void readFields(DataInput in) throws IOException {
        this.characterLength = -1;
        this.value.readFields(in);
    }

    public void write(DataOutput out) throws IOException {
        this.value.write(out);
    }

    public int compareTo(HiveVarcharWritable rhs) {
        return ShimLoader.getHadoopShims().compareText(this.value, rhs.value);
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof HiveVarcharWritable)) {
            return false;
        }
        return this.value.equals((Object)((HiveVarcharWritable)obj).value);
    }

    public String toString() {
        return this.value.toString();
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public Text getTextValue() {
        return this.value;
    }
}

