/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.serde2.typeinfo;

import java.io.Serializable;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.typeinfo.BaseTypeParams;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeSpec;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;

public class PrimitiveTypeInfo
extends TypeInfo
implements Serializable,
PrimitiveTypeSpec {
    private static final long serialVersionUID = 1L;
    protected String typeName;
    protected BaseTypeParams typeParams;

    public PrimitiveTypeInfo() {
    }

    PrimitiveTypeInfo(String typeName) {
        this.typeName = typeName;
    }

    @Override
    public ObjectInspector.Category getCategory() {
        return ObjectInspector.Category.PRIMITIVE;
    }

    @Override
    public PrimitiveObjectInspector.PrimitiveCategory getPrimitiveCategory() {
        return this.getPrimitiveTypeEntry().primitiveCategory;
    }

    public Class<?> getPrimitiveWritableClass() {
        return PrimitiveObjectInspectorUtils.getTypeEntryFromTypeName((String)this.typeName).primitiveWritableClass;
    }

    public Class<?> getPrimitiveJavaClass() {
        return PrimitiveObjectInspectorUtils.getTypeEntryFromTypeName((String)this.typeName).primitiveJavaClass;
    }

    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    @Override
    public String getTypeName() {
        return this.typeName;
    }

    @Override
    public BaseTypeParams getTypeParams() {
        return this.typeParams;
    }

    public void setTypeParams(BaseTypeParams typeParams) {
        this.typeParams = typeParams;
    }

    public PrimitiveObjectInspectorUtils.PrimitiveTypeEntry getPrimitiveTypeEntry() {
        return PrimitiveObjectInspectorUtils.getTypeEntryFromTypeName(TypeInfoUtils.getBaseName(this.typeName));
    }

    @Override
    public boolean equals(Object other) {
        return this == other;
    }

    @Override
    public int hashCode() {
        return this.typeName.hashCode();
    }

    @Override
    public String toString() {
        return this.typeName;
    }
}

