/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.beeline;

import java.io.IOException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.LinkedList;
import java.util.TreeSet;
import jline.ArgumentCompletor;
import jline.Completor;
import org.apache.hive.beeline.BeeLine;
import org.apache.hive.beeline.SQLCompletor;

class DatabaseConnection {
    private final BeeLine beeLine;
    private Connection connection;
    private DatabaseMetaData meta;
    private final String driver;
    private final String url;
    private final String username;
    private final String password;
    private Schema schema = null;
    private Completor sqlCompletor = null;

    public DatabaseConnection(BeeLine beeLine, String driver, String url, String username, String password) throws SQLException {
        this.beeLine = beeLine;
        this.driver = driver;
        this.url = url;
        this.username = username;
        this.password = password;
    }

    public String toString() {
        return this.getUrl() + "";
    }

    void setCompletions(boolean skipmeta) throws SQLException, IOException {
        final String extraNameCharacters = this.getDatabaseMetaData() == null || this.getDatabaseMetaData().getExtraNameCharacters() == null ? "" : this.getDatabaseMetaData().getExtraNameCharacters();
        this.sqlCompletor = new ArgumentCompletor((Completor)new SQLCompletor(this.beeLine, skipmeta), (ArgumentCompletor.ArgumentDelimiter)new ArgumentCompletor.AbstractArgumentDelimiter(){

            public boolean isDelimiterChar(String buf, int pos) {
                char c = buf.charAt(pos);
                if (Character.isWhitespace(c)) {
                    return true;
                }
                return !Character.isLetterOrDigit(c) && c != '_' && extraNameCharacters.indexOf(c) == -1;
            }
        });
        ((ArgumentCompletor)this.sqlCompletor).setStrict(false);
    }

    boolean connect() throws SQLException {
        try {
            if (this.driver != null && this.driver.length() != 0) {
                Class.forName(this.driver);
            }
        }
        catch (ClassNotFoundException cnfe) {
            return this.beeLine.error(cnfe);
        }
        boolean foundDriver = false;
        try {
            foundDriver = DriverManager.getDriver(this.getUrl()) != null;
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.close();
        }
        catch (Exception e) {
            return this.beeLine.error(e);
        }
        this.setConnection(DriverManager.getConnection(this.getUrl(), this.username, this.password));
        this.setDatabaseMetaData(this.getConnection().getMetaData());
        try {
            this.beeLine.info(this.beeLine.loc("connected", new Object[]{this.getDatabaseMetaData().getDatabaseProductName(), this.getDatabaseMetaData().getDatabaseProductVersion()}));
        }
        catch (Exception e) {
            this.beeLine.handleException(e);
        }
        try {
            this.beeLine.info(this.beeLine.loc("driver", new Object[]{this.getDatabaseMetaData().getDriverName(), this.getDatabaseMetaData().getDriverVersion()}));
        }
        catch (Exception e) {
            this.beeLine.handleException(e);
        }
        try {
            this.getConnection().setAutoCommit(this.beeLine.getOpts().getAutoCommit());
        }
        catch (Exception e) {
            this.beeLine.handleException(e);
        }
        try {
            this.beeLine.getCommands().isolation("isolation: " + this.beeLine.getOpts().getIsolation());
        }
        catch (Exception e) {
            this.beeLine.handleException(e);
        }
        return true;
    }

    public Connection getConnection() throws SQLException {
        if (this.connection != null) {
            return this.connection;
        }
        this.connect();
        return this.connection;
    }

    public void reconnect() throws Exception {
        this.close();
        this.getConnection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        try {
            try {
                if (this.connection != null && !this.connection.isClosed()) {
                    this.beeLine.output(this.beeLine.loc("closing", this.connection));
                    this.connection.close();
                }
            }
            catch (Exception e) {
                this.beeLine.handleException(e);
            }
        }
        finally {
            this.setConnection(null);
            this.setDatabaseMetaData(null);
        }
    }

    public String[] getTableNames(boolean force) {
        Schema.Table[] t = this.getSchema().getTables();
        TreeSet<String> names = new TreeSet<String>();
        for (int i = 0; t != null && i < t.length; ++i) {
            names.add(t[i].getName());
        }
        return names.toArray(new String[names.size()]);
    }

    Schema getSchema() {
        if (this.schema == null) {
            this.schema = new Schema();
        }
        return this.schema;
    }

    void setConnection(Connection connection) {
        this.connection = connection;
    }

    DatabaseMetaData getDatabaseMetaData() {
        return this.meta;
    }

    void setDatabaseMetaData(DatabaseMetaData meta) {
        this.meta = meta;
    }

    String getUrl() {
        return this.url;
    }

    Completor getSQLCompletor() {
        return this.sqlCompletor;
    }

    class Schema {
        private Table[] tables = null;

        Schema() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Table[] getTables() {
            if (this.tables != null) {
                return this.tables;
            }
            LinkedList<Table> tnames = new LinkedList<Table>();
            try {
                ResultSet rs = DatabaseConnection.this.getDatabaseMetaData().getTables(DatabaseConnection.this.getConnection().getCatalog(), null, "%", new String[]{"TABLE"});
                try {
                    while (rs.next()) {
                        tnames.add(new Table(rs.getString("TABLE_NAME")));
                    }
                }
                finally {
                    try {
                        rs.close();
                    }
                    catch (Exception exception) {}
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.tables = tnames.toArray(new Table[0]);
            return this.tables;
        }

        Table getTable(String name) {
            Table[] t = this.getTables();
            for (int i = 0; t != null && i < t.length; ++i) {
                if (!name.equalsIgnoreCase(t[i].getName())) continue;
                return t[i];
            }
            return null;
        }

        class Table {
            final String name;
            Column[] columns;

            public Table(String name) {
                this.name = name;
            }

            public String getName() {
                return this.name;
            }

            class Column {
                final String name;
                boolean isPrimaryKey;

                public Column(String name) {
                    this.name = name;
                }
            }
        }
    }
}

