/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server.quorum;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.util.LinkedList;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.jute.BinaryInputArchive;
import org.apache.jute.BinaryOutputArchive;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.server.ByteBufferInputStream;
import org.apache.zookeeper.server.Request;
import org.apache.zookeeper.server.ZooTrace;
import org.apache.zookeeper.server.quorum.Leader;
import org.apache.zookeeper.server.quorum.LeaderZooKeeperServer;
import org.apache.zookeeper.server.quorum.LearnerInfo;
import org.apache.zookeeper.server.quorum.LearnerSyncRequest;
import org.apache.zookeeper.server.quorum.QuorumPacket;
import org.apache.zookeeper.server.quorum.QuorumPeer;
import org.apache.zookeeper.server.quorum.StateSummary;
import org.apache.zookeeper.server.util.ZxidUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LearnerHandler
extends Thread {
    private static final Logger LOG = LoggerFactory.getLogger(LearnerHandler.class);
    protected final Socket sock;
    final Leader leader;
    long tickOfLastAck;
    protected long sid = 0L;
    protected int version = 1;
    final LinkedBlockingQueue<QuorumPacket> queuedPackets = new LinkedBlockingQueue();
    private BinaryInputArchive ia;
    private BinaryOutputArchive oa;
    private BufferedOutputStream bufferedOutput;
    final QuorumPacket proposalOfDeath = new QuorumPacket();
    private QuorumPeer.LearnerType learnerType = QuorumPeer.LearnerType.PARTICIPANT;

    public Socket getSocket() {
        return this.sock;
    }

    long getSid() {
        return this.sid;
    }

    int getVersion() {
        return this.version;
    }

    LearnerHandler(Socket sock, Leader leader) throws IOException {
        super("LearnerHandler-" + sock.getRemoteSocketAddress());
        this.sock = sock;
        this.leader = leader;
        leader.addLearnerHandler(this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("LearnerHandler ").append(this.sock);
        sb.append(" tickOfLastAck:").append(this.tickOfLastAck());
        sb.append(" synced?:").append(this.synced());
        sb.append(" queuedPacketLength:").append(this.queuedPackets.size());
        return sb.toString();
    }

    public QuorumPeer.LearnerType getLearnerType() {
        return this.learnerType;
    }

    private void sendPackets() throws InterruptedException {
        block9: {
            long traceMask = 16L;
            try {
                while (true) {
                    QuorumPacket p;
                    if ((p = this.queuedPackets.poll()) == null) {
                        this.bufferedOutput.flush();
                        p = this.queuedPackets.take();
                    }
                    if (p != this.proposalOfDeath) {
                        if (p.getType() == 5) {
                            traceMask = 128L;
                        }
                        if (LOG.isTraceEnabled()) {
                            ZooTrace.logQuorumPacket(LOG, traceMask, 'o', p);
                        }
                        this.oa.writeRecord(p, "packet");
                        continue;
                    }
                    break;
                }
            }
            catch (IOException e) {
                if (this.sock.isClosed()) break block9;
                LOG.warn("Unexpected exception at " + this, (Throwable)e);
                try {
                    this.sock.close();
                }
                catch (IOException ie) {
                    LOG.warn("Error closing socket for handler " + this, (Throwable)ie);
                }
            }
        }
    }

    public static String packetToString(QuorumPacket p) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        block56: {
            block54: {
                Object object;
                StringBuilder stringBuilder;
                block52: {
                    try {
                        try {
                            this.sock.setSoTimeout(this.leader.self.getTickTime() * this.leader.self.getInitLimit());
                            this.ia = BinaryInputArchive.getArchive(new BufferedInputStream(this.sock.getInputStream()));
                            this.bufferedOutput = new BufferedOutputStream(this.sock.getOutputStream());
                            this.oa = BinaryOutputArchive.getArchive(this.bufferedOutput);
                            QuorumPacket qp = new QuorumPacket();
                            this.ia.readRecord(qp, "packet");
                            if (qp.getType() != 11 && qp.getType() != 16) {
                                LOG.error("First packet " + qp.toString() + " is not FOLLOWERINFO or OBSERVERINFO!");
                                Object var39_4 = null;
                                stringBuilder = new StringBuilder().append("******* GOODBYE ");
                                object = this.sock != null ? this.sock.getRemoteSocketAddress() : "<null>";
                                break block52;
                            }
                            byte[] learnerInfoData = qp.getData();
                            if (learnerInfoData != null) {
                                if (learnerInfoData.length == 8) {
                                    ByteBuffer bbsid = ByteBuffer.wrap(learnerInfoData);
                                    this.sid = bbsid.getLong();
                                } else {
                                    LearnerInfo li = new LearnerInfo();
                                    ByteBufferInputStream.byteBuffer2Record(ByteBuffer.wrap(learnerInfoData), li);
                                    this.sid = li.getServerid();
                                    this.version = li.getProtocolVersion();
                                }
                            } else {
                                this.sid = this.leader.followerCounter.getAndDecrement();
                            }
                            LOG.info("Follower sid: " + this.sid + " : info : " + this.leader.self.quorumPeers.get(this.sid));
                            if (qp.getType() == 16) {
                                this.learnerType = QuorumPeer.LearnerType.OBSERVER;
                            }
                            long lastAcceptedEpoch = ZxidUtils.getEpochFromZxid(qp.getZxid());
                            StateSummary ss = null;
                            long zxid = qp.getZxid();
                            long newEpoch = this.leader.getEpochToPropose(this.getSid(), lastAcceptedEpoch);
                            if (this.getVersion() < 65536) {
                                long epoch = ZxidUtils.getEpochFromZxid(zxid);
                                ss = new StateSummary(epoch, zxid);
                                this.leader.waitForEpochAck(this.getSid(), ss);
                            } else {
                                byte[] ver = new byte[4];
                                ByteBuffer.wrap(ver).putInt(65536);
                                QuorumPacket newEpochPacket = new QuorumPacket(17, ZxidUtils.makeZxid(newEpoch, 0L), ver, null);
                                this.oa.writeRecord(newEpochPacket, "packet");
                                this.bufferedOutput.flush();
                                QuorumPacket ackEpochPacket = new QuorumPacket();
                                this.ia.readRecord(ackEpochPacket, "packet");
                                if (ackEpochPacket.getType() != 18) {
                                    LOG.error(ackEpochPacket.toString() + " is not ACKEPOCH");
                                    break block54;
                                }
                                ByteBuffer bbepoch = ByteBuffer.wrap(ackEpochPacket.getData());
                                ss = new StateSummary(bbepoch.getInt(), ackEpochPacket.getZxid());
                                this.leader.waitForEpochAck(this.getSid(), ss);
                            }
                            long peerLastZxid = ss.getLastZxid();
                            int packetToSend = 15;
                            long zxidToSend = 0L;
                            long leaderLastZxid = 0L;
                            long updates = peerLastZxid;
                            ReentrantReadWriteLock lock = this.leader.zk.getZKDatabase().getLogLock();
                            ReentrantReadWriteLock.ReadLock rl = lock.readLock();
                            try {
                                block55: {
                                    block57: {
                                        rl.lock();
                                        long maxCommittedLog = this.leader.zk.getZKDatabase().getmaxCommittedLog();
                                        long minCommittedLog = this.leader.zk.getZKDatabase().getminCommittedLog();
                                        LOG.info("Synchronizing with Follower sid: " + this.sid + " maxCommittedLog=0x" + Long.toHexString(maxCommittedLog) + " minCommittedLog=0x" + Long.toHexString(minCommittedLog) + " peerLastZxid=0x" + Long.toHexString(peerLastZxid));
                                        LinkedList<Leader.Proposal> proposals = this.leader.zk.getZKDatabase().getCommittedLog();
                                        if (proposals.size() == 0) break block57;
                                        LOG.debug("proposal size is {}", (Object)proposals.size());
                                        if (maxCommittedLog >= peerLastZxid && minCommittedLog <= peerLastZxid) {
                                            LOG.debug("Sending proposals to follower");
                                            long prevProposalZxid = minCommittedLog;
                                            boolean firstPacket = true;
                                            for (Leader.Proposal propose : proposals) {
                                                if (propose.packet.getZxid() <= peerLastZxid) {
                                                    prevProposalZxid = propose.packet.getZxid();
                                                    continue;
                                                }
                                                if (firstPacket) {
                                                    firstPacket = false;
                                                    if (prevProposalZxid < peerLastZxid) {
                                                        packetToSend = 14;
                                                        LOG.info("Sending TRUNC");
                                                        updates = zxidToSend = prevProposalZxid;
                                                    } else {
                                                        packetToSend = 13;
                                                        LOG.info("Sending diff");
                                                        zxidToSend = maxCommittedLog;
                                                    }
                                                }
                                                this.queuePacket(propose.packet);
                                                QuorumPacket qcommit = new QuorumPacket(4, propose.packet.getZxid(), null, null);
                                                this.queuePacket(qcommit);
                                            }
                                            break block55;
                                        } else if (peerLastZxid > maxCommittedLog) {
                                            LOG.debug("Sending TRUNC to follower zxidToSend=0x{} updates=0x{}", (Object)Long.toHexString(maxCommittedLog), (Object)Long.toHexString(updates));
                                            packetToSend = 14;
                                            updates = zxidToSend = maxCommittedLog;
                                            break block55;
                                        } else {
                                            LOG.warn("Unhandled proposal scenario");
                                        }
                                        break block55;
                                    }
                                    LOG.debug("proposals is empty");
                                }
                                leaderLastZxid = this.leader.startForwarding(this, updates);
                                if (peerLastZxid == leaderLastZxid) {
                                    LOG.debug("Leader and follower are in sync, sending empty diff. zxid=0x{}", (Object)Long.toHexString(leaderLastZxid));
                                    packetToSend = 13;
                                    zxidToSend = leaderLastZxid;
                                }
                                Object var33_40 = null;
                                rl.unlock();
                            }
                            catch (Throwable throwable) {
                                Object var33_41 = null;
                                rl.unlock();
                                throw throwable;
                            }
                            QuorumPacket newLeaderQP = new QuorumPacket(10, ZxidUtils.makeZxid(newEpoch, 0L), null, null);
                            if (this.getVersion() < 65536) {
                                this.oa.writeRecord(newLeaderQP, "packet");
                            } else {
                                this.queuedPackets.add(newLeaderQP);
                            }
                            this.bufferedOutput.flush();
                            if (packetToSend == 15) {
                                zxidToSend = this.leader.zk.getZKDatabase().getDataTreeLastProcessedZxid();
                            }
                            this.oa.writeRecord(new QuorumPacket(packetToSend, zxidToSend, null, null), "packet");
                            this.bufferedOutput.flush();
                            if (packetToSend == 15) {
                                LOG.info("Sending snapshot last zxid of peer is 0x" + Long.toHexString(peerLastZxid) + " " + " zxid of leader is 0x" + Long.toHexString(leaderLastZxid) + "sent zxid of db as 0x" + Long.toHexString(zxidToSend));
                                this.leader.zk.getZKDatabase().serializeSnapshot(this.oa);
                                this.oa.writeString("BenWasHere", "signature");
                            }
                            this.bufferedOutput.flush();
                            new Thread(){

                                public void run() {
                                    Thread.currentThread().setName("Sender-" + LearnerHandler.this.sock.getRemoteSocketAddress());
                                    try {
                                        LearnerHandler.this.sendPackets();
                                    }
                                    catch (InterruptedException e) {
                                        LOG.warn("Unexpected interruption", (Throwable)e);
                                    }
                                }
                            }.start();
                            qp = new QuorumPacket();
                            this.ia.readRecord(qp, "packet");
                            if (qp.getType() != 3) {
                                LOG.error("Next packet was supposed to be an ACK");
                                break block56;
                            }
                            this.leader.processAck(this.sid, qp.getZxid(), this.sock.getLocalSocketAddress());
                            LeaderZooKeeperServer leaderZooKeeperServer = this.leader.zk;
                            synchronized (leaderZooKeeperServer) {
                                while (!this.leader.zk.isRunning() && !this.isInterrupted()) {
                                    this.leader.zk.wait(20L);
                                }
                            }
                            this.queuedPackets.add(new QuorumPacket(12, -1L, null, null));
                            block21: while (true) {
                                qp = new QuorumPacket();
                                this.ia.readRecord(qp, "packet");
                                long traceMask = 16L;
                                if (qp.getType() == 5) {
                                    traceMask = 128L;
                                }
                                if (LOG.isTraceEnabled()) {
                                    ZooTrace.logQuorumPacket(LOG, traceMask, 'i', qp);
                                }
                                this.tickOfLastAck = this.leader.self.tick;
                                switch (qp.getType()) {
                                    case 3: {
                                        if (this.learnerType == QuorumPeer.LearnerType.OBSERVER && LOG.isDebugEnabled()) {
                                            LOG.debug("Received ACK from Observer  " + this.sid);
                                        }
                                        this.leader.processAck(this.sid, qp.getZxid(), this.sock.getLocalSocketAddress());
                                        break;
                                    }
                                    case 5: {
                                        ByteArrayInputStream bis = new ByteArrayInputStream(qp.getData());
                                        DataInputStream dis = new DataInputStream(bis);
                                        while (dis.available() > 0) {
                                            long sess = dis.readLong();
                                            int to = dis.readInt();
                                            this.leader.zk.touch(sess, to);
                                        }
                                        continue block21;
                                    }
                                    case 6: {
                                        ByteArrayInputStream bis = new ByteArrayInputStream(qp.getData());
                                        DataInputStream dis = new DataInputStream(bis);
                                        long id = dis.readLong();
                                        int to = dis.readInt();
                                        ByteArrayOutputStream bos = new ByteArrayOutputStream();
                                        DataOutputStream dos = new DataOutputStream(bos);
                                        dos.writeLong(id);
                                        boolean valid = this.leader.zk.touch(id, to);
                                        if (valid) {
                                            try {
                                                this.leader.zk.setOwner(id, this);
                                            }
                                            catch (KeeperException.SessionExpiredException e) {
                                                LOG.error("Somehow session " + Long.toHexString(id) + " expired right after being renewed! (impossible)", (Throwable)e);
                                            }
                                        }
                                        if (LOG.isTraceEnabled()) {
                                            ZooTrace.logTraceMessage(LOG, 32L, "Session 0x" + Long.toHexString(id) + " is valid: " + valid);
                                        }
                                        dos.writeBoolean(valid);
                                        qp.setData(bos.toByteArray());
                                        this.queuedPackets.add(qp);
                                        break;
                                    }
                                    case 1: {
                                        ByteBuffer bb = ByteBuffer.wrap(qp.getData());
                                        long sessionId = bb.getLong();
                                        int cxid = bb.getInt();
                                        int type = bb.getInt();
                                        bb = bb.slice();
                                        Request si = type == 9 ? new LearnerSyncRequest(this, sessionId, cxid, type, bb, qp.getAuthinfo()) : new Request(null, sessionId, cxid, type, bb, qp.getAuthinfo());
                                        si.setOwner(this);
                                        this.leader.zk.submitRequest(si);
                                        break;
                                    }
                                }
                            }
                        }
                        catch (IOException e) {
                            if (this.sock != null && !this.sock.isClosed()) {
                                LOG.error("Unexpected exception causing shutdown while sock still open", (Throwable)e);
                                try {
                                    this.sock.close();
                                }
                                catch (IOException iOException) {
                                }
                            }
                            Object var39_7 = null;
                            LOG.warn("******* GOODBYE " + (this.sock != null ? this.sock.getRemoteSocketAddress() : "<null>") + " ********");
                            this.shutdown();
                            return;
                        }
                        catch (InterruptedException e) {
                            LOG.error("Unexpected exception causing shutdown", (Throwable)e);
                            Object var39_8 = null;
                            LOG.warn("******* GOODBYE " + (this.sock != null ? this.sock.getRemoteSocketAddress() : "<null>") + " ********");
                            this.shutdown();
                            return;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var39_9 = null;
                        LOG.warn("******* GOODBYE " + (this.sock != null ? this.sock.getRemoteSocketAddress() : "<null>") + " ********");
                        this.shutdown();
                        throw throwable;
                    }
                }
                LOG.warn(stringBuilder.append(object).append(" ********").toString());
                this.shutdown();
                return;
            }
            Object var39_5 = null;
            LOG.warn("******* GOODBYE " + (this.sock != null ? this.sock.getRemoteSocketAddress() : "<null>") + " ********");
            this.shutdown();
            return;
        }
        Object var39_6 = null;
        LOG.warn("******* GOODBYE " + (this.sock != null ? this.sock.getRemoteSocketAddress() : "<null>") + " ********");
        this.shutdown();
    }

    public void shutdown() {
        try {
            this.queuedPackets.put(this.proposalOfDeath);
        }
        catch (InterruptedException e) {
            LOG.warn("Ignoring unexpected exception", (Throwable)e);
        }
        try {
            if (this.sock != null && !this.sock.isClosed()) {
                this.sock.close();
            }
        }
        catch (IOException e) {
            LOG.warn("Ignoring unexpected exception during socket close", (Throwable)e);
        }
        this.interrupt();
        this.leader.removeLearnerHandler(this);
    }

    public long tickOfLastAck() {
        return this.tickOfLastAck;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ping() {
        long id;
        Leader leader = this.leader;
        synchronized (leader) {
            id = this.leader.lastProposed;
        }
        QuorumPacket ping = new QuorumPacket(5, id, null, null);
        this.queuePacket(ping);
    }

    void queuePacket(QuorumPacket p) {
        this.queuedPackets.add(p);
    }

    public boolean synced() {
        return this.isAlive() && this.tickOfLastAck >= (long)(this.leader.self.tick - this.leader.self.syncLimit);
    }
}

