/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hcatalog.hbase;

import java.io.IOException;
import java.util.Properties;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hive.ql.exec.FileSinkOperator;
import org.apache.hadoop.hive.ql.io.HiveOutputFormat;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.OutputFormat;
import org.apache.hadoop.mapred.RecordWriter;
import org.apache.hadoop.util.Progressable;
import org.apache.hcatalog.common.HCatUtil;
import org.apache.hcatalog.hbase.HBaseBulkOutputFormat;
import org.apache.hcatalog.hbase.HBaseDirectOutputFormat;
import org.apache.hcatalog.hbase.HBaseHCatStorageHandler;
import org.apache.hcatalog.mapreduce.OutputJobInfo;

public class HBaseBaseOutputFormat
implements OutputFormat<WritableComparable<?>, Put>,
HiveOutputFormat<WritableComparable<?>, Put> {
    public FileSinkOperator.RecordWriter getHiveRecordWriter(JobConf jc, Path finalOutPath, Class<? extends Writable> valueClass, boolean isCompressed, Properties tableProperties, Progressable progress) throws IOException {
        throw new UnsupportedOperationException("Not implemented");
    }

    public void checkOutputSpecs(FileSystem ignored, JobConf job) throws IOException {
        OutputFormat<WritableComparable<?>, Put> outputFormat = this.getOutputFormat(job);
        outputFormat.checkOutputSpecs(ignored, job);
    }

    public RecordWriter<WritableComparable<?>, Put> getRecordWriter(FileSystem ignored, JobConf job, String name, Progressable progress) throws IOException {
        OutputFormat<WritableComparable<?>, Put> outputFormat = this.getOutputFormat(job);
        return outputFormat.getRecordWriter(ignored, job, name, progress);
    }

    private OutputFormat<WritableComparable<?>, Put> getOutputFormat(JobConf job) throws IOException {
        String outputInfo = job.get("mapreduce.lib.hcatoutput.info");
        OutputJobInfo outputJobInfo = (OutputJobInfo)HCatUtil.deserialize((String)outputInfo);
        HBaseBaseOutputFormat outputFormat = null;
        outputFormat = HBaseHCatStorageHandler.isBulkMode(outputJobInfo) ? new HBaseBulkOutputFormat() : new HBaseDirectOutputFormat();
        return outputFormat;
    }
}

