/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hcatalog.hbase;

import com.facebook.fb303.FacebookBase;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.MasterNotRunningException;
import org.apache.hadoop.hbase.ZooKeeperConnectionException;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.mapreduce.TableMapReduceUtil;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hive.hbase.HBaseSerDe;
import org.apache.hadoop.hive.metastore.HiveMetaHook;
import org.apache.hadoop.hive.metastore.MetaStoreUtils;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.TableDesc;
import org.apache.hadoop.hive.ql.security.authorization.HiveAuthorizationProvider;
import org.apache.hadoop.hive.serde2.SerDe;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.OutputFormat;
import org.apache.hadoop.util.StringUtils;
import org.apache.hcatalog.common.HCatUtil;
import org.apache.hcatalog.data.schema.HCatSchema;
import org.apache.hcatalog.hbase.HBaseAuthorizationProvider;
import org.apache.hcatalog.hbase.HBaseBaseOutputFormat;
import org.apache.hcatalog.hbase.HBaseBulkOutputFormat;
import org.apache.hcatalog.hbase.HBaseDirectOutputFormat;
import org.apache.hcatalog.hbase.HBaseInputFormat;
import org.apache.hcatalog.hbase.HBaseRevisionManagerUtil;
import org.apache.hcatalog.hbase.HBaseUtil;
import org.apache.hcatalog.hbase.HCatTableSnapshot;
import org.apache.hcatalog.hbase.snapshot.RevisionManager;
import org.apache.hcatalog.hbase.snapshot.RevisionManagerConfiguration;
import org.apache.hcatalog.hbase.snapshot.Transaction;
import org.apache.hcatalog.mapreduce.HCatOutputFormat;
import org.apache.hcatalog.mapreduce.HCatStorageHandler;
import org.apache.hcatalog.mapreduce.HCatTableInfo;
import org.apache.hcatalog.mapreduce.InputJobInfo;
import org.apache.hcatalog.mapreduce.OutputJobInfo;
import org.apache.thrift.TBase;
import org.apache.zookeeper.ZooKeeper;

public class HBaseHCatStorageHandler
extends HCatStorageHandler
implements HiveMetaHook,
Configurable {
    public static final String DEFAULT_PREFIX = "default.";
    private static final String PROPERTY_INT_OUTPUT_LOCATION = "hcat.hbase.mapreduce.intermediateOutputLocation";
    private Configuration hbaseConf;
    private Configuration jobConf;
    private HBaseAdmin admin;

    @Deprecated
    public void configureInputJobProperties(TableDesc tableDesc, Map<String, String> jobProperties) {
        Map tableJobProperties = tableDesc.getJobProperties();
        String jobString = (String)tableJobProperties.get("mapreduce.lib.hcat.job.info");
        try {
            InputJobInfo inputJobInfo = (InputJobInfo)HCatUtil.deserialize((String)jobString);
            HCatTableInfo tableInfo = inputJobInfo.getTableInfo();
            String qualifiedTableName = HBaseHCatStorageHandler.getFullyQualifiedHBaseTableName(tableInfo);
            jobProperties.put("hbase.mapreduce.inputtable", qualifiedTableName);
            Configuration jobConf = this.getJobConf();
            this.addResources(jobConf, jobProperties);
            JobConf copyOfConf = new JobConf(jobConf);
            HBaseConfiguration.addHbaseResources((Configuration)copyOfConf);
            if (jobConf instanceof JobConf) {
                HBaseUtil.addHBaseDelegationToken(copyOfConf);
                ((JobConf)jobConf).getCredentials().addAll(copyOfConf.getCredentials());
            }
            String outputSchema = jobConf.get("mapreduce.lib.hcat.output.schema");
            jobProperties.put("hbase.mapreduce.scan.columns", this.getScanColumns(tableInfo, outputSchema));
            String serSnapshot = (String)inputJobInfo.getProperties().get("hcathbase.table.snapshot");
            if (serSnapshot == null) {
                HCatTableSnapshot snapshot = HBaseRevisionManagerUtil.createSnapshot(RevisionManagerConfiguration.create((Configuration)copyOfConf), qualifiedTableName, tableInfo);
                jobProperties.put("hcathbase.table.snapshot", HCatUtil.serialize((Serializable)snapshot));
            }
            this.addOutputDependencyJars(jobConf);
            jobProperties.put("tmpjars", jobConf.get("tmpjars"));
        }
        catch (IOException e) {
            throw new IllegalStateException("Error while configuring job properties", e);
        }
    }

    @Deprecated
    public void configureOutputJobProperties(TableDesc tableDesc, Map<String, String> jobProperties) {
        Map tableJobProperties = tableDesc.getJobProperties();
        String jobString = (String)tableJobProperties.get("mapreduce.lib.hcatoutput.info");
        try {
            OutputJobInfo outputJobInfo = (OutputJobInfo)HCatUtil.deserialize((String)jobString);
            HCatTableInfo tableInfo = outputJobInfo.getTableInfo();
            String qualifiedTableName = HBaseHCatStorageHandler.getFullyQualifiedHBaseTableName(tableInfo);
            jobProperties.put("hcat.hbase.mapreduce.outputTableName", qualifiedTableName);
            jobProperties.put("hbase.mapred.outputtable", qualifiedTableName);
            Configuration jobConf = this.getJobConf();
            this.addResources(jobConf, jobProperties);
            Configuration copyOfConf = new Configuration(jobConf);
            HBaseConfiguration.addHbaseResources((Configuration)copyOfConf);
            String txnString = outputJobInfo.getProperties().getProperty("hcat.hbase.mapreduce.writeTxn");
            Transaction txn = null;
            if (txnString == null) {
                txn = HBaseRevisionManagerUtil.beginWriteTransaction(qualifiedTableName, tableInfo, RevisionManagerConfiguration.create(copyOfConf));
                String serializedTxn = HCatUtil.serialize((Serializable)txn);
                outputJobInfo.getProperties().setProperty("hcat.hbase.mapreduce.writeTxn", serializedTxn);
            } else {
                txn = (Transaction)HCatUtil.deserialize((String)txnString);
            }
            if (HBaseHCatStorageHandler.isBulkMode(outputJobInfo)) {
                String tableLocation = tableInfo.getTableLocation();
                String location = new Path(tableLocation, "REVISION_" + txn.getRevisionNumber()).toString();
                outputJobInfo.getProperties().setProperty(PROPERTY_INT_OUTPUT_LOCATION, location);
                jobProperties.put("mapred.output.dir", location);
                jobProperties.put("mapred.output.committer.class", HBaseBulkOutputFormat.HBaseBulkOutputCommitter.class.getName());
            } else {
                jobProperties.put("mapred.output.committer.class", HBaseDirectOutputFormat.HBaseDirectOutputCommitter.class.getName());
            }
            jobProperties.put("mapreduce.lib.hcatoutput.info", HCatUtil.serialize((Serializable)outputJobInfo));
            this.addOutputDependencyJars(jobConf);
            jobProperties.put("tmpjars", jobConf.get("tmpjars"));
        }
        catch (IOException e) {
            throw new IllegalStateException("Error while configuring job properties", e);
        }
    }

    @Deprecated
    public HiveAuthorizationProvider getAuthorizationProvider() throws HiveException {
        HBaseAuthorizationProvider hbaseAuth = new HBaseAuthorizationProvider();
        hbaseAuth.init(this.getConf());
        return hbaseAuth;
    }

    @Deprecated
    public void commitCreateTable(Table table) throws MetaException {
    }

    @Deprecated
    public void commitDropTable(Table tbl, boolean deleteData) throws MetaException {
        this.checkDeleteTable(tbl);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Deprecated
    public void preCreateTable(Table tbl) throws MetaException {
        boolean isExternal = MetaStoreUtils.isExternalTable((Table)tbl);
        this.hbaseConf = this.getConf();
        if (tbl.getSd().getLocation() != null) {
            throw new MetaException("LOCATION may not be specified for HBase.");
        }
        try {
            HTableDescriptor tableDesc;
            String tableName = this.getFullyQualifiedHBaseTableName(tbl);
            String hbaseColumnsMapping = (String)tbl.getParameters().get("hbase.columns.mapping");
            if (hbaseColumnsMapping == null) {
                throw new MetaException("No hbase.columns.mapping defined in table properties.");
            }
            ArrayList<String> hbaseColumnFamilies = new ArrayList<String>();
            ArrayList<String> hbaseColumnQualifiers = new ArrayList<String>();
            ArrayList<byte[]> hbaseColumnFamiliesBytes = new ArrayList<byte[]>();
            int iKey = HBaseUtil.parseColumnMapping(hbaseColumnsMapping, hbaseColumnFamilies, hbaseColumnFamiliesBytes, hbaseColumnQualifiers, null);
            HashSet<String> uniqueColumnFamilies = new HashSet<String>();
            if (!this.getHBaseAdmin().tableExists(tableName)) {
                if (isExternal) throw new MetaException("HBase table " + tableName + " doesn't exist while the table is " + "declared as an external table.");
                tableDesc = new HTableDescriptor(tableName);
                uniqueColumnFamilies.addAll(hbaseColumnFamilies);
                uniqueColumnFamilies.remove(hbaseColumnFamilies.get(iKey));
                for (String columnFamily : uniqueColumnFamilies) {
                    HColumnDescriptor familyDesc = new HColumnDescriptor(Bytes.toBytes((String)columnFamily));
                    familyDesc.setMaxVersions(Integer.MAX_VALUE);
                    tableDesc.addFamily(familyDesc);
                }
                this.getHBaseAdmin().createTable(tableDesc);
            } else {
                if (!isExternal) {
                    throw new MetaException("Table " + tableName + " already exists within HBase." + " Use CREATE EXTERNAL TABLE instead to" + " register it in HCatalog.");
                }
                tableDesc = this.getHBaseAdmin().getTableDescriptor(Bytes.toBytes((String)tableName));
                for (int i = 0; i < hbaseColumnFamilies.size(); ++i) {
                    if (i == iKey || tableDesc.hasFamily((byte[])hbaseColumnFamiliesBytes.get(i))) continue;
                    throw new MetaException("Column Family " + (String)hbaseColumnFamilies.get(i) + " is not defined in hbase table " + tableName);
                }
            }
            new HTable(this.hbaseConf, tableDesc.getName());
            RevisionManager rm = HBaseRevisionManagerUtil.getOpenedRevisionManager(this.hbaseConf);
            rm.createTable(tableName, new ArrayList<String>(uniqueColumnFamilies));
            return;
        }
        catch (MasterNotRunningException mnre) {
            throw new MetaException(StringUtils.stringifyException((Throwable)mnre));
        }
        catch (IOException ie) {
            throw new MetaException(StringUtils.stringifyException((Throwable)ie));
        }
        catch (IllegalArgumentException iae) {
            throw new MetaException(StringUtils.stringifyException((Throwable)iae));
        }
    }

    @Deprecated
    public void preDropTable(Table table) throws MetaException {
    }

    @Deprecated
    public void rollbackCreateTable(Table table) throws MetaException {
        this.checkDeleteTable(table);
    }

    @Deprecated
    public void rollbackDropTable(Table table) throws MetaException {
    }

    @Deprecated
    public HiveMetaHook getMetaHook() {
        return this;
    }

    private HBaseAdmin getHBaseAdmin() throws MetaException {
        try {
            if (this.admin == null) {
                this.admin = new HBaseAdmin(this.getConf());
            }
            return this.admin;
        }
        catch (MasterNotRunningException mnre) {
            throw new MetaException(StringUtils.stringifyException((Throwable)mnre));
        }
        catch (ZooKeeperConnectionException zkce) {
            throw new MetaException(StringUtils.stringifyException((Throwable)zkce));
        }
    }

    private String getFullyQualifiedHBaseTableName(Table tbl) {
        String tableName = (String)tbl.getParameters().get("hbase.table.name");
        if (tableName == null) {
            tableName = (String)tbl.getSd().getSerdeInfo().getParameters().get("hbase.table.name");
        }
        if (tableName == null) {
            tableName = tbl.getDbName().equals("default") ? tbl.getTableName() : tbl.getDbName() + "." + tbl.getTableName();
            tableName = tableName.toLowerCase();
        }
        return tableName;
    }

    static String getFullyQualifiedHBaseTableName(HCatTableInfo tableInfo) {
        String qualifiedName = tableInfo.getStorerInfo().getProperties().getProperty("hbase.table.name");
        if (qualifiedName == null) {
            String databaseName = tableInfo.getDatabaseName();
            String tableName = tableInfo.getTableName();
            qualifiedName = databaseName == null || databaseName.equals("default") ? tableName : databaseName + "." + tableName;
            qualifiedName = qualifiedName.toLowerCase();
        }
        return qualifiedName;
    }

    @Deprecated
    public Class<? extends InputFormat> getInputFormatClass() {
        return HBaseInputFormat.class;
    }

    @Deprecated
    public Class<? extends OutputFormat> getOutputFormatClass() {
        return HBaseBaseOutputFormat.class;
    }

    @Deprecated
    public Class<? extends SerDe> getSerDeClass() throws UnsupportedOperationException {
        return HBaseSerDe.class;
    }

    @Deprecated
    public Configuration getJobConf() {
        return this.jobConf;
    }

    @Deprecated
    public void configureJobConf(TableDesc tableDesc, JobConf jobConf) {
    }

    @Deprecated
    public Configuration getConf() {
        if (this.hbaseConf == null) {
            this.hbaseConf = HBaseConfiguration.create();
        }
        return this.hbaseConf;
    }

    @Deprecated
    public void setConf(Configuration conf) {
        this.jobConf = conf;
        this.hbaseConf = RevisionManagerConfiguration.create(HBaseConfiguration.create((Configuration)conf));
    }

    private void checkDeleteTable(Table table) throws MetaException {
        boolean isExternal = MetaStoreUtils.isExternalTable((Table)table);
        String tableName = this.getFullyQualifiedHBaseTableName(table);
        RevisionManager rm = null;
        try {
            if (!isExternal && this.getHBaseAdmin().tableExists(tableName)) {
                if (this.getHBaseAdmin().isTableEnabled(tableName)) {
                    this.getHBaseAdmin().disableTable(tableName);
                }
                this.getHBaseAdmin().deleteTable(tableName);
                rm = HBaseRevisionManagerUtil.getOpenedRevisionManager(this.hbaseConf);
                rm.dropTable(tableName);
            }
        }
        catch (IOException ie) {
            throw new MetaException(StringUtils.stringifyException((Throwable)ie));
        }
        finally {
            HBaseRevisionManagerUtil.closeRevisionManagerQuietly(rm);
        }
    }

    private void addOutputDependencyJars(Configuration conf) throws IOException {
        TableMapReduceUtil.addDependencyJars((Configuration)conf, (Class[])new Class[]{ZooKeeper.class, HTable.class, HiveException.class, HCatOutputFormat.class, HBaseHCatStorageHandler.class, HBaseSerDe.class, Table.class, TBase.class, Bytes.class, FacebookBase.class, ThreadFactoryBuilder.class});
    }

    private void addResources(Configuration jobConf, Map<String, String> newJobProperties) {
        Configuration conf = new Configuration(false);
        HBaseConfiguration.addHbaseResources((Configuration)conf);
        RevisionManagerConfiguration.addResources(conf);
        for (Map.Entry entry : conf) {
            if (jobConf.get((String)entry.getKey()) != null) continue;
            newJobProperties.put((String)entry.getKey(), (String)entry.getValue());
        }
    }

    public static boolean isBulkMode(OutputJobInfo outputJobInfo) {
        String bulkMode = outputJobInfo.getTableInfo().getStorerInfo().getProperties().getProperty("hcat.hbase.output.bulkMode", "false");
        return "true".equals(bulkMode);
    }

    private String getScanColumns(HCatTableInfo tableInfo, String outputColSchema) throws IOException {
        StringBuilder builder = new StringBuilder();
        String hbaseColumnMapping = tableInfo.getStorerInfo().getProperties().getProperty("hbase.columns.mapping");
        if (outputColSchema == null) {
            String[] splits = hbaseColumnMapping.split("[,]");
            for (int i = 0; i < splits.length; ++i) {
                if (splits[i].equals(":key")) continue;
                builder.append(splits[i]).append(" ");
            }
        } else {
            HCatSchema outputSchema = (HCatSchema)HCatUtil.deserialize((String)outputColSchema);
            HCatSchema tableSchema = tableInfo.getDataColumns();
            List outputFieldNames = outputSchema.getFieldNames();
            ArrayList<Integer> outputColumnMapping = new ArrayList<Integer>();
            for (String fieldName : outputFieldNames) {
                int position = tableSchema.getPosition(fieldName);
                outputColumnMapping.add(position);
            }
            ArrayList<String> columnFamilies = new ArrayList<String>();
            ArrayList<String> columnQualifiers = new ArrayList<String>();
            HBaseUtil.parseColumnMapping(hbaseColumnMapping, columnFamilies, null, columnQualifiers, null);
            for (int i = 0; i < outputColumnMapping.size(); ++i) {
                int cfIndex = (Integer)outputColumnMapping.get(i);
                String cf = (String)columnFamilies.get(cfIndex);
                if (cf.equals(":key")) continue;
                String qualifier = (String)columnQualifiers.get(i);
                builder.append(cf);
                builder.append(":");
                if (qualifier != null) {
                    builder.append(qualifier);
                }
                builder.append(" ");
            }
        }
        builder.deleteCharAt(builder.length() - 1);
        return builder.toString();
    }
}

