/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hcatalog.hbase;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hcatalog.common.HCatUtil;
import org.apache.hcatalog.data.schema.HCatFieldSchema;
import org.apache.hcatalog.data.schema.HCatSchema;
import org.apache.hcatalog.hbase.HBaseUtil;
import org.apache.hcatalog.hbase.HCatTableSnapshot;
import org.apache.hcatalog.hbase.snapshot.RevisionManager;
import org.apache.hcatalog.hbase.snapshot.RevisionManagerFactory;
import org.apache.hcatalog.hbase.snapshot.TableSnapshot;
import org.apache.hcatalog.hbase.snapshot.Transaction;
import org.apache.hcatalog.mapreduce.HCatTableInfo;
import org.apache.hcatalog.mapreduce.InputJobInfo;
import org.apache.hcatalog.mapreduce.OutputJobInfo;
import org.apache.hcatalog.mapreduce.StorerInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class HBaseRevisionManagerUtil {
    private static final Logger LOG = LoggerFactory.getLogger(HBaseRevisionManagerUtil.class);

    private HBaseRevisionManagerUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static HCatTableSnapshot createSnapshot(Configuration jobConf, String hbaseTableName, HCatTableInfo tableInfo) throws IOException {
        TableSnapshot snpt;
        RevisionManager rm = null;
        try {
            rm = HBaseRevisionManagerUtil.getOpenedRevisionManager(jobConf);
            snpt = rm.createSnapshot(hbaseTableName);
        }
        finally {
            HBaseRevisionManagerUtil.closeRevisionManagerQuietly(rm);
        }
        HCatTableSnapshot hcatSnapshot = HBaseRevisionManagerUtil.convertSnapshot(snpt, tableInfo);
        return hcatSnapshot;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static HCatTableSnapshot createSnapshot(Configuration jobConf, String tableName, long revision) throws IOException {
        TableSnapshot snpt;
        RevisionManager rm = null;
        try {
            rm = HBaseRevisionManagerUtil.getOpenedRevisionManager(jobConf);
            snpt = rm.createSnapshot(tableName, revision);
        }
        finally {
            HBaseRevisionManagerUtil.closeRevisionManagerQuietly(rm);
        }
        String inputJobString = jobConf.get("mapreduce.lib.hcat.job.info");
        if (inputJobString == null) {
            throw new IOException("InputJobInfo information not found in JobContext. HCatInputFormat.setInput() not called?");
        }
        InputJobInfo inputInfo = (InputJobInfo)HCatUtil.deserialize((String)inputJobString);
        HCatTableSnapshot hcatSnapshot = HBaseRevisionManagerUtil.convertSnapshot(snpt, inputInfo.getTableInfo());
        return hcatSnapshot;
    }

    static RevisionManager getOpenedRevisionManager(Configuration jobConf) throws IOException {
        return RevisionManagerFactory.getOpenedRevisionManager(jobConf);
    }

    static void closeRevisionManagerQuietly(RevisionManager rm) {
        if (rm != null) {
            try {
                rm.close();
            }
            catch (IOException e) {
                LOG.warn("Error while trying to close revision manager", (Throwable)e);
            }
        }
    }

    static HCatTableSnapshot convertSnapshot(TableSnapshot hbaseSnapshot, HCatTableInfo hcatTableInfo) throws IOException {
        HCatSchema hcatTableSchema = hcatTableInfo.getDataColumns();
        Map<String, String> hcatHbaseColMap = HBaseRevisionManagerUtil.getHCatHBaseColumnMapping(hcatTableInfo);
        HashMap<String, Long> revisionMap = new HashMap<String, Long>();
        for (HCatFieldSchema fSchema : hcatTableSchema.getFields()) {
            if (!hcatHbaseColMap.containsKey(fSchema.getName())) continue;
            String colFamily = hcatHbaseColMap.get(fSchema.getName());
            long revisionID = hbaseSnapshot.getRevision(colFamily);
            revisionMap.put(fSchema.getName(), revisionID);
        }
        HCatTableSnapshot hcatSnapshot = new HCatTableSnapshot(hcatTableInfo.getDatabaseName(), hcatTableInfo.getTableName(), revisionMap, hbaseSnapshot.getLatestRevision());
        return hcatSnapshot;
    }

    static TableSnapshot convertSnapshot(HCatTableSnapshot hcatSnapshot, HCatTableInfo hcatTableInfo) throws IOException {
        HCatSchema hcatTableSchema = hcatTableInfo.getDataColumns();
        HashMap<String, Long> revisionMap = new HashMap<String, Long>();
        Map<String, String> hcatHbaseColMap = HBaseRevisionManagerUtil.getHCatHBaseColumnMapping(hcatTableInfo);
        for (HCatFieldSchema fSchema : hcatTableSchema.getFields()) {
            String colFamily = hcatHbaseColMap.get(fSchema.getName());
            if (!hcatSnapshot.containsColumn(fSchema.getName())) continue;
            long revision = hcatSnapshot.getRevision(fSchema.getName());
            revisionMap.put(colFamily, revision);
        }
        String fullyQualifiedName = hcatSnapshot.getDatabaseName() + "." + hcatSnapshot.getTableName();
        return new TableSnapshot(fullyQualifiedName, revisionMap, hcatSnapshot.getLatestRevision());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Transaction beginWriteTransaction(String qualifiedTableName, HCatTableInfo tableInfo, Configuration jobConf) throws IOException {
        Transaction txn;
        RevisionManager rm = null;
        try {
            rm = HBaseRevisionManagerUtil.getOpenedRevisionManager(jobConf);
            String hBaseColumns = tableInfo.getStorerInfo().getProperties().getProperty("hbase.columns.mapping");
            String[] splits = hBaseColumns.split("[,:]");
            HashSet<String> families = new HashSet<String>();
            for (int i = 0; i < splits.length; i += 2) {
                if (splits[i].isEmpty()) continue;
                families.add(splits[i]);
            }
            txn = rm.beginWriteTransaction(qualifiedTableName, new ArrayList<String>(families));
        }
        finally {
            HBaseRevisionManagerUtil.closeRevisionManagerQuietly(rm);
        }
        return txn;
    }

    static Transaction getWriteTransaction(Configuration conf) throws IOException {
        OutputJobInfo outputJobInfo = (OutputJobInfo)HCatUtil.deserialize((String)conf.get("mapreduce.lib.hcatoutput.info"));
        return (Transaction)HCatUtil.deserialize((String)outputJobInfo.getProperties().getProperty("hcat.hbase.mapreduce.writeTxn"));
    }

    static void setWriteTransaction(Configuration conf, Transaction txn) throws IOException {
        OutputJobInfo outputJobInfo = (OutputJobInfo)HCatUtil.deserialize((String)conf.get("mapreduce.lib.hcatoutput.info"));
        outputJobInfo.getProperties().setProperty("hcat.hbase.mapreduce.writeTxn", HCatUtil.serialize((Serializable)txn));
        conf.set("mapreduce.lib.hcatoutput.info", HCatUtil.serialize((Serializable)outputJobInfo));
    }

    static long getOutputRevision(Configuration conf) throws IOException {
        return HBaseRevisionManagerUtil.getWriteTransaction(conf).getRevisionNumber();
    }

    private static Map<String, String> getHCatHBaseColumnMapping(HCatTableInfo hcatTableInfo) throws IOException {
        HCatSchema hcatTableSchema = hcatTableInfo.getDataColumns();
        StorerInfo storeInfo = hcatTableInfo.getStorerInfo();
        String hbaseColumnMapping = storeInfo.getProperties().getProperty("hbase.columns.mapping");
        HashMap<String, String> hcatHbaseColMap = new HashMap<String, String>();
        ArrayList<String> columnFamilies = new ArrayList<String>();
        ArrayList<String> columnQualifiers = new ArrayList<String>();
        HBaseUtil.parseColumnMapping(hbaseColumnMapping, columnFamilies, null, columnQualifiers, null);
        for (HCatFieldSchema column : hcatTableSchema.getFields()) {
            int fieldPos = hcatTableSchema.getPosition(column.getName());
            String colFamily = (String)columnFamilies.get(fieldPos);
            if (colFamily.equals(":key")) continue;
            hcatHbaseColMap.put(column.getName(), colFamily);
        }
        return hcatHbaseColMap;
    }
}

