/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hcatalog.hbase;

import java.io.IOException;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.mapred.JobConf;

class HBaseUtil {
    private HBaseUtil() {
    }

    static int parseColumnMapping(String columnMapping, List<String> colFamilies, List<byte[]> colFamiliesBytes, List<String> colQualifiers, List<byte[]> colQualifiersBytes) throws IOException {
        int rowKeyIndex = -1;
        if (colFamilies == null || colQualifiers == null) {
            throw new IllegalArgumentException("Error: caller must pass in lists for the column families and qualifiers.");
        }
        colFamilies.clear();
        colQualifiers.clear();
        if (columnMapping == null) {
            throw new IllegalArgumentException("Error: hbase.columns.mapping missing for this HBase table.");
        }
        if (columnMapping.equals("") || columnMapping.equals(":key")) {
            throw new IllegalArgumentException("Error: hbase.columns.mapping specifies only the HBase table row key. A valid Hive-HBase table must specify at least one additional column.");
        }
        String[] mapping = columnMapping.split(",");
        for (int i = 0; i < mapping.length; ++i) {
            String elem = mapping[i];
            int idxFirst = elem.indexOf(":");
            int idxLast = elem.lastIndexOf(":");
            if (idxFirst < 0 || idxFirst != idxLast) {
                throw new IllegalArgumentException("Error: the HBase columns mapping contains a badly formed column family, column qualifier specification.");
            }
            if (elem.equals(":key")) {
                rowKeyIndex = i;
                colFamilies.add(elem);
                colQualifiers.add(null);
                continue;
            }
            String[] parts = elem.split(":");
            assert (parts.length > 0 && parts.length <= 2);
            colFamilies.add(parts[0]);
            if (parts.length == 2) {
                colQualifiers.add(parts[1]);
                continue;
            }
            colQualifiers.add(null);
        }
        if (rowKeyIndex == -1) {
            colFamilies.add(0, ":key");
            colQualifiers.add(0, null);
            rowKeyIndex = 0;
        }
        if (colFamilies.size() != colQualifiers.size()) {
            throw new IOException("Error in parsing the hbase columns mapping.");
        }
        if (colFamiliesBytes != null) {
            colFamiliesBytes.clear();
            for (String fam : colFamilies) {
                colFamiliesBytes.add(Bytes.toBytes((String)fam));
            }
        }
        if (colQualifiersBytes != null) {
            colQualifiersBytes.clear();
            for (String qual : colQualifiers) {
                if (qual == null) {
                    colQualifiersBytes.add(null);
                    continue;
                }
                colQualifiersBytes.add(Bytes.toBytes((String)qual));
            }
        }
        if (colFamiliesBytes != null && colQualifiersBytes != null && colFamiliesBytes.size() != colQualifiersBytes.size()) {
            throw new IOException("Error in caching the bytes for the hbase column families and qualifiers.");
        }
        return rowKeyIndex;
    }

    static void addHBaseDelegationToken(JobConf job) throws IOException {
        if (User.isHBaseSecurityEnabled((Configuration)job)) {
            try {
                User.getCurrent().obtainAuthTokenForJob(job);
            }
            catch (InterruptedException e) {
                throw new IOException("Error while obtaining hbase delegation token", e);
            }
        }
    }
}

