/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hcatalog.hbase;

import java.io.Serializable;
import java.util.Map;

public class HCatTableSnapshot
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String tableName;
    private String databaseName;
    private Map<String, Long> columnMap;
    private long latestRevision;

    HCatTableSnapshot(String databaseName, String tableName, Map<String, Long> columnMap, long latestRevision) {
        this.tableName = tableName;
        this.databaseName = databaseName;
        this.columnMap = columnMap;
        this.latestRevision = latestRevision;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    long getRevision(String column) {
        if (this.columnMap.containsKey(column)) {
            return this.columnMap.get(column);
        }
        return this.latestRevision;
    }

    boolean containsColumn(String column) {
        return this.columnMap.containsKey(column);
    }

    long getLatestRevision() {
        return this.latestRevision;
    }

    public String toString() {
        String snapshot = " Database Name: " + this.databaseName + " Table Name : " + this.tableName + "Latest Revision: " + this.latestRevision + " Column revision : " + this.columnMap.toString();
        return snapshot;
    }
}

