/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hcatalog.hbase;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.io.DataInputBuffer;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hcatalog.common.HCatUtil;
import org.apache.hcatalog.hbase.HBaseRevisionManagerUtil;
import org.apache.hcatalog.hbase.HCatTableSnapshot;
import org.apache.hcatalog.hbase.snapshot.FamilyRevision;
import org.apache.hcatalog.hbase.snapshot.RevisionManager;
import org.apache.hcatalog.hbase.snapshot.TableSnapshot;
import org.apache.hcatalog.mapreduce.InputJobInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class HbaseSnapshotRecordReader
implements RecordReader<ImmutableBytesWritable, Result> {
    static final Logger LOG = LoggerFactory.getLogger(HbaseSnapshotRecordReader.class);
    private final InputJobInfo inpJobInfo;
    private final Configuration conf;
    private final int maxRevisions = 1;
    private ResultScanner scanner;
    private Scan scan;
    private HTable htable;
    private TableSnapshot snapshot;
    private Iterator<Result> resultItr;
    private Set<Long> allAbortedTransactions;
    private DataOutputBuffer valueOut = new DataOutputBuffer();
    private DataInputBuffer valueIn = new DataInputBuffer();

    HbaseSnapshotRecordReader(InputJobInfo inputJobInfo, Configuration conf) throws IOException {
        this.inpJobInfo = inputJobInfo;
        this.conf = conf;
        String snapshotString = conf.get("hcathbase.table.snapshot");
        HCatTableSnapshot hcatSnapshot = (HCatTableSnapshot)HCatUtil.deserialize((String)snapshotString);
        this.snapshot = HBaseRevisionManagerUtil.convertSnapshot(hcatSnapshot, this.inpJobInfo.getTableInfo());
    }

    public void init() throws IOException {
        this.restart(this.scan.getStartRow());
    }

    public void restart(byte[] firstRow) throws IOException {
        this.allAbortedTransactions = this.getAbortedTransactions(Bytes.toString((byte[])this.htable.getTableName()), this.scan);
        long maxValidRevision = this.getMaximumRevision(this.scan, this.snapshot);
        while (this.allAbortedTransactions.contains(maxValidRevision)) {
            --maxValidRevision;
        }
        Scan newScan = new Scan(this.scan);
        newScan.setStartRow(firstRow);
        newScan.setTimeRange(0L, maxValidRevision + 1L);
        newScan.setMaxVersions();
        this.scanner = this.htable.getScanner(newScan);
        this.resultItr = this.scanner.iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<Long> getAbortedTransactions(String tableName, Scan scan) throws IOException {
        HashSet<Long> abortedTransactions = new HashSet<Long>();
        RevisionManager rm = null;
        try {
            byte[][] families;
            rm = HBaseRevisionManagerUtil.getOpenedRevisionManager(this.conf);
            for (byte[] familyKey : families = scan.getFamilies()) {
                String family = Bytes.toString((byte[])familyKey);
                List<FamilyRevision> abortedWriteTransactions = rm.getAbortedWriteTransactions(tableName, family);
                if (abortedWriteTransactions == null) continue;
                for (FamilyRevision revision : abortedWriteTransactions) {
                    abortedTransactions.add(revision.getRevision());
                }
            }
            HashSet<Long> hashSet = abortedTransactions;
            return hashSet;
        }
        finally {
            HBaseRevisionManagerUtil.closeRevisionManagerQuietly(rm);
        }
    }

    private long getMaximumRevision(Scan scan, TableSnapshot snapshot) {
        byte[][] families;
        long maxRevision = 0L;
        for (byte[] familyKey : families = scan.getFamilies()) {
            String family = Bytes.toString((byte[])familyKey);
            long revision = snapshot.getRevision(family);
            if (revision <= maxRevision) continue;
            maxRevision = revision;
        }
        return maxRevision;
    }

    public void setHTable(HTable htable) {
        this.htable = htable;
    }

    public void setScan(Scan scan) {
        this.scan = scan;
    }

    public ImmutableBytesWritable createKey() {
        return new ImmutableBytesWritable();
    }

    public Result createValue() {
        return new Result();
    }

    public long getPos() {
        return 0L;
    }

    public float getProgress() throws IOException {
        return 0.0f;
    }

    public boolean next(ImmutableBytesWritable key, Result value) throws IOException {
        if (this.resultItr == null) {
            LOG.warn("The HBase result iterator is found null. It is possible that the record reader has already been closed.");
        } else {
            while (this.resultItr.hasNext()) {
                Result temp = this.resultItr.next();
                Result hbaseRow = this.prepareResult(temp.list());
                if (hbaseRow == null) continue;
                key.set(hbaseRow.getRow());
                this.valueOut.reset();
                hbaseRow.write((DataOutput)this.valueOut);
                this.valueIn.reset(this.valueOut.getData(), this.valueOut.getLength());
                value.readFields((DataInput)this.valueIn);
                return true;
            }
        }
        return false;
    }

    private Result prepareResult(List<KeyValue> keyvalues) {
        Object cf;
        ArrayList finalKeyVals = new ArrayList();
        HashMap qualValMap = new HashMap();
        for (KeyValue kv : keyvalues) {
            cf = kv.getFamily();
            byte[] qualifier = kv.getQualifier();
            String key = Bytes.toString((byte[])cf) + ":" + Bytes.toString((byte[])qualifier);
            List kvs = qualValMap.containsKey(key) ? (List)qualValMap.get(key) : new ArrayList();
            String family = Bytes.toString((byte[])kv.getFamily());
            if (this.allAbortedTransactions.contains(kv.getTimestamp())) continue;
            long desiredTS = this.snapshot.getRevision(family);
            if (kv.getTimestamp() <= desiredTS) {
                kvs.add(kv);
            }
            qualValMap.put(key, kvs);
        }
        Set keys = qualValMap.keySet();
        Iterator i$ = keys.iterator();
        while (i$.hasNext()) {
            cf = (String)i$.next();
            List kvs = (List)qualValMap.get(cf);
            if (1 <= kvs.size()) {
                for (int i = 0; i < 1; ++i) {
                    finalKeyVals.add(kvs.get(i));
                }
                continue;
            }
            finalKeyVals.addAll(kvs);
        }
        if (finalKeyVals.size() == 0) {
            return null;
        }
        KeyValue[] kvArray = new KeyValue[finalKeyVals.size()];
        finalKeyVals.toArray(kvArray);
        return new Result(kvArray);
    }

    public void close() {
        this.resultItr = null;
        this.scanner.close();
    }
}

