/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hcatalog.hbase.snapshot;

import java.io.IOException;
import java.nio.charset.Charset;
import org.apache.hcatalog.hbase.snapshot.PathUtil;
import org.apache.hcatalog.hbase.snapshot.lock.LockListener;
import org.apache.hcatalog.hbase.snapshot.lock.WriteLock;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class IDGenerator
implements LockListener {
    private ZooKeeper zookeeper;
    private String zNodeDataLoc;
    private String zNodeLockBasePath;
    private long id;
    private static final Logger LOG = LoggerFactory.getLogger(IDGenerator.class);

    IDGenerator(ZooKeeper zookeeper, String tableName, String idGenNode) throws IOException {
        this.zookeeper = zookeeper;
        this.zNodeDataLoc = idGenNode;
        this.zNodeLockBasePath = PathUtil.getLockManagementNode(idGenNode);
    }

    public long obtainID() throws IOException {
        WriteLock wLock = new WriteLock(this.zookeeper, this.zNodeLockBasePath, ZooDefs.Ids.OPEN_ACL_UNSAFE);
        wLock.setLockListener(this);
        try {
            boolean lockGrabbed = wLock.lock();
            if (!lockGrabbed) {
                throw new IOException("Unable to obtain lock to obtain id.");
            }
            this.id = this.incrementAndReadCounter();
        }
        catch (KeeperException e) {
            LOG.warn("Exception while obtaining lock for ID.", (Throwable)e);
            throw new IOException("Exception while obtaining lock for ID.", e);
        }
        catch (InterruptedException e) {
            LOG.warn("Exception while obtaining lock for ID.", (Throwable)e);
            throw new IOException("Exception while obtaining lock for ID.", e);
        }
        finally {
            wLock.unlock();
        }
        return this.id;
    }

    public long readID() throws IOException {
        long curId;
        try {
            Stat stat = new Stat();
            byte[] data = this.zookeeper.getData(this.zNodeDataLoc, false, stat);
            curId = Long.parseLong(new String(data, Charset.forName("UTF-8")));
        }
        catch (KeeperException e) {
            LOG.warn("Exception while reading current revision id.", (Throwable)e);
            throw new IOException("Exception while reading current revision id.", e);
        }
        catch (InterruptedException e) {
            LOG.warn("Exception while reading current revision id.", (Throwable)e);
            throw new IOException("Exception while reading current revision id.", e);
        }
        return curId;
    }

    private long incrementAndReadCounter() throws IOException {
        long curId;
        try {
            Stat stat = new Stat();
            byte[] data = this.zookeeper.getData(this.zNodeDataLoc, false, stat);
            long usedId = Long.parseLong(new String(data, Charset.forName("UTF-8")));
            curId = usedId + 1L;
            String lastUsedID = String.valueOf(curId);
            this.zookeeper.setData(this.zNodeDataLoc, lastUsedID.getBytes(Charset.forName("UTF-8")), -1);
        }
        catch (KeeperException e) {
            LOG.warn("Exception while incrementing revision id.", (Throwable)e);
            throw new IOException("Exception while incrementing revision id. ", e);
        }
        catch (InterruptedException e) {
            LOG.warn("Exception while incrementing revision id.", (Throwable)e);
            throw new IOException("Exception while incrementing revision id. ", e);
        }
        return curId;
    }

    @Override
    public void lockAcquired() {
    }

    @Override
    public void lockReleased() {
    }
}

