/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hcatalog.hbase.snapshot;

import java.io.IOException;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.CoprocessorEnvironment;
import org.apache.hadoop.hbase.coprocessor.BaseEndpointCoprocessor;
import org.apache.hcatalog.hbase.snapshot.FamilyRevision;
import org.apache.hcatalog.hbase.snapshot.RevisionManager;
import org.apache.hcatalog.hbase.snapshot.RevisionManagerConfiguration;
import org.apache.hcatalog.hbase.snapshot.RevisionManagerFactory;
import org.apache.hcatalog.hbase.snapshot.RevisionManagerProtocol;
import org.apache.hcatalog.hbase.snapshot.TableSnapshot;
import org.apache.hcatalog.hbase.snapshot.Transaction;
import org.apache.hcatalog.hbase.snapshot.ZKBasedRevisionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RevisionManagerEndpoint
extends BaseEndpointCoprocessor
implements RevisionManagerProtocol {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)RevisionManagerEndpoint.class.getName());
    private RevisionManager rmImpl = null;

    public void start(CoprocessorEnvironment env) {
        super.start(env);
        try {
            Configuration conf = RevisionManagerConfiguration.create(env.getConfiguration());
            String className = conf.get("revision.manager.endpoint.impl.class", ZKBasedRevisionManager.class.getName());
            LOGGER.debug("Using Revision Manager implementation: {}", (Object)className);
            this.rmImpl = RevisionManagerFactory.getOpenedRevisionManager(className, conf);
        }
        catch (IOException e) {
            LOGGER.error("Failed to initialize revision manager", (Throwable)e);
        }
    }

    public void stop(CoprocessorEnvironment env) {
        if (this.rmImpl != null) {
            try {
                this.rmImpl.close();
            }
            catch (IOException e) {
                LOGGER.warn("Error closing revision manager.", (Throwable)e);
            }
        }
        super.stop(env);
    }

    @Override
    public void initialize(Configuration conf) {
    }

    @Override
    public void open() throws IOException {
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public void createTable(String table, List<String> columnFamilies) throws IOException {
        this.rmImpl.createTable(table, columnFamilies);
    }

    @Override
    public void dropTable(String table) throws IOException {
        this.rmImpl.dropTable(table);
    }

    @Override
    public Transaction beginWriteTransaction(String table, List<String> families) throws IOException {
        return this.rmImpl.beginWriteTransaction(table, families);
    }

    @Override
    public Transaction beginWriteTransaction(String table, List<String> families, long keepAlive) throws IOException {
        return this.rmImpl.beginWriteTransaction(table, families, keepAlive);
    }

    @Override
    public void commitWriteTransaction(Transaction transaction) throws IOException {
        this.rmImpl.commitWriteTransaction(transaction);
    }

    @Override
    public void abortWriteTransaction(Transaction transaction) throws IOException {
        this.rmImpl.abortWriteTransaction(transaction);
    }

    @Override
    public TableSnapshot createSnapshot(String tableName) throws IOException {
        return this.rmImpl.createSnapshot(tableName);
    }

    @Override
    public TableSnapshot createSnapshot(String tableName, long revision) throws IOException {
        return this.rmImpl.createSnapshot(tableName, revision);
    }

    @Override
    public void keepAlive(Transaction transaction) throws IOException {
        this.rmImpl.keepAlive(transaction);
    }

    @Override
    public List<FamilyRevision> getAbortedWriteTransactions(String table, String columnFamily) throws IOException {
        return this.rmImpl.getAbortedWriteTransactions(table, columnFamily);
    }
}

