/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hcatalog.hbase.snapshot;

import java.io.IOException;
import java.util.List;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hcatalog.hbase.snapshot.FamilyRevision;
import org.apache.hcatalog.hbase.snapshot.RevisionManager;
import org.apache.hcatalog.hbase.snapshot.RevisionManagerProtocol;
import org.apache.hcatalog.hbase.snapshot.TableSnapshot;
import org.apache.hcatalog.hbase.snapshot.Transaction;

public class RevisionManagerEndpointClient
implements RevisionManager,
Configurable {
    private Configuration conf = null;
    private RevisionManager rmProxy;

    public Configuration getConf() {
        return this.conf;
    }

    public void setConf(Configuration arg0) {
        this.conf = arg0;
    }

    @Override
    public void initialize(Configuration conf) {
    }

    @Override
    public void open() throws IOException {
        Configuration clonedConf = new Configuration(this.conf);
        clonedConf.setInt(HConstants.HBASE_CLIENT_RETRIES_NUMBER, 1);
        HTable table = new HTable(clonedConf, HConstants.ROOT_TABLE_NAME);
        this.rmProxy = (RevisionManager)table.coprocessorProxy(RevisionManagerProtocol.class, Bytes.toBytes((String)"anyRow"));
        this.rmProxy.open();
    }

    @Override
    public void close() throws IOException {
        this.rmProxy.close();
    }

    @Override
    public void createTable(String table, List<String> columnFamilies) throws IOException {
        this.rmProxy.createTable(table, columnFamilies);
    }

    @Override
    public void dropTable(String table) throws IOException {
        this.rmProxy.dropTable(table);
    }

    @Override
    public Transaction beginWriteTransaction(String table, List<String> families) throws IOException {
        return this.rmProxy.beginWriteTransaction(table, families);
    }

    @Override
    public Transaction beginWriteTransaction(String table, List<String> families, long keepAlive) throws IOException {
        return this.rmProxy.beginWriteTransaction(table, families, keepAlive);
    }

    @Override
    public void commitWriteTransaction(Transaction transaction) throws IOException {
        this.rmProxy.commitWriteTransaction(transaction);
    }

    @Override
    public void abortWriteTransaction(Transaction transaction) throws IOException {
        this.rmProxy.abortWriteTransaction(transaction);
    }

    @Override
    public List<FamilyRevision> getAbortedWriteTransactions(String table, String columnFamily) throws IOException {
        return this.rmProxy.getAbortedWriteTransactions(table, columnFamily);
    }

    @Override
    public TableSnapshot createSnapshot(String tableName) throws IOException {
        return this.rmProxy.createSnapshot(tableName);
    }

    @Override
    public TableSnapshot createSnapshot(String tableName, long revision) throws IOException {
        return this.rmProxy.createSnapshot(tableName, revision);
    }

    @Override
    public void keepAlive(Transaction transaction) throws IOException {
        this.rmProxy.keepAlive(transaction);
    }
}

