/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hcatalog.hbase.snapshot;

import java.io.IOException;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hcatalog.hbase.snapshot.RevisionManager;
import org.apache.hcatalog.hbase.snapshot.ZKBasedRevisionManager;

public class RevisionManagerFactory {
    public static final String REVISION_MGR_IMPL_CLASS = "revision.manager.impl.class";

    private static RevisionManager getRevisionManager(String className, Configuration conf) throws IOException {
        RevisionManager revisionMgr;
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader == null) {
            classLoader = RevisionManagerFactory.class.getClassLoader();
        }
        try {
            Class<RevisionManager> revisionMgrClass = Class.forName(className, true, classLoader).asSubclass(RevisionManager.class);
            revisionMgr = revisionMgrClass.newInstance();
            revisionMgr.initialize(conf);
        }
        catch (ClassNotFoundException e) {
            throw new IOException("The implementation class of revision manager not found.", e);
        }
        catch (InstantiationException e) {
            throw new IOException("Exception encountered during instantiating revision manager implementation.", e);
        }
        catch (IllegalAccessException e) {
            throw new IOException("IllegalAccessException encountered during instantiating revision manager implementation.", e);
        }
        catch (IllegalArgumentException e) {
            throw new IOException("IllegalArgumentException encountered during instantiating revision manager implementation.", e);
        }
        return revisionMgr;
    }

    static RevisionManager getOpenedRevisionManager(String className, Configuration conf) throws IOException {
        RevisionManager revisionMgr = RevisionManagerFactory.getRevisionManager(className, conf);
        if (revisionMgr instanceof Configurable) {
            ((Configurable)revisionMgr).setConf(conf);
        }
        revisionMgr.open();
        return revisionMgr;
    }

    public static RevisionManager getOpenedRevisionManager(Configuration conf) throws IOException {
        String className = conf.get(REVISION_MGR_IMPL_CLASS, ZKBasedRevisionManager.class.getName());
        return RevisionManagerFactory.getOpenedRevisionManager(className, conf);
    }
}

