/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.mapreduce.db;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sqoop.mapreduce.db.BasicRetrySQLFailureHandler;

public class SQLServerConnectionFailureHandler
extends BasicRetrySQLFailureHandler {
    private static final Log LOG = LogFactory.getLog(SQLServerConnectionFailureHandler.class);
    protected static final String CONNECTION_RESET_ERR_REGEX = "(^Connection reset)(.*?)";
    protected static final String SQLSTATE_CODE_CONNECTION_RESET = "08S01";
    protected static final String VALIDATION_QUERY = "SELECT CONVERT(NVARCHAR, CONTEXT_INFO()) AS contextInfo";

    @Override
    public boolean canHandleFailure(Throwable failureCause) {
        if (!super.canHandleFailure(failureCause)) {
            return false;
        }
        SQLException sqlEx = (SQLException)failureCause;
        String errStateCode = sqlEx.getSQLState();
        boolean canHandle = false;
        if (errStateCode != null) {
            canHandle = errStateCode == SQLSTATE_CODE_CONNECTION_RESET;
        } else {
            errStateCode = "NULL";
            String errMsg = sqlEx.getMessage();
            canHandle = errMsg.matches(CONNECTION_RESET_ERR_REGEX);
        }
        if (!canHandle) {
            LOG.warn((Object)("Cannot handle error with SQL State: " + errStateCode));
        }
        return canHandle;
    }

    @Override
    protected boolean validateConnection(Connection connection) throws SQLException {
        PreparedStatement stmt;
        ResultSet results;
        boolean isValid = false;
        String contextInfo = null;
        if (super.validateConnection(connection) && (results = (stmt = connection.prepareStatement(VALIDATION_QUERY)).executeQuery()).next()) {
            contextInfo = results.getString("contextInfo");
            LOG.info((Object)("Session context is: " + (contextInfo == null ? "NULL" : contextInfo)));
            isValid = true;
        }
        return isValid;
    }
}

