/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.util;

import java.io.File;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;

public final class TaskId {
    private TaskId() {
    }

    public static String get(Configuration conf, String defaultVal) {
        return conf.get("mapreduce.task.id", conf.get("mapred.task.id", defaultVal));
    }

    public static File getLocalWorkPath(Configuration conf) throws IOException {
        boolean createdDir;
        String taskAttemptStr;
        String tmpDir = conf.get("job.local.dir", "/tmp/");
        File taskAttemptDir = new File(tmpDir, taskAttemptStr = TaskId.get(conf, "task_attempt"));
        if (!taskAttemptDir.exists() && !(createdDir = taskAttemptDir.mkdirs())) {
            throw new IOException("Could not create missing task attempt dir: " + taskAttemptDir.toString());
        }
        return taskAttemptDir;
    }
}

