/*
 * Decompiled with CFR 0.152.
 */
package prantl.ant.eclipse;

import java.io.File;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import prantl.ant.eclipse.ClassPathElement;
import prantl.ant.eclipse.ClassPathGenerator;
import prantl.ant.eclipse.EclipseElement;
import prantl.ant.eclipse.EclipseOutput;
import prantl.ant.eclipse.FileEclipseOutput;
import prantl.ant.eclipse.ProjectElement;
import prantl.ant.eclipse.ProjectGenerator;
import prantl.ant.eclipse.SettingsElement;
import prantl.ant.eclipse.SettingsGenerator;

public class EclipseTask
extends Task {
    private EclipseElement eclipse;
    private EclipseOutput output;

    public EclipseTask() {
        this.eclipse = new EclipseElement();
        this.output = null;
    }

    protected EclipseTask(EclipseOutput object) {
        this.eclipse = object.getEclipse();
        this.output = object;
    }

    public ClassPathElement createClassPath() {
        this.eclipse.setClassPath(new ClassPathElement());
        return this.eclipse.getClassPath();
    }

    public ProjectElement createProject() {
        this.eclipse.setProject(new ProjectElement());
        return this.eclipse.getProject();
    }

    public SettingsElement createSettings() {
        this.eclipse.setSettings(new SettingsElement());
        return this.eclipse.getSettings();
    }

    public void execute() throws BuildException {
        if (this.output == null) {
            this.output = new FileEclipseOutput(this);
        }
        new SettingsGenerator(this).generate();
        new ProjectGenerator(this).generate();
        new ClassPathGenerator(this).generate();
    }

    EclipseElement getEclipse() {
        return this.eclipse;
    }

    EclipseOutput getOutput() {
        return this.output;
    }

    public void setDestDir(File dir) {
        this.eclipse.setDestDir(dir);
    }

    public void setErrorProperty(String name) {
        this.eclipse.setErrorProperty(name);
    }

    public void setFailOnError(boolean value) {
        this.eclipse.setFailOnError(value);
    }

    public void setMode(EclipseElement.Mode value) {
        this.eclipse.setMode(value);
    }

    public void setUpdateAlways(boolean flag) {
        this.eclipse.setUpdateAlways(flag);
    }
}

