import java.io.IOException;
import javax.microedition.io.Connector;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.midlet.MIDlet;
import com.kddi.io.DataFolderConnection;
class Board extends Canvas implements ChessLibrary {
	static MIDlet app;
	/*
	 * an int-array keeps piece position space = 0 wp = 1 wn = 2 ... bp = -1 bn = -2
	 * ... bk = -6
	 */
	static int[][] Position = new int[8][8];//[file][rank]
	static int width, height;
	static int PieceLength;
	static InputListener IL;
	StringBuffer msg;
	/*
	 * [0] = emptyWhiteSquare [1] = wp in WhiteSquare ... [7] = bp in
	 * WhiteSquare ... [13] = emptyBlackSquare [14] = wp in BlackSquare ...
	 * [20] = bp in BlackSquare [25] = bk in BlackSquare
	 */
	Image PieceSet;
	public Board(MIDlet app) {
		Board.app = app;
		IL = new InputListener();
		setCommandListener(IL);
		width = getWidth();
		height = getHeight();
		PieceLength = 15;
		setDefaultPieceSet();
		init();
		//		try {
		//			changePieceSet("regular");
		//		} catch (IOException e) {
		//			// TODO Auto-generated catch block
		//			setDefaultPieceSet();
		//		} catch (ArrayIndexOutOfBoundsException e) {
		//			// TODO Auto-generated catch block
		//			setDefaultPieceSet();
		//		}
	}
	private void changePieceSet(String name) throws IOException,
			ArrayIndexOutOfBoundsException {
		/*
		 * KDDIP-1.0-depend-codes. Get the list of available image-files
		 */
		DataFolderConnection conn = (DataFolderConnection) Connector.open(
				"datafolder://", Connector.READ);
		String[] list = conn.getList();
		conn.close();
		/*
		 * Search the file-name like "chessfonts29x29-[(String)name].xxx"
		 */
		int i = 0;
		for (;; i++) {
			if (!(list[i].startsWith("datafolder:/chessfonts"
					+ String.valueOf(PieceLength) + "-")
					&& list[i].endsWith(".png")
					|| list[i].endsWith(".jpg")
					|| list[i].endsWith(".jpeg") || list[i].endsWith(".gif") || list[i]
					.endsWith(".bmp"))) {
				continue;
			}
			if (list[i].substring(PieceLength, list[i].indexOf('.')).compareTo(
					name) >= 0)
				break;
		}
		/*
		 * We managed to find a new specified image-file.Now going to split it
		 * into pieces[] array
		 */
		conn = (DataFolderConnection) Connector.open(list[i], Connector.READ);
		byte[] data = new byte[(int) conn.getLength()];
		conn.openInputStream().read(data);
		conn.close();
		PieceSet = Image.createImage(data, 0, data.length);
	}
	private void init() {
		Position[0][7] = BR;
		Position[1][7] = BN;
		Position[2][7] = BB;
		Position[3][7] = BQ;
		Position[4][7] = BK;
		Position[5][7] = BB;
		Position[6][7] = BN;
		Position[7][7] = BR;
		for (int i = 0; i <= 7; i++) {
			Position[i][6] = BP;
		}
		Position[0][0] = WR;
		Position[1][0] = WN;
		Position[2][0] = WB;
		Position[3][0] = WQ;
		Position[4][0] = WK;
		Position[5][0] = WB;
		Position[6][0] = WN;
		Position[7][0] = WR;
		for (int i = 0; i <= 7; i++) {
			Position[i][1] = WP;
		}
	}
	public void paint(Graphics g) {
		/*
		 * draw boader and etc.//TODO
		 */
		int square = 0;//whitesquare = 0 blacksquare = 1
		/*
		 * deal with squares one square's length is 29 pix fit well on 240x266
		 * display
		 * 
		 * 4pix (border) + 29pix (square) * 8 + 4pix (border) = just 240pix
		 * 
		 * 4pix (border) + 15pix (square) * 8 + 4pix (border) = just 128pix
		 * 
		 * one square's length is prefferd to be odd number so that
		 * piece-images are easily centered
		 */
		g.setColor(0xFFFFFF);
		g.fillRect(0, 0, 120, 16);
		Image piece = Image.createImage(PieceLength, PieceLength);
		Graphics g2 = piece.getGraphics();
		for (int r = 7; r >= 0; r--) {
			for (int f = 0; f <= 7; f++) {
				int p = Position[f][r];
				if (p >= 0) { // space or whitepiece
					/*
					 * Copy a piece-image
					 */
					g2.drawImage(PieceSet, -PieceLength * (p + 13 * square), 0,
							Graphics.TOP | Graphics.LEFT);
				} else//blackpiece
				{
					/*
					 * Copy a piece-image
					 */
					g2.drawImage(PieceSet,
							-PieceLength * (6 - p + 13 * square), 0,
							Graphics.TOP | Graphics.LEFT);
				}
				/*
				 * draw the piece-image
				 */
				g.drawImage(piece, PieceLength * f + 4, PieceLength * (7 - r)
						+ 4 + 16, Graphics.TOP | Graphics.LEFT);
				/*
				 * swap squares
				 */
				square = (square + 1) % 2;
			}
			square = (square + 1) % 2;
		}
		g.setColor(0x2F2F2F);
		g.drawString(msg.toString(), 0, 0, Graphics.TOP | Graphics.LEFT);
	}
	private void setDefaultPieceSet() {
		try {
			PieceSet = Image.createImage("/chessfonts"
					+ String.valueOf(PieceLength) + "-regular.png");
		} catch (Exception ex) {
			ex.printStackTrace(); // never happen
		}
	}
	public void movepiece(int f, int r, int F, int R)// throws
	// IllegalMoveException
	{
		try {
			Position[F][R] = Position[f][r];
			Position[f][r] = SP;
		} catch (ArrayIndexOutOfBoundsException e) {
			//throw new IllegalMoveException();
		}
	}
	public void keyPressed(int param) {
		IL.keyPressed(param);
	}
	class InputListener implements CommandListener {
		/*
		 * (non-Javadoc)
		 * 
		 * @see javax.microedition.lcdui.CommandListener#commandAction(javax.microedition.lcdui.Command,
		 *        javax.microedition.lcdui.Displayable)
		 */
		int[] buf;
		int index;
		Command exit;
		public void commandAction(Command c, Displayable s) {
			if (c == exit) {
				app.notifyDestroyed();
			}
		}
		public void keyPressed(int param) {
			switch (param) {
				case KEY_NUM1 :
				//49
				case KEY_NUM2 :
				//50
				case KEY_NUM3 :
				case KEY_NUM4 :
				case KEY_NUM5 :
				case KEY_NUM6 :
				case KEY_NUM7 :
				case KEY_NUM8 :
					/*
					 * 'a' = 97
					 */
					if (index % 2 == 0) {
						msg.append((char) (param + 48));
					} else {
						msg.append((char) param);
					}
					buf[index] = param - KEY_NUM1;
					break;
				default :
					return;
			}
			if (index == 3) {
				movepiece(buf[0], buf[1], buf[2], buf[3]);
				index = -1;
				msg.delete(0, msg.length());
			}
			index++;
			repaint();
		}
		/**
		 *  
		 */
		public InputListener() {
			buf = new int[4];
			msg = new StringBuffer();
			exit = new Command("Exit", Command.SCREEN, 0);
			addCommand(exit);
		}
	}
}
/*
 * Created on 2004/03/31
 */
/**
 * @author Morita Yusuke First to read; this applet dosen't work without
 *            KDDIP-1.0 or higher MicroEdition-Profile and 240x266 or higher
 *            screen that the Java applet can opperate.
 */
public class WinboardClone extends MIDlet {
	static Board canvas;
	/**
	 *  
	 */
	public WinboardClone() {
		// TODO Auto-generated constructor stub
	}
	/*
	 * (non-Javadoc)
	 * 
	 * @see javax.microedition.midlet.MIDlet#destroyApp(boolean)
	 */
	protected void destroyApp(boolean arg0) //MIDP2 throws
	// MIDletStateChangeException
	{
		// TODO Auto-generated method stub
	}
	/*
	 * (non-Javadoc)
	 * 
	 * @see javax.microedition.midlet.MIDlet#pauseApp()
	 */
	protected void pauseApp() {
		// TODO Auto-generated method stub
	}
	/*
	 * (non-Javadoc)
	 * 
	 * @see javax.microedition.midlet.MIDlet#startApp()
	 */
	protected void startApp() //MIDP2 throws MIDletStateChangeException
	{
		// TODO Auto-generated method stub
		canvas = new Board(this);
		Display.getDisplay(this).setCurrent(canvas);
	}
}
