#pragma once

//////////////////////////////////////////////////////////////////////////

class Complex
{
public:
	Complex() : m_dbReal(0.0), m_dbImag(0.0) {}
	Complex(double dbReal, double dbImag) : m_dbReal(dbReal), m_dbImag(dbImag) {}
	~Complex() {}

	double Real() { return m_dbReal; }
	double Imag() { return m_dbImag; }
	double Norm() { return (m_dbReal * m_dbReal + m_dbImag * m_dbImag); }

	void Set(double dbReal, double dbImag)
	{
		m_dbReal = dbReal;
		m_dbImag = dbImag;
	}

	Complex operator +(Complex &c)
	{
		return Complex(this->m_dbReal + c.Real(), this->m_dbImag + c.Imag());
	}

	Complex operator *(Complex &c)
	{
		return Complex(this->m_dbReal * c.Real() - this->m_dbImag * c.Imag(),
					   this->m_dbReal * c.Imag() + this->m_dbImag * c.Real());
	}

private:
	double m_dbReal;
	double m_dbImag;
};

//////////////////////////////////////////////////////////////////////////

