#pragma once

//////////////////////////////////////////////////////////////////////////

class CStopwatch
{
private:
	LARGE_INTEGER m_liPerfFreq;
	LARGE_INTEGER m_liPerfStart;

public:
	CStopwatch()
	{
		QueryPerformanceFrequency(&m_liPerfFreq);
	}

	virtual ~CStopwatch() {}

	void Start()
	{
		QueryPerformanceCounter(&m_liPerfStart);
	}

	INT64 NowByMillisecond() const
	{
		LARGE_INTEGER liPerfNow;
		QueryPerformanceCounter(&liPerfNow);
		return (INT64)(((liPerfNow.QuadPart - m_liPerfStart.QuadPart) * 1000)
			/ m_liPerfFreq.QuadPart);
	}

	INT64 NowByMicrosecond() const
	{
		LARGE_INTEGER liPerfNow;
		QueryPerformanceCounter(&liPerfNow);
		return (INT64)(((liPerfNow.QuadPart - m_liPerfStart.QuadPart) * 1000000)
			/ m_liPerfFreq.QuadPart);
	}

	double NowBySecond() const
	{
		return static_cast<double>(NowByMicrosecond() / 1000000);
	}

	void GetHMS(CString &cs)
	{
		LARGE_INTEGER liPerfNow;
		UINT  uHour, uMinute, uSecond;
		INT64 liNowTime;

		QueryPerformanceCounter(&liPerfNow);
		liNowTime = (INT64)((liPerfNow.QuadPart - m_liPerfStart.QuadPart) 
			/ m_liPerfFreq.QuadPart);

		uHour   = static_cast<UINT>(liNowTime / 3600);
		uMinute = static_cast<UINT>((liNowTime - uHour * 3600) / 60);
		uSecond = static_cast<UINT>(liNowTime - (uHour * 3600 + uMinute * 60));

		cs.Format(_T("%02d:%02d:%02d"), uHour, uMinute, uSecond);
	}
};

//////////////////////////////////////////////////////////////////////////