#pragma once

#include <afxwin.h>

//////////////////////////////////////////////////////////////////////////

class CStringConvert
{
public:
	CStringConvert() {}
	virtual ~CStringConvert() {}

	CString DwToIPAddress(DWORD dwAddress)
	{
		CString cs;
		dwAddress = htonl(dwAddress);
		cs.Format(_T("%d.%d.%d.%d"),
			(dwAddress >> 24) & 0xff,
			(dwAddress >> 16) & 0xff,
			(dwAddress >> 8)  & 0xff,
			dwAddress & 0xff);
		return cs;		
	}

	CString DwToString(DWORD dwNumber)
	{
		CString cs;
		cs.Format(_T("%d"), dwNumber);
		return cs;
	}

	CString DbToString(double dwNumber)
	{
		CString cs;
		cs.Format(_T("%10.4lf"), dwNumber);
		return cs;
	}

	CString DbToHMSTime(double dbTime)
	{
		CString cs;
		UINT    uHour, uMinute, uSecond;

		uHour   = static_cast<UINT>(dbTime / 3600);
		uMinute = static_cast<UINT>((dbTime - uHour * 3600) / 60);
		uSecond = static_cast<UINT>(dbTime - (uHour * 3600 + uMinute * 60));
		cs.Format(_T("%02d:%02d:%02d"), uHour, uMinute, uSecond);

		return cs;
	}

	CString GetNowTime()
	{
		CString		cs;
		SYSTEMTIME  st;

		GetLocalTime(&st);
		cs.Format(_T("%04d/%02d/%02d %02d:%02d:%02d"),
			st.wYear, st.wMonth, st.wDay,
			st.wHour, st.wMinute, st.wSecond);

		return cs;
	}

	void BigNumToString(CString &csParam)
	{
		NUMBERFMT nf;
		TCHAR szBuf[100];

		lstrcpy(szBuf, csParam.GetBuffer(100));
		csParam.ReleaseBuffer();
		nf.NumDigits     = 0;
		nf.LeadingZero   = FALSE;
		nf.Grouping	     = 3;
		nf.lpDecimalSep  = _T(".");
		nf.lpThousandSep = _T(",");
		nf.NegativeOrder = 0;
		GetNumberFormat(LOCALE_USER_DEFAULT, 
						0, 
						szBuf, 
						&nf, 
						csParam.GetBuffer(), 
						100);
		csParam.ReleaseBuffer();
	}

	void StringToByteArray(CString &cs, CByteArray &data)
	{
		LPBYTE lpData;
		UINT   nLength;

		nLength = cs.GetLength();
		lpData = reinterpret_cast<LPBYTE>(static_cast<LPTSTR>(cs.GetBuffer()));
		data.SetSize(cs.GetLength() * sizeof(TCHAR));
		CopyMemory(data.GetData(), lpData, data.GetSize());
		cs.ReleaseBuffer();
		data.FreeExtra();
	}

	void ByteArrayToString(CByteArray &data, CString &cs)
	{
		cs.SetString(reinterpret_cast<LPTSTR>(data.GetData()), data.GetSize() / sizeof(TCHAR));
	}
};

//////////////////////////////////////////////////////////////////////////