<?php

class EntryIndex
{
    var $_index;

    var $_sortkey;
    var $_sortorder;

    function EntryIndex() {
        $this->_index = array();
    }

    function &getIndex() {
        return $this->_index;
    }

    function sync($entry_dir = ENTRY_DATA_DIR) {
        $this->_index = array();

        $files = glob($entry_dir.'/*.txt');
        if (!$files) {
            return;
        }

        foreach ($files as $filename) {
            $fileinfo = pathinfo($filename);
            $filename = $fileinfo['basename'];

            $this->update($filename);
        }

        return $this->_index;
    }

    function save($indexfile = ENTRY_INDEX_FILE) {
        $fp = fopen($indexfile, 'w');
        if (!$fp) {die(LIB_ENTRYINDEX_CANNOTOPEN);}
        if (!flock($fp, LOCK_EX)) {die(LIB_ENTRYINDEX_CANNOTLOCK);}

        foreach ($this->_index as $filename => $entry_data) {
            $line = $filename."\t".$entry_data['date']."\t".$entry_data['title']."\n";
            fwrite($fp, $line);
        }

        fclose($fp);
    }

    function load($indexfile = ENTRY_INDEX_FILE) {
        $this->_index = array();

        if (file_exists($indexfile)) {

            if (filesize($indexfile) > 0) {
                $fp = fopen($indexfile, 'r');
            } else {
                $fp = fopen($indexfile, 'w+');
                echo '<a href="http://localhost/windblog/admin.php?cmd=makeindex">'.TMP_ADMINMENU_REINDEX.'</a>';
                debuglog($type = 'Info', $msg = 'NoFileindex');
                exit();
            }
        } else {
            $fp = fopen($indexfile, 'w+');
            echo '<a href="http://localhost/windblog/admin.php?cmd=makeindex">'.TMP_ADMINMENU_REINDEX.'</a>';
            debuglog($type = 'Info', $msg = 'NoFileindex');
            exit();
        }

        if (!flock($fp, LOCK_SH)) {die(LIB_ENTRYINDEX_CANNOTLOCK);}
        while (!feof($fp)) {
            $line = fgets($fp);
            if (trim($line) == '') {continue;}

            list($filename, $date, $title) = explode("\t", $line, 3);

            $this->_index[$filename] = array(
                'date' => intval($date),
                'title' => rtrim($title),
            );
        }
        fclose($fp);

        return $this->_index;
    }

    function update($entryfile) {
        $entry_data = load_entry_data($entryfile);
        $this->_index[$entry_data['filename']] = array(
            'date' => $entry_data['date'],
            'title' => $entry_data['title'],
        );
        return $this->_index;
    }

    function remove($entryfile) {
        if (isset($this->_index[$entryfile])) {
            unset($this->_index[$entryfile]);
        } else {
            die(LIB_ENTRYINDEX_NOFILE);
        }
    }

    function select($key, $value) {
        $result = array();
        foreach ($this->_index as $filename => $entry_data) {
            switch ($key) {
            case 'date':
                $date = date('Ymd', $entry_data['date']);
                if (preg_match('/^'.preg_quote($value).'/', $date)) {
                    $result[$filename] = $entry_data;
                }
                break;
            case 'title':
                $title = $entry_data['title'];
                if (preg_match('/'.preg_quote($value).'/', $title)) {
                    $result[$filename] = $entry_data;
                }
                break;
            }
        }
        $this->_index = $result;
        return $this->_index;
    }

    function sort($key, $order = TRUE) {
        $this->_sortkey = $key;
        $this->_sortorder = $order;
        uksort($this->_index, array(&$this, '_sort_helper'));
        return $this->_index;
    }

    function _sort_helper($filenameA, $filenameB) {
        $valueA = $this->_index[$filenameA][$this->_sortkey];
        $valueB = $this->_index[$filenameB][$this->_sortkey];
        switch ($this->_sortkey) {
        case 'date':
            if ($valueA == $valueB) {return 0;}
            return ($valueA > $valueB ? 1 : -1) * ($this->_sortorder ? 1 : -1);
            break;
        case 'title':
            return strcmp($valueA, $valueB) * ($this->_sortorder ? 1 : -1);
            break;
        }
    }
}

?>
