<?php

function e($str) {
    echo $str;

}

function h($str) {
    return htmlspecialchars($str);

}

function u($str) {
    return urlencode($str);

}

function eh($str) {
    e(h($str));

}

function eu($str) {
    e(u($str));

}

function text_to_html($text) {
    $result = htmlspecialchars($text);
    $result = str_replace("\n", '<br>'."\n", $result);
    $result = preg_replace('/http:\/\/[0-9a-z_,.:;&=+*%$#!?@()~\'\/-]+/i', '<a href="$0" class="autolinked">$0</a>', $result);
    $result = preg_replace('/\s+([a-z0-9_\-.]+@([a-z0-9_\-]+\.)+[a-z]+)\s+/i', '<a href="mailto:$0" class="autolinked">$0</a>', $result);

    return $result;

}

function show_template($_filename, $_data = array()) {
    extract($_data);
    include TEMPLATE_DIR.'/'.$_filename;

}

function capture_template($_filename, $_data = array()) {
    ob_start();
    show_template($_filename, $_data);
    $result = ob_get_contents();
    ob_end_clean();
    return $result;

}

function unmagicquote() {
    if (get_magic_quotes_gpc()) {
        foreach (array('_GET', '_POST', '_COOKIE') as $varname) {
            foreach ($GLOBALS[$varname] as $key => $value) {
                if ( preg_match('/\0/',$value) ) { die( MSG_ILLEGAL_ACCESS ); }
                $GLOBALS[$varname][$key] = stripslashes($value);
            }
        }
    } else {
        foreach (array('_GET', '_POST', '_COOKIE') as $varname) {
            foreach ($GLOBALS[$varname] as $key => $value) {
                if ( preg_match('/\0/',$value) ) { die( MSG_ILLEGAL_ACCESS ); }
            }
        }
    }

}

function to_euc($str, $from = 'auto') {
    if (is_array($str)) {
        $result = array();
        foreach ($str as $key => $value) {
            $result[$key] = to_euc($value, $from);
        }
        return $result;
    } else {
        return mb_convert_encoding($str, 'euc-jp', $from);
    }
}

function to_utf8($str, $from = 'auto') {
    if (is_array($str)) {
        $result = array();
        foreach ($str as $key => $value) {
            $result[$key] = to_utf8($value, $from);
        }
        return $result;
    } else {
        return mb_convert_encoding($str, 'utf8', $from);
    }

}

function fileindex($dir = BLOG_ROOT_DIR) {
    $filelist = scandir($dir);
    if ($filelist[0] === '.') array_shift($filelist);
    if ($filelist[0] === '..') array_shift($filelist);
    return $filelist;

}

function status2_fileindex($dir) {
    $dirs = fileindex($dir);
    foreach ($dirs as $key => $value) {
        $fileexsit = file_exists($dir.'/'.$value) ? '1' : '0';
        $filesize  = number_format(filesize($dir.'/'.$value));
        $filemtime = date('y/n/j H:i:s', filemtime($dir.'/'.$value));
        $filer     = is_readable($dir.'/'.$value) ? '1' : '0';
        $filew     = is_writable($dir.'/'.$value) ? '1' : '0';
        if (mb_strpos($value, '.') === FALSE) {
            echo '<tr><td><b>'.$value.'</b></td><td><b>'.$filesize.'</b></td>';
            echo '<td><b>'.$filemtime.'</b></td><td><b>'.$filer.'</b></td>';
            echo '<td><b>'.$filew.'</b></td></tr>';
        } else {
            echo '<tr><td>'.$value.'</td><td>'.$filesize.'</td>';
            echo '<td>'.$filemtime.'</td><td>'.$filer.'</td><td>'.$filew.'</td></tr>';
        }
    }

}

function debuglog($type = 'Info', $msg = '') {
    if ( SW_DEBUGMODE == '1' ) {
        $logdata = date('YmdHis')."\t".
                   h($type)."\t".
                   h(@__FILE__)."\t".
                   h(@__FUNCTION__)."\t".
                   h(@__CLASS__)."\t".
                   h(@__METHOD__)."\t".
                   h(@gethostbyaddr($_SERVER['REMOTE_ADDR']))."(".
                   h(@$_SERVER['REMOTE_ADDR']).")\t".
                   h(@$_SERVER['HTTP_USER_AGENT'])."\t".
                   h(@$_SERVER['HTTP_REFERER']);

        if (!$msg == '') { $logdata = $logdata."\t".h($msg)."\t"; }
        $logdata = $logdata."\n";
        $logdata = h($logdata);
        $fplog = fopen(BLOG_LOGGING_DIR.'/logging_all_'.date('Ymd').'.cgi','a+b');
        flock($fplog,LOCK_EX);
        fwrite($fplog,$logdata);
        fclose($fplog);
    }

}
