<?php

function render_entry_body($entry_data) {
    switch ($entry_data['format']) {
        case 'HTML':
            return $entry_data['body'];
            break;
        case 'TEXT':
            return text_to_html($entry_data['body']);
            break;
        default:
            die(MSG_ILLEGAL_ACCESS);
            break;
    }
}

function load_entry_data($filename) {
    $fp = fopen(ENTRY_DATA_DIR . '/' . $filename, 'r');
    if (!$fp) {die(LIB_ENTRYLIB_CANNOTOPEN);}

    if (!flock($fp, LOCK_SH)) {die(LIB_ENTRYLIB_CANNOTLOCK);}

    $entry_data = array();

    while ($line = fgets($fp)) {
        $line = rtrim($line, "\r\n");
        if ($line == '') {break;}

        list($name, $value) = explode(':', $line, 2);
        $name = strtolower(trim($name));
        $value = trim($value);

        $entry_data[$name] = $value;
    }

    $entry_data['body'] = '';
    while ($line = fgets($fp)) {
        $entry_data['body'] .= $line;
    }

    fclose($fp);

    $entry_data['filename'] = $filename;

    return $entry_data;
}

function save_entry_data($entry_data) {
    $filename = ENTRY_DATA_DIR . '/' . $entry_data['filename'];

    $fp = fopen($filename, 'w');
    if (!$fp) {die(LIB_ENTRYLIB_CANNOTOPEN);}
    if (!flock($fp, LOCK_EX)) {die(LIB_ENTRYLIB_CANNOTLOCK);}

    $headers = array('title', 'date', 'format');
    foreach ($headers as $header) {
        fwrite($fp, @mb_convert_encoding($header, "UTF-8", "auto").': ' . @mb_convert_encoding($entry_data[$header], "UTF-8", "auto") . "\n");
    }

    fwrite($fp, "\n");

    fwrite($fp, @mb_convert_encoding($entry_data['body'], "UTF-8", "auto"));
    fclose($fp);

    $index =& new EntryIndex();
    $index->load();
    $index->update($entry_data['filename']);
    $index->save();
}

function delete_entry_data($entry_data) {
    unlink(ENTRY_DATA_DIR . '/' . $entry_data['filename']);
    $index =& new EntryIndex();
    $index->load();
    $index->remove($entry_data['filename']);
    $index->save();
}

function get_entry_list() {
    $index =& new EntryIndex();
    return $index->load();
}

function get_recent_entry_list($max = 10) {
    $index =& new EntryIndex();
    $index->load();
    $entry_list = get_entry_list();
    $entry_list = array();
    foreach (array_slice($index->sort('date', FALSE), 0, $max) as $filename => $entry_data) {
        $entry_list[] = load_entry_data($filename);
    }
    return $entry_list;
}

function _sort_recent_entry_list($entry_data1, $entry_data2) {
    if ($entry_data1['date'] == $entry_data2['date']) {return 0;}
    return ($entry_data1['date'] > $entry_data2['date']) ? -1 : 1;
}

function is_valid_entry_data($entry_data) {
    $result = array();

    $fields = array(
        'cmd' => LIB_ENTRYLIB_ISVALID_CMD,
        'filename' => LIB_ENTRYLIB_ISVALID_FILENAME,
        'title' => LIB_ENTRYLIB_ISVALID_TITLE,
        'date' => LIB_ENTRYLIB_ISVALID_DATE,
        'format' => LIB_ENTRYLIB_ISVALID_FORMAT,
        'body' => LIB_ENTRYLIB_ISVALID_BODY,
    );

    $requires = array('cmd', 'filename', 'title', 'date', 'format', 'body');
    foreach ($requires as $name) {
        if (!isset($entry_data[$name]) || $entry_data[$name] == '') {
            $result[] = LIB_ENTRYLIB_BLANK1.$fields[$name].LIB_ENTRYLIB_BLANK2;
        }
    }
    if (count($result) > 0) {return $result;}

    $lengths = array(
        'filename' => 50,
        'title' => 100,
        'date' => 32,
        'format' => 10,
        'body' => 100000,
    );
    foreach ($lengths as $name => $length) {
        if (strlen($entry_data[$name]) > $length) {
            $result[] = LIB_ENTRYLIB_TOOLONG1.$fields[$name].LIB_ENTRYLIB_TOOLONG2;
        }
    }
    if (count($result) > 0) {return $result;}

    if (!preg_match('/^[0-9A-Za-z\-_]+\.txt$/', $entry_data['filename'])) {
        $result[] = LIB_ENTRYLIB_BADCHAR1.$fields['filename'].LIB_ENTRYLIB_BADCHAR2;
    }

    if ($entry_data['date'] <= 0) {
        $result[] = LIB_ENTRYLIB_BADDATE1.$fields['date'].LIB_ENTRYLIB_BADDATE2;
    }

    $formats = array('TEXT', 'HTML');
    if (!in_array($entry_data['format'], $formats)) {
        $result[] = LIB_ENTRYLIB_BADFORMAT1.$fields['format'].LIB_ENTRYLIB_BADFORMAT2;
    }

    if ($entry_data['cmd'] == 'new' && file_exists(ENTRY_DATA_DIR . '/' . $entry_data['filename'])) {
        $result[] = LIB_ENTRYLIB_EXISTEDYET;
    }

    if ($entry_data['cmd'] == 'edit' && !file_exists(ENTRY_DATA_DIR . '/' . $entry_data['filename'])) {
        $result[] = LIB_ENTRYLIB_NOFILE;
    }

    if (count($result) > 0) {return $result;}

    return NULL;
}

function init_entry_data() {
    $data = array(
        'cmd' => 'new',
        'filename' => date('YmdHis').'.txt',
        'title' => '',
        'date' => time(),
        'format' => 'TEXT',
        'body' => ''
    );
    return $data;
}

function import_entry_data() {
    $data = array(
        'cmd' => isset($_POST['cmd']) ? $_POST['cmd'] : 'new',
        'filename' => isset($_POST['filename']) ? $_POST['filename'] : '',
        'title' => isset($_POST['title']) ? $_POST['title'] : '',
        'date' => isset($_POST['date']) ? strtotime($_POST['date']) : time(),
        'format' => isset($_POST['format']) ? $_POST['format'] : 'TEXT',
        'body' => isset($_POST['body']) ? $_POST['body'] : ''
    );
    return $data;
}
