/*
 * Decompiled with CFR 0.152.
 */
package com.epam.parso.date;

import com.epam.parso.date.NotImplementedException;
import com.epam.parso.date.SasTemporalConstants;
import com.epam.parso.date.SasTemporalFormat;
import com.epam.parso.date.SasTemporalUtils;
import java.math.BigDecimal;
import java.time.format.DateTimeFormatter;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

enum SasDateTimeFormat implements SasTemporalFormat
{
    DATETIME(16){

        private String getNoFractionDatePattern(int width) {
            if (width >= 19) {
                return "ddMMMyyyy:HH:mm:ss";
            }
            switch (width) {
                case 7: 
                case 8: {
                    return "ddMMMyy";
                }
                case 9: {
                    return "ddMMMyyyy";
                }
                case 10: 
                case 11: 
                case 12: {
                    return "ddMMMyy:HH";
                }
                case 13: 
                case 14: 
                case 15: {
                    return "ddMMMyy:HH:mm";
                }
            }
            return "ddMMMyy:HH:mm:ss";
        }

        @Override
        public String getDatePattern(int width, int precision) {
            int noFractionWidth = width - precision;
            if (noFractionWidth < 16) {
                noFractionWidth = width;
            }
            String noFractionString = this.getNoFractionDatePattern(noFractionWidth);
            if (precision > 0) {
                int fractionWidth = Math.min(precision, width - 17);
                if (fractionWidth == 0) {
                    return noFractionString + '.';
                }
                if (fractionWidth > 0) {
                    return noFractionString + '.' + SasTemporalUtils.nChars('S', fractionWidth);
                }
            }
            return noFractionString;
        }

        @Override
        public int getActualPrecision(int width, int precision) {
            return width > this.getDefaultWidth() ? Math.min(width - this.getDefaultWidth(), precision) : 0;
        }

        @Override
        public Function<Double, String> getInternalFormatFunction(int width, int precision) {
            return super.getInternalFormatFunction(width, precision).andThen(String::toUpperCase);
        }
    }
    ,
    B8601DN(10){

        @Override
        public String getDatePattern(int width, int precision) {
            return "yyyyMMdd";
        }
    }
    ,
    B8601DT(19){

        @Override
        protected String getDatePattern(int width, int precision) {
            return null;
        }

        @Override
        public Function<Double, String> getInternalFormatFunction(int width, int precision) {
            throw new NotImplementedException();
        }
    }
    ,
    B8601DX(26){

        @Override
        protected String getDatePattern(int width, int precision) {
            return null;
        }

        @Override
        public Function<Double, String> getInternalFormatFunction(int width, int precision) {
            throw new NotImplementedException();
        }
    }
    ,
    B8601DZ(26){

        @Override
        protected String getDatePattern(int width, int precision) {
            return null;
        }

        @Override
        public Function<Double, String> getInternalFormatFunction(int width, int precision) {
            throw new NotImplementedException();
        }
    }
    ,
    B8601LX(26){

        @Override
        protected String getDatePattern(int width, int precision) {
            return null;
        }

        @Override
        public Function<Double, String> getInternalFormatFunction(int width, int precision) {
            throw new NotImplementedException();
        }
    }
    ,
    E8601DN(10){

        @Override
        public String getDatePattern(int width, int precision) {
            return "yyyy-MM-dd";
        }
    }
    ,
    E8601DT(19){

        @Override
        protected String getDatePattern(int width, int precision) {
            return null;
        }

        @Override
        public Function<Double, String> getInternalFormatFunction(int width, int precision) {
            throw new NotImplementedException();
        }
    }
    ,
    E8601DX(26){

        @Override
        protected String getDatePattern(int width, int precision) {
            return null;
        }

        @Override
        public Function<Double, String> getInternalFormatFunction(int width, int precision) {
            throw new NotImplementedException();
        }
    }
    ,
    E8601DZ(26){

        @Override
        protected String getDatePattern(int width, int precision) {
            return null;
        }

        @Override
        public Function<Double, String> getInternalFormatFunction(int width, int precision) {
            throw new NotImplementedException();
        }
    }
    ,
    E8601LX(26){

        @Override
        protected String getDatePattern(int width, int precision) {
            return null;
        }

        @Override
        public Function<Double, String> getInternalFormatFunction(int width, int precision) {
            throw new NotImplementedException();
        }
    }
    ,
    DATEAMPM(19){

        @Override
        protected String getDatePattern(int width, int precision) {
            return null;
        }

        @Override
        public Function<Double, String> getInternalFormatFunction(int width, int precision) {
            throw new NotImplementedException();
        }
    }
    ,
    DTDATE(7){

        @Override
        public String getDatePattern(int width, int precision) {
            switch (width) {
                case 9: {
                    return "ddMMMyyyy";
                }
                case 5: 
                case 6: {
                    return "ddMMM";
                }
            }
            return "ddMMMyy";
        }

        @Override
        public Function<Double, String> getInternalFormatFunction(int width, int precision) {
            return super.getInternalFormatFunction(width, precision).andThen(String::toUpperCase);
        }
    }
    ,
    DTMONYY(5){

        @Override
        public String getDatePattern(int width, int precision) {
            switch (width) {
                case 7: {
                    return "MMMyyyy";
                }
            }
            return "MMMyy";
        }

        @Override
        public Function<Double, String> getInternalFormatFunction(int width, int precision) {
            return super.getInternalFormatFunction(width, precision).andThen(String::toUpperCase);
        }
    }
    ,
    DTWKDATX(29){

        @Override
        protected String getDatePattern(int width, int precision) {
            return null;
        }

        @Override
        public Function<Double, String> getInternalFormatFunction(int width, int precision) {
            throw new NotImplementedException();
        }
    }
    ,
    DTYEAR(4){

        @Override
        public String getDatePattern(int width, int precision) {
            switch (width) {
                case 2: 
                case 3: {
                    return "yy";
                }
            }
            return "yyyy";
        }
    }
    ,
    MDYAMPM(10){

        @Override
        protected String getDatePattern(int width, int precision) {
            return null;
        }

        @Override
        public Function<Double, String> getInternalFormatFunction(int width, int precision) {
            throw new NotImplementedException();
        }
    }
    ,
    TOD(8){

        @Override
        protected String getDatePattern(int width, int precision) {
            return null;
        }

        @Override
        public int getActualPrecision(int width, int precision) {
            return width > this.getDefaultWidth() ? Math.min(width - this.getDefaultWidth(), precision) : 0;
        }

        private BigDecimal daySeconds(double sasSeconds, int precision) {
            BigDecimal bigSeconds = SasTemporalUtils.roundSeconds(sasSeconds, precision).abs().remainder(SasTemporalConstants.BIG_SECONDS_IN_DAY);
            if (sasSeconds < 0.0 && bigSeconds.compareTo(BigDecimal.ZERO) > 0) {
                bigSeconds = SasTemporalConstants.BIG_SECONDS_IN_DAY.subtract(bigSeconds);
            }
            return bigSeconds;
        }

        @Override
        public Function<Double, String> getInternalFormatFunction(int width, int precision) {
            return sasSeconds -> {
                String hh;
                BigDecimal daySeconds = this.daySeconds((double)sasSeconds, precision);
                BigDecimal[] parts = daySeconds.divideAndRemainder(SasTemporalConstants.BIG_SECONDS_IN_HOUR);
                int adjustedPrecision = precision;
                int firstTwoDigitsNumberAfterSingleDigit = 10;
                if (parts[0].longValue() >= (long)firstTwoDigitsNumberAfterSingleDigit && precision > 0 && width - precision == 8) {
                    adjustedPrecision = precision - 1;
                    daySeconds = this.daySeconds((double)sasSeconds, adjustedPrecision);
                    parts = daySeconds.divideAndRemainder(SasTemporalConstants.BIG_SECONDS_IN_HOUR);
                }
                if ((hh = String.valueOf(parts[0].longValue())).length() == 1 && width != 4 && width != 7 && (adjustedPrecision <= 0 || width - 8 != adjustedPrecision)) {
                    hh = '0' + hh;
                }
                if (hh.length() > width - 3) {
                    return hh;
                }
                parts = parts[1].divideAndRemainder(SasTemporalConstants.BIG_SECONDS_IN_MINUTE);
                String mm3 = String.valueOf(parts[0].longValue());
                String hhmm = hh + (mm3.length() == 1 ? ":0" : ":") + mm3;
                if (hhmm.length() > width - 3) {
                    return hhmm;
                }
                String ss = String.valueOf(parts[1].longValue());
                String hhmmss = hhmm + (ss.length() == 1 ? ":0" : ":") + ss;
                if (adjustedPrecision == 0 || hhmmss.length() > width - adjustedPrecision) {
                    return hhmmss;
                }
                adjustedPrecision = Math.min(adjustedPrecision, width - hhmmss.length());
                String nanos = parts[1].remainder(BigDecimal.ONE).toString().substring(1, adjustedPrecision + 2);
                return hhmmss + nanos;
            };
        }
    };

    private static final Logger LOGGER;
    private final int defaultWidth;

    private SasDateTimeFormat(int defaultWidth) {
        this.defaultWidth = defaultWidth;
    }

    @Override
    public final int getDefaultWidth() {
        return this.defaultWidth;
    }

    protected abstract String getDatePattern(int var1, int var2);

    @Override
    public final Function<Double, String> getFallbackFormatFunction(int width, int precision) {
        LOGGER.warn("Note that {}{}.{} format is not yet supported, using DATETIME. instead.", this.name(), width > 0 ? Integer.valueOf(width) : "", precision > 0 ? Integer.valueOf(precision) : "");
        return DATETIME.getInternalFormatFunction(16, 0);
    }

    @Override
    public Function<Double, String> getInternalFormatFunction(int width, int precision) {
        String datePattern = this.getDatePattern(width, precision);
        DateTimeFormatter formatter = SasTemporalUtils.createDateTimeFormatterFromPattern(datePattern);
        return sasSeconds -> formatter.format(SasTemporalUtils.sasSecondsToLocalDateTime(sasSeconds, precision));
    }

    static {
        LOGGER = LoggerFactory.getLogger(SasDateTimeFormat.class);
    }
}

