/*
 * Decompiled with CFR 0.152.
 */
package com.epam.parso.date;

import com.epam.parso.date.OutputDateType;
import com.epam.parso.date.SasDateFormat;
import com.epam.parso.date.SasDateTimeFormat;
import com.epam.parso.date.SasTemporalUtils;
import com.epam.parso.date.SasTimeFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;

public class SasTemporalFormatter {
    private final Map<String, Function<Double, String>> dateFormatFunctions = new HashMap<String, Function<Double, String>>();
    private final Map<String, Function<Double, String>> timeFormatFunctions = new HashMap<String, Function<Double, String>>();
    private final Map<String, Function<Double, String>> dateTimeFormatFunctions = new HashMap<String, Function<Double, String>>();

    public Date formatSasSecondsAsJavaDate(double sasSeconds) {
        sasSeconds = SasTemporalUtils.sasLeapSecondsFix(sasSeconds);
        return SasTemporalUtils.sasSecondsToDate(sasSeconds);
    }

    public Object formatSasDate(Double sasDays, OutputDateType dateFormatType, String sasFormatName, int width, int precision) {
        if (dateFormatType == OutputDateType.SAS_VALUE) {
            return sasDays;
        }
        if (sasDays == null || Double.isNaN(sasDays)) {
            if (dateFormatType == OutputDateType.SAS_FORMAT_EXPERIMENTAL || dateFormatType == OutputDateType.SAS_FORMAT_TRIM_EXPERIMENTAL) {
                return ".";
            }
            return null;
        }
        sasDays = SasTemporalUtils.sasLeapDaysFix(sasDays);
        switch (dateFormatType) {
            case EPOCH_SECONDS: {
                return SasTemporalUtils.sasDaysToEpochSeconds(sasDays);
            }
            case JAVA_TEMPORAL: {
                return SasTemporalUtils.sasDaysToLocalDate(sasDays);
            }
            case SAS_FORMAT_EXPERIMENTAL: 
            case SAS_FORMAT_TRIM_EXPERIMENTAL: {
                boolean trim = dateFormatType == OutputDateType.SAS_FORMAT_TRIM_EXPERIMENTAL;
                return this.dateFormatFunctions.computeIfAbsent(sasFormatName + width + "." + precision, k -> SasDateFormat.valueOf(sasFormatName).getFormatFunction(width, precision, trim)).apply(sasDays);
            }
        }
        return SasTemporalUtils.sasDaysToDate(sasDays);
    }

    public Object formatSasTime(Double sasSeconds, OutputDateType dateFormatType, String sasFormatName, int width, int precision) {
        if (dateFormatType == OutputDateType.SAS_VALUE) {
            return sasSeconds;
        }
        if (sasSeconds == null || Double.isNaN(sasSeconds)) {
            if (dateFormatType == OutputDateType.SAS_FORMAT_EXPERIMENTAL || dateFormatType == OutputDateType.SAS_FORMAT_TRIM_EXPERIMENTAL) {
                return ".";
            }
            return null;
        }
        switch (dateFormatType) {
            case SAS_FORMAT_EXPERIMENTAL: 
            case SAS_FORMAT_TRIM_EXPERIMENTAL: {
                boolean trim = dateFormatType == OutputDateType.SAS_FORMAT_TRIM_EXPERIMENTAL;
                return this.timeFormatFunctions.computeIfAbsent(sasFormatName + width + "." + precision, k -> SasTimeFormat.valueOf(sasFormatName).getFormatFunction(width, precision, trim)).apply(sasSeconds);
            }
        }
        long longSeconds = Math.round(sasSeconds);
        if (Math.abs(sasSeconds - (double)longSeconds) > 0.0) {
            return sasSeconds;
        }
        return longSeconds;
    }

    public Object formatSasDateTime(Double sasSeconds, OutputDateType dateFormatType, String sasFormatName, int width, int precision) {
        if (dateFormatType == OutputDateType.SAS_VALUE) {
            return sasSeconds;
        }
        if (sasSeconds == null || Double.isNaN(sasSeconds)) {
            if (dateFormatType == OutputDateType.SAS_FORMAT_EXPERIMENTAL || dateFormatType == OutputDateType.SAS_FORMAT_TRIM_EXPERIMENTAL) {
                return ".";
            }
            return null;
        }
        sasSeconds = SasTemporalUtils.sasLeapSecondsFix(sasSeconds);
        switch (dateFormatType) {
            case EPOCH_SECONDS: {
                return SasTemporalUtils.sasSecondsToEpochSeconds(sasSeconds);
            }
            case JAVA_TEMPORAL: {
                return SasTemporalUtils.sasSecondsToLocalDateTime(sasSeconds, 9);
            }
            case SAS_FORMAT_EXPERIMENTAL: 
            case SAS_FORMAT_TRIM_EXPERIMENTAL: {
                boolean trim = dateFormatType == OutputDateType.SAS_FORMAT_TRIM_EXPERIMENTAL;
                return this.dateTimeFormatFunctions.computeIfAbsent(sasFormatName + width + "." + precision, k -> SasDateTimeFormat.valueOf(sasFormatName).getFormatFunction(width, precision, trim)).apply(sasSeconds);
            }
        }
        return SasTemporalUtils.sasSecondsToDate(sasSeconds);
    }

    public static boolean isDateFormat(String sasFormatName) {
        for (SasDateFormat s2 : SasDateFormat.values()) {
            if (!s2.name().equals(sasFormatName)) continue;
            return true;
        }
        return false;
    }

    public static boolean isTimeFormat(String sasFormatName) {
        for (SasTimeFormat s2 : SasTimeFormat.values()) {
            if (!s2.name().equals(sasFormatName)) continue;
            return true;
        }
        return false;
    }

    public static boolean isDateTimeFormat(String sasFormatName) {
        for (SasDateTimeFormat s2 : SasDateTimeFormat.values()) {
            if (!s2.name().equals(sasFormatName)) continue;
            return true;
        }
        return false;
    }
}

