/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.batch.fs;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.ArrayBlockingQueue;
import org.apache.commons.io.IOUtils;
import org.apache.tika.batch.FileResource;
import org.apache.tika.batch.OutputStreamFactory;
import org.apache.tika.batch.fs.AbstractFSConsumer;
import org.apache.tika.batch.fs.FSProperties;
import org.apache.tika.exception.TikaException;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.metadata.TikaCoreProperties;
import org.apache.tika.metadata.filter.MetadataFilter;
import org.apache.tika.metadata.serialization.JsonStreamingSerializer;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.Parser;
import org.apache.tika.sax.AbstractRecursiveParserWrapperHandler;
import org.apache.tika.sax.ContentHandlerFactory;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class StreamOutRPWFSConsumer
extends AbstractFSConsumer {
    private final Parser parser;
    private final ContentHandlerFactory contentHandlerFactory;
    private final OutputStreamFactory fsOSFactory;
    private final MetadataFilter metadataFilter;
    private String outputEncoding = "UTF-8";

    public StreamOutRPWFSConsumer(ArrayBlockingQueue<FileResource> queue, Parser parser, ContentHandlerFactory contentHandlerFactory, OutputStreamFactory fsOSFactory, MetadataFilter metadataFilter) {
        super(queue);
        this.contentHandlerFactory = contentHandlerFactory;
        this.fsOSFactory = fsOSFactory;
        this.parser = parser;
        this.metadataFilter = metadataFilter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean processFileResource(FileResource fileResource) {
        ParseContext context = new ParseContext();
        OutputStream os = this.getOutputStream(this.fsOSFactory, fileResource);
        if (os == null) {
            LOG.debug("Skipping: {}", (Object)fileResource.getMetadata().get(FSProperties.FS_REL_PATH));
            return false;
        }
        InputStream is = this.getInputStream(fileResource);
        if (is == null) {
            IOUtils.closeQuietly(os);
            return false;
        }
        Metadata containerMetadata = fileResource.getMetadata();
        JsonStreamingSerializer writer = new JsonStreamingSerializer(new OutputStreamWriter(os, StandardCharsets.UTF_8));
        WriteoutRPWHandler handler = new WriteoutRPWHandler(this.contentHandlerFactory, writer, this.metadataFilter);
        Throwable thrown = null;
        try {
            this.parse(fileResource.getResourceId(), this.parser, is, handler, containerMetadata, context);
        }
        catch (Throwable t) {
            thrown = t;
        }
        finally {
            try {
                writer.close();
            }
            catch (IOException e) {
                LOG.error("{}", (Object)this.getXMLifiedLogMsg(IO_OS + "json", fileResource.getResourceId(), e, new String[0]));
                throw new RuntimeException(e);
            }
            finally {
                IOUtils.closeQuietly(is);
            }
        }
        if (thrown != null) {
            if (thrown instanceof Error) {
                throw (Error)thrown;
            }
            if (thrown instanceof SecurityException) {
                throw (SecurityException)thrown;
            }
            return false;
        }
        return true;
    }

    public String getOutputEncoding() {
        return this.outputEncoding;
    }

    public void setOutputEncoding(String outputEncoding) {
        this.outputEncoding = outputEncoding;
    }

    private static class WriteoutRPWHandler
    extends AbstractRecursiveParserWrapperHandler {
        private final JsonStreamingSerializer jsonWriter;
        private final MetadataFilter metadataFilter;

        public WriteoutRPWHandler(ContentHandlerFactory contentHandlerFactory, JsonStreamingSerializer writer, MetadataFilter metadataFilter) {
            super(contentHandlerFactory);
            this.jsonWriter = writer;
            this.metadataFilter = metadataFilter;
        }

        @Override
        public void endEmbeddedDocument(ContentHandler contentHandler, Metadata metadata) throws SAXException {
            metadata.add(TikaCoreProperties.TIKA_CONTENT, contentHandler.toString());
            try {
                this.metadataFilter.filter(metadata);
            }
            catch (TikaException e) {
                throw new SAXException(e);
            }
            try {
                this.jsonWriter.add(metadata);
            }
            catch (IOException e) {
                throw new SAXException(e);
            }
        }

        @Override
        public void endDocument(ContentHandler contentHandler, Metadata metadata) throws SAXException {
            this.endEmbeddedDocument(contentHandler, metadata);
        }
    }
}

