/*
 * Decompiled with CFR 0.152.
 */
package org.netpreserve.jwarc;

import java.net.URI;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class URIs {
    private static final Pattern URL_REGEX = Pattern.compile("\\A(?:([a-zA-Z][^:]*):)?[/\\\\\\r\\n\\t]*([^/\\\\]*)([/\\\\][^?#]*)?(?:[?]([^#]*))?(?:[#](.*))?\\Z", 32);
    private static final Pattern AUTHORITY_REGEX = Pattern.compile("([^@]*@)?(.*?)(?::([0-9]+))?", 32);
    private static final Pattern IPV4_REGEX = Pattern.compile("[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}");

    public static URI parseLeniently(String uri) {
        Matcher m3 = URL_REGEX.matcher(uri);
        if (!m3.matches()) {
            throw new IllegalArgumentException();
        }
        try {
            return new URI(m3.group(1), m3.group(2), m3.group(3), m3.group(4), m3.group(5));
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static String toNormalizedSurt(String uri) {
        Matcher urlMatcher = URL_REGEX.matcher(uri);
        if (!urlMatcher.matches()) {
            throw new IllegalArgumentException("invalid URL: " + uri);
        }
        String authority = urlMatcher.group(2);
        String path = urlMatcher.group(3);
        String query = urlMatcher.group(4);
        String fragment = urlMatcher.group(5);
        Matcher authorityMatcher = AUTHORITY_REGEX.matcher(authority);
        if (!authorityMatcher.matches()) {
            throw new IllegalStateException("authority didn't match");
        }
        String host = authorityMatcher.group(2);
        String port = authorityMatcher.group(3);
        StringBuilder output = new StringBuilder();
        if (IPV4_REGEX.matcher(host).matches()) {
            output.append(host);
        } else {
            List<String> hostSegments = Arrays.asList(host.toLowerCase(Locale.ROOT).split("\\."));
            if (hostSegments.get(0).equals("www")) {
                hostSegments = hostSegments.subList(1, hostSegments.size());
            }
            Collections.reverse(hostSegments);
            output.append(URIs.normalizePercentEncoding(String.join((CharSequence)",", hostSegments)));
        }
        if (port != null) {
            output.append(':');
            output.append(port);
        }
        output.append(')');
        if (path != null) {
            output.append(URIs.normalizePercentEncoding(URIs.normalizePathSegments(path.toLowerCase(Locale.ROOT))));
        } else {
            output.append('/');
        }
        if (query != null) {
            output.append('?');
            Object[] params = URIs.normalizePercentEncoding(query).toLowerCase(Locale.ROOT).split("&", -1);
            Arrays.sort(params);
            output.append(String.join((CharSequence)"&", (CharSequence[])params));
        }
        if (fragment != null) {
            output.append('#');
            output.append(URIs.normalizePercentEncoding(fragment));
        }
        return output.toString();
    }

    static String normalizePathSegments(String path) {
        ArrayList<String> output = new ArrayList<String>();
        String[] stringArray = path.split("/");
        int n = stringArray.length;
        block9: for (int i = 0; i < n; ++i) {
            String segment;
            switch (segment = stringArray[i]) {
                case "": 
                case ".": {
                    continue block9;
                }
                case "..": {
                    if (output.isEmpty()) continue block9;
                    output.remove(output.size() - 1);
                    continue block9;
                }
                default: {
                    output.add(segment);
                }
            }
        }
        return "/" + String.join((CharSequence)"/", output);
    }

    static String normalizePercentEncoding(String s2) {
        return URIs.percentEncodeIllegals(URIs.fullyPercentDecode(s2));
    }

    private static String fullyPercentDecode(String s2) {
        String prev;
        do {
            prev = s2;
        } while (!(s2 = URIs.percentDecode(s2)).equals(prev));
        return prev;
    }

    public static String percentEncodeIllegals(String s2) {
        byte[] bytes;
        StringBuilder out = new StringBuilder();
        for (byte rawByte : bytes = s2.getBytes(StandardCharsets.UTF_8)) {
            int b = rawByte & 0xFF;
            if (b == 37 || b == 35 || b <= 32 || b >= 127) {
                out.append('%').append(String.format("%02x", b));
                continue;
            }
            out.append((char)b);
        }
        return out.toString();
    }

    private static String percentDecode(String s2) {
        ByteBuffer bb = null;
        StringBuilder out = new StringBuilder();
        for (int i = 0; i < s2.length(); ++i) {
            if (s2.charAt(i) == '%') {
                if (bb == null) {
                    bb = ByteBuffer.allocate((s2.length() - i) / 3);
                }
                while (i + 2 < s2.length() && s2.charAt(i) == '%') {
                    int d1 = Character.digit(s2.charAt(i + 1), 16);
                    int d2 = Character.digit(s2.charAt(i + 2), 16);
                    if (d1 < 0 || d2 < 0) break;
                    bb.put((byte)(d1 << 4 | d2));
                    i += 3;
                }
                bb.flip();
                URIs.tryDecodeUtf8(bb, out);
                bb.clear();
                if (i >= s2.length()) continue;
                out.append(s2.charAt(i));
                continue;
            }
            out.append(s2.charAt(i));
        }
        return out.toString();
    }

    private static void tryDecodeUtf8(ByteBuffer bb, StringBuilder out) {
        CharsetDecoder decoder = StandardCharsets.UTF_8.newDecoder();
        CharBuffer cb = CharBuffer.allocate(bb.remaining());
        while (bb.hasRemaining()) {
            CoderResult result = decoder.decode(bb, cb, true);
            if (result.isMalformed()) {
                for (int i = 0; i < result.length(); ++i) {
                    out.append('%').append(String.format("%02x", bb.get()));
                }
            }
            out.append(cb.flip());
            cb.clear();
        }
    }
}

