/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.cucadiagram;

import java.util.EnumSet;
import net.sourceforge.plantuml.awt.geom.XDimension2D;
import net.sourceforge.plantuml.awt.geom.XPoint2D;
import net.sourceforge.plantuml.cucadiagram.Rankdir;
import net.sourceforge.plantuml.svek.ShapeType;
import net.sourceforge.plantuml.ugraphic.UEllipse;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.ULine;
import net.sourceforge.plantuml.ugraphic.URectangle;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public enum EntityPosition {
    NORMAL,
    ENTRY_POINT,
    EXIT_POINT,
    INPUT_PIN,
    OUTPUT_PIN,
    EXPANSION_INPUT,
    EXPANSION_OUTPUT,
    PORTIN,
    PORTOUT;

    public static final double RADIUS = 6.0;

    public static EnumSet<EntityPosition> getInputs() {
        return EnumSet.of(ENTRY_POINT, INPUT_PIN, EXPANSION_INPUT, PORTIN);
    }

    public static EnumSet<EntityPosition> getOutputs() {
        return EnumSet.of(EXIT_POINT, OUTPUT_PIN, EXPANSION_OUTPUT, PORTOUT);
    }

    public static EnumSet<EntityPosition> getNormals() {
        return EnumSet.of(NORMAL);
    }

    public boolean isNormal() {
        return this == NORMAL;
    }

    public boolean isInput() {
        return EntityPosition.getInputs().contains((Object)this);
    }

    public boolean isOutput() {
        return EntityPosition.getOutputs().contains((Object)this);
    }

    public void drawSymbol(UGraphic ug, Rankdir rankdir) {
        if (this == NORMAL) {
            throw new IllegalStateException();
        }
        if (this == ENTRY_POINT || this == EXIT_POINT) {
            UEllipse circle = new UEllipse(12.0, 12.0);
            ug.draw(circle);
            if (this == EXIT_POINT) {
                double xc = 6.5;
                double yc = 6.5;
                double radius = 5.5;
                EntityPosition.drawLine(ug, this.getPointOnCircle(6.5, 6.5, 0.7853981633974483, 5.5), this.getPointOnCircle(6.5, 6.5, 3.9269908169872414, 5.5));
                EntityPosition.drawLine(ug, this.getPointOnCircle(6.5, 6.5, -0.7853981633974483, 5.5), this.getPointOnCircle(6.5, 6.5, 2.356194490192345, 5.5));
            }
        } else if (this == INPUT_PIN || this == OUTPUT_PIN) {
            URectangle rectangle = new URectangle(12.0, 12.0);
            ug.draw(rectangle);
        } else if (this == EXPANSION_INPUT || this == EXPANSION_OUTPUT) {
            if (rankdir == Rankdir.TOP_TO_BOTTOM) {
                URectangle rectangle = new URectangle(48.0, 12.0);
                ug.draw(rectangle);
                ULine vline = ULine.vline(12.0);
                ug.apply(UTranslate.dx(12.0)).draw(vline);
                ug.apply(UTranslate.dx(24.0)).draw(vline);
                ug.apply(UTranslate.dx(36.0)).draw(vline);
            } else {
                URectangle rectangle = new URectangle(12.0, 48.0);
                ug.apply(UTranslate.dy(0.0)).draw(rectangle);
                ULine hline = ULine.hline(12.0);
                ug.apply(UTranslate.dy(12.0)).draw(hline);
                ug.apply(UTranslate.dy(24.0)).draw(hline);
                ug.apply(UTranslate.dy(36.0)).draw(hline);
            }
        }
    }

    public XDimension2D getDimension(Rankdir rankdir) {
        if (this == EXPANSION_INPUT || this == EXPANSION_OUTPUT) {
            if (rankdir == Rankdir.TOP_TO_BOTTOM) {
                return new XDimension2D(48.0, 12.0);
            }
            return new XDimension2D(12.0, 48.0);
        }
        return new XDimension2D(12.0, 12.0);
    }

    private XPoint2D getPointOnCircle(double xc, double yc, double angle, double radius) {
        double x = xc + radius * Math.cos(angle);
        double y = yc + radius * Math.sin(angle);
        return new XPoint2D(x, y);
    }

    private static void drawLine(UGraphic ug, XPoint2D p1, XPoint2D p2) {
        double dx = p2.getX() - p1.getX();
        double dy = p2.getY() - p1.getY();
        ug.apply(new UTranslate(p1.getX(), p1.getY())).draw(new ULine(dx, dy));
    }

    public ShapeType getShapeType() {
        if (this == NORMAL) {
            throw new IllegalStateException();
        }
        if (this == ENTRY_POINT || this == EXIT_POINT) {
            return ShapeType.RECTANGLE_PORT;
        }
        return ShapeType.RECTANGLE;
    }

    public static EntityPosition fromStereotype(String label) {
        if ("<<port>>".equalsIgnoreCase(label)) {
            throw new UnsupportedOperationException();
        }
        if ("<<entrypoint>>".equalsIgnoreCase(label)) {
            return ENTRY_POINT;
        }
        if ("<<exitpoint>>".equalsIgnoreCase(label)) {
            return EXIT_POINT;
        }
        if ("<<inputpin>>".equalsIgnoreCase(label)) {
            return INPUT_PIN;
        }
        if ("<<outputpin>>".equalsIgnoreCase(label)) {
            return OUTPUT_PIN;
        }
        if ("<<expansioninput>>".equalsIgnoreCase(label)) {
            return EXPANSION_INPUT;
        }
        if ("<<expansionoutput>>".equalsIgnoreCase(label)) {
            return EXPANSION_OUTPUT;
        }
        return NORMAL;
    }

    public boolean isPort() {
        return this == PORTIN || this == PORTOUT;
    }

    public boolean usePortP() {
        return this.isPort() || this == EXIT_POINT || this == ENTRY_POINT;
    }
}

